unit BigStr8;

interface

const BigString8Puffer = 1000000;

type tBigString8 = class
                    private
                     Puffer      : array[0..BigString8Puffer] of char;
                     PufferPos   : Integer;
                     Ergebnis    : String;
                     function GetErgebnis : String;
                     procedure SetErgebnis(Kette:String);
                     procedure FlushPuffer;
                    public
                     constructor Create;
                     destructor Destroy; Override;
                     procedure AddChar(Zeichen:Char);
                     procedure AddString(Kette:String);
                     property Wert:String read GetErgebnis 
                                          write SetErgebnis;
                   end;

implementation

constructor tBigString8.Create;
begin
 SetErgebnis('');
end;

destructor tBigString8.Destroy;
begin
end;

function tBigString8.GetErgebnis : String;
begin
 FlushPuffer;
 Result:=Ergebnis;
end;

procedure tBigString8.SetErgebnis(Kette:String);
begin
 PufferPos:=-1;
 Ergebnis:=Kette;
end;

procedure tBigString8.AddChar(Zeichen:Char);
begin
 if PufferPos=BigString8Puffer-1 then FlushPuffer;
 inc(PufferPos);
 Puffer[PufferPos]:=Zeichen;
end;

procedure tBigString8.AddString(Kette:String);
var i : integer;
begin
 for i:=1 to length(Kette) do addchar(kette[i]);
end;

procedure tBigString8.FlushPuffer;
var s : String;
begin
 if PufferPos>=0 then begin
   SetString(s,Puffer,PufferPos+1);
   inc(PufferPos);
   Puffer[PufferPos]:=#0;
   Ergebnis:=Ergebnis+s;
   PufferPos:=-1;
 end;
end;

end.

