// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

program Ham_fast;

uses
  SysUtils,
  Classes,
  ActiveX,
  ComObj,
  IniFiles,
  {$IFDEF VER150} Variants, {$ENDIF}
  uPCRE,
  cPCRE,
  cTxtFile,
  cMsgFile;

{$APPTYPE CONSOLE}
{$R *.RES}

var
  HamsterApp    : Variant;
  Cmd, Par      : String;
  SelectedGroups: TStringList;
  regex         : TPCRE;


procedure SelectGroups( GrpSel: String );
var  GrpIdx: Integer;
     GrpNam: String;
begin
     regex.OptCompile := PCRE_CASELESS;
     for GrpIdx:=0 to HamsterApp.NewsGrpCount-1 do begin
        GrpNam := HamsterApp.NewsGrpName( GrpIdx );
        if GrpSel='' then begin
           SelectedGroups.Add( GrpNam );
        end else begin
           if regex.Match( PChar(GrpSel), PChar(GrpNam) ) then begin
              SelectedGroups.Add( GrpNam );
           end;
        end;
     end;
end;

procedure Do_HelpExit( Cmd: String );
Var L: String; sl: TStringlist;

  Procedure WriteInfo(Const Abschnitt: String);
  Var i, p: Integer; s: String;
  Const Einrueckung = '   ';
  begin With sl do begin
     p := IndexOf ('['+LowerCase(Abschnitt+'/'+L)+']');
     If p < 0 then p := IndexOf ('['+LowerCase(Abschnitt+'/en')+']');
     If p < 0 then
        Writeln (Einrueckung + '<no help available>')
     else begin
        For i:=p+1 to Count-1 do begin
           s := Strings[i];
           If (Trim(s) = '') or (s[1]=';') or (s[1]='[') then break;
           If s[1]='#' then System.Delete(s, 1, 1);
           Writeln (Einrueckung + s)
        end
     end
  end end;

Var i: Integer;
    s: string; //HRR
begin
     With TIniFile.Create(ExtractFilePath(ParamStr(0))+'hamster.ini') do try
        L := ReadString ('Setup', 'Language', 'en')
     finally free end;

     sl := TStringlist.Create;
     With sl do try
        s := ChangeFileExt(ParamStr(0), '.dat');  //HRR start
        if not fileexists(s) then begin
          writeln;
          writeln('Helpfile '+s+' not found');
         end else begin
          LoadFromFile(s);
        end;                                      //HHR ende
        For i:=Count-1 downto 0 do begin
           If Copy(Strings[i], 1, 1)='[' then Strings[i] := Trim(LowerCase(Strings[i]))
        end;

        writeln;
        writeln( '--------------------------------------------------------------' );
        writeln( 'Ham_Fast Vr. 0.93' );
        writeln( 'Commandline-utility for Hamster, http://freebee.home.pages.de/' );
        writeln( 'Copyright 1999 by Juergen Haible, <juergen.haible@gmx.de>' );
        writeln( 'Modifications by Heiko Rost, <heiko.rost@gmx.de>');
        writeln( '--------------------------------------------------------------' );

        if (Cmd='') or (Cmd='all') or (Cmd='help') then begin
           writeln;
           writeln( 'ham_fast help [ credits | info | groups | locate | delete | type | export' );
           writeln( '         | import | grep | scoreview | scoretest ]' );
           WriteInfo ('ham_fast help'); writeln;
           writeln( 'ham_fast help all' ); WriteInfo ('ham_fast help all');
        end;

        if (Cmd='all') or (Cmd='credits') then begin
           writeln; writeln( 'Credits' ); WriteInfo('Credits')
        end;

        if (Cmd='all') or (Cmd='info') then begin
           writeln; writeln( 'ham_fast info' ); WriteInfo('ham_fast info')
        end;

        if (Cmd='all') or (Cmd='groups') then begin
           writeln; writeln('ham_fast groups [groupname-patterns...]' );
           WriteInfo('ham_fast groups')
        end;

        if (Cmd='all') or (Cmd='locate') then begin
           writeln; writeln( 'ham_fast locate "<Message-ID>"' );
           writeInfo ('ham_fast locate')
        end;

        if (Cmd='all') or (Cmd='delete') then begin
           writeln; writeln( 'ham_fast delete "<Message-ID>"' );
           writeInfo ('ham_fast delete')
        end;

        if (Cmd='all') or (Cmd='type') then begin
           writeln; writeln( 'ham_fast type [-number] groupname-patterns...' );
           writeInfo ('ham_fast type')
        end;

        if (Cmd='all') or (Cmd='export') then begin
           writeln; writeln( 'ham_fast export [-number] groupname-patterns...' );
           writeInfo ('ham_fast export')
        end;

        if (Cmd='all') or (Cmd='import') then begin
           writeln; writeln( 'ham_fast import [-go"groupnames"] [-ih] [-na] [-fa] [-t] [-x] file-selections...' );  //HRR -fa
           writeInfo ('ham_fast import')
        end;

        if (Cmd='all') or (Cmd='grep') then begin
           writeln; writeln( 'ham_fast grep [options] search-pattern groupname-patterns...' );
           writeInfo ('ham_fast grep')
        end;

        if (Cmd='all') or (Cmd='scoreview') then begin
           writeln; writeln( 'ham_fast scoreview [groupname]' );
           writeInfo ('ham_fast scoreview')
        end;

        if (Cmd='all') or (Cmd='scoretest') then begin
           writeln; writeln( 'ham_fast scoretest ( article-file | Message-ID )' );
           writeInfo ('ham_fast scoretest')
        end;

     finally free end;
     Halt( 0 );
end;

procedure Do_Info;
begin
     writeln( HamsterApp.ControlGetInfo );
end;

procedure Do_Groups;
var  GrpIdx, GrpHdl  : Integer;
     GrpNam          : String;
     iCnt, iMin, iMax: Integer;
begin
     if ParamCount>=2 then begin
        for GrpIdx:=2 to ParamCount do SelectGroups( ParamStr(GrpIdx) );
     end else begin
        SelectGroups( '' );
     end;

     for GrpIdx:=0 to SelectedGroups.Count-1 do begin
        GrpNam := SelectedGroups[GrpIdx];
        GrpHdl := HamsterApp.NewsGrpOpen( GrpNam );
        if GrpHdl>=0 then begin
           iCnt := HamsterApp.NewsArtCount(GrpHdl);
           iMin := HamsterApp.NewsArtNoMin(GrpHdl);
           iMax := HamsterApp.NewsArtNoMax(GrpHdl);
           writeln( GrpNam, ':', iCnt, ':', iMin, ':', iMax );
           HamsterApp.NewsGrpClose( GrpHdl );
        end;
     end;
end;

procedure Do_Type( UseExportFormat: Boolean );
var  GrpIdx, GrpHdl, ArtNo, OnlyNo: Integer;
     GrpNam: String;
begin
     OnlyNo := 0;
     for GrpIdx:=2 to ParamCount do begin
        if copy( ParamStr(GrpIdx), 1, 1 )='-' then begin
           OnlyNo := strtoint( copy(ParamStr(GrpIdx),2,10) );
        end else begin
           SelectGroups( ParamStr(GrpIdx) );
        end;
     end;

     if OnlyNo>0 then begin
        if SelectedGroups.Count=1 then begin
           GrpNam := SelectedGroups[0];
           GrpHdl := HamsterApp.NewsGrpOpen( GrpNam );
           if GrpHdl>=0 then begin
              if UseExportFormat then begin
                 write( HamsterApp.NewsArtTextExport( GrpHdl, OnlyNo ) );
              end else begin
                 write( HamsterApp.NewsArtText( GrpHdl, OnlyNo ) );
              end;
              HamsterApp.NewsGrpClose( GrpHdl );
           end else begin
              writeln( 'ERROR: Could not open group "' + GrpNam + '"!' );
           end;
        end else begin
           writeln( 'ERROR: Only ONE group allowed when selecting article by number!' );
        end;
        exit;
     end;

     for GrpIdx:=0 to SelectedGroups.Count-1 do begin
        GrpNam := SelectedGroups[GrpIdx];
        GrpHdl := HamsterApp.NewsGrpOpen( GrpNam );
        if GrpHdl>=0 then begin
           for ArtNo:=HamsterApp.NewsArtNoMin(GrpHdl) to HamsterApp.NewsArtNoMax(GrpHdl) do begin
              if UseExportFormat then begin
                 write( HamsterApp.NewsArtTextExport( GrpHdl, ArtNo ) );
              end else begin
                 write( HamsterApp.NewsArtText( GrpHdl, ArtNo ) );
              end;
           end;
           HamsterApp.NewsGrpClose( GrpHdl );
        end else begin
           writeln( 'ERROR: Could not open group "' + GrpNam + '"!' );
        end;
     end;
end;

procedure Do_Import;
var  IgnoreHistory, MarkNoArchive, TestOnly: Boolean;
     cmdForteMBox                          : Boolean;  //HRR -fa
     OverrideGroups, ParVal, Path: String;
     No, res, CntRec,{ CntImp,} CntNew: Integer;      //PW 10.02.2001 //no-Header-control
     FileSels: TStringList;
     TS: TSearchRec;
     ArtText{, ArtHdr}: String; //PW 10.02.2001 //no-Header-control
     MsgFile: TMessagefile;
     XMakeMsg: Boolean;

{PW} {no-Header-control}
{
     function HdrMatch( re: String ): Boolean;
     begin
          regex.OptCompile := PCRE_CASELESS or PCRE_MULTILINE;
          Result := regex.Match( PChar(re), PChar(ArtHdr) );
          if not Result then writeln( 'ERROR: Missing ' + re );
     end;
}
{/PW}

     procedure ImportMessage;
//     var  j: Integer; //PW //no-Header-control
     begin
          if ArtText='' then exit;

          inc( CntRec );

{PW} {no-Header-control}
          if Pos( #13#10#13#10, ArtText )=0 then exit; // header-separator
{
          j := Pos( #13#10#13#10, ArtText ); // header-separator
          if j=0 then exit;
          ArtHdr := copy( ArtText, 1, j+1 );

          if not HdrMatch( '^Newsgroups:\s.+' ) then exit;
          if not HdrMatch( '^Subject:\s.+' )    then exit;
          if not HdrMatch( '^From:\s.+' )       then exit;
          if not HdrMatch( '^Date:\s.+' )       then exit;
}
{/PW}

//          inc( CntImp ); //PW 10.02.2001 //no-Header-control
          if TestOnly then begin
             writeln( '### IMPORT ###' );
             writeln( ArtText );
          end else begin
             if HamsterApp.NewsImport( ArtText,
                                       OverrideGroups,
                                       IgnoreHistory,
                                       MarkNoArchive ) then inc(CntNew);
          end;
          ArtText := '';
     end;

begin
     IgnoreHistory  := False;
     MarkNoArchive  := False;
     TestOnly       := False;
     cmdForteMBox   := False;    //HRR -fa
     XMakeMsg       := False;
     OverrideGroups := '';
     FileSels := TStringList.Create;

     for No:=2 to ParamCount do begin
        ParVal := ParamStr( No );
        if      ParVal='-ih'           then IgnoreHistory  := True
        else if ParVal='-fa'           then cmdForteMBox   := True //HRR -fa
        else if ParVal='-na'           then MarkNoArchive  := True
        else if copy(ParVal,1,3)='-go' then OverrideGroups := copy(ParVal,4,255)
        else if ParVal='-t'            then TestOnly := True
        else if ParVal='-x'            then XMakeMsg := True
        else                                FileSels.Add( ParVal );
     end;

     CntRec := 0;
//     CntImp := 0; //PW 10.02.2001 //no-Header-control
     CntNew := 0;

     for No:=0 to FileSels.Count-1 do begin
        Path := ExtractFilePath( ExpandFilename( FileSels[No] ) );
        res := SysUtils.FindFirst( FileSels[No], faAnyFile-faDirectory, TS );
        while res=0 do begin
           if (TS.Attr and faDirectory)=0 then begin
              MsgFile := TMessagefile.Create( Path + TS.Name, MSGFILE_READ);
              MsgFile.ForteMBox:=cmdForteMBox;         //HRR -fa
              if XMakeMsg then MsgFile.MessageFormat:=MSGFMT_TXT2MSG;
              if MsgFile.MessageFormat<>MSGFMT_UNKNOWN then begin
                 while not MsgFile.EndOfFile do begin
                    ArtText := MsgFile.ReadMessage;
                    if ArtText<>'' then ImportMessage;
                 end;
              end;
              MsgFile.Free;
           end;

           res := SysUtils.FindNext( TS );
        end;
        SysUtils.FindClose( TS );
     end;

     FileSels.Free;

     if (CntNew>0) and not TestOnly then HamsterApp.ControlFlush;

     writeln( '# Recognized  : ', CntRec );
//     writeln( '# Importable  : ', CntImp ); //PW 10.02.2001 //no-Header-control
     writeln( '# Imported/New: ', CntNew );
     writeln( ' Please look for warnings in your Hamster-Log if you want to know if your articles could be import.');  //PW|HSR //no-Header-control
end;

procedure Do_Grep;
const WITHFILE     = $0001;  //Ausgabe Gruppe+ArtNo
      WITHLINENO   = $0002;  //Ausgabe Zeilennummer und Zeile
      WITHLINES    = $0004;  //Ausgabe Zeile
      WITHCOUNT    = $0008;  //Ausgabe Anzahl der bereinstimmungen
      WITHARTICLE  = $0010;  //Ausgabe des gesamten Artikels
      WITHEXPORT   = $0020;  //Artikel im Export-Format ausgeben
      WITHARTASTXT = $0040;  //RegExp auf ganzen Artikel nwenden

var PerlRe       : TPCRE;
    ArtTxt       : TStringList;
    ReOpts, ParNo: Integer;
    ParVal       : String;
    WithOpt      : Integer;
    GrpIdx       : Integer;

     procedure GrepGroup( GroupName: String );
     var  GrpHdl, ArtNo, i: Integer;
          MatchCount: Integer;
          FirstLine: Boolean;
begin
 MatchCount := 0;
 GrpHdl := HamsterApp.NewsGrpOpen( GroupName );
 if GrpHdl>=0 then begin
   for ArtNo:=HamsterApp.NewsArtNoMin(GrpHdl) to HamsterApp.NewsArtNoMax(GrpHdl) do begin
    ArtTxt.Text := HamsterApp.NewsArtText( GrpHdl, ArtNo );
    if (WithOpt and WITHARTASTXT)<>0 then begin
      //ganzen Artikel auf einmal auswerten
      if PerlRe.Exec(PChar(ArtTxt.Text),0) then begin
        inc(MatchCount);
        if (WithOpt and WITHFILE)<>0 then begin
          WriteLn('Article:'+GroupName+':'+IntToStr(ArtNo));
        end;
        if (WithOpt and (WITHARTICLE or WITHLINES))<>0 then begin
          if (WithOpt and WITHEXPORT)<>0 then begin
            write( HamsterApp.NewsArtTextExport( GrpHdl, ArtNo ) );
           end else begin
            write( ArtTxt.Text );
          end;
        end;
      end;
     end else begin
      //Artikel zeilenweise auswerten
      FirstLine  := True;
      for i:=0 to ArtTxt.Count-1 do begin
       if PerlRe.Exec( PChar(ArtTxt[i]), 0 ) then begin
         inc( MatchCount );
         if FirstLine then begin
           FirstLine := False;
           if (WithOpt and WITHFILE)<>0 then begin
             writeln( 'Article:' + GroupName + ':' + inttostr(ArtNo) );
           end;
         end;
         if (WithOpt and WITHARTICLE)<>0 then begin
           if (WithOpt and WITHEXPORT)<>0 then begin
             write( HamsterApp.NewsArtTextExport( GrpHdl, ArtNo ) );
            end else begin
             write( ArtTxt.Text );
           end;
          end else begin
           if (WithOpt and WITHLINES)<>0 then begin
             if (WithOpt and WITHLINENO)<>0 then begin
               writeln( i+1, ':', ArtTxt[i] );
              end else begin
               writeln( ArtTxt[i] );
             end;
           end;
         end;
       end;
      end;
    end;
   end;
   HamsterApp.NewsGrpClose( GrpHdl );
   if (WithOpt and WITHCOUNT)<>0 then begin
     writeln( GroupName, ':', MatchCount )
   end;
  end else begin
   writeln( 'ERROR: Could not open group "' + GroupName + '"!' );
 end;
end;

begin
     ReOpts  := 0;
     PerlRe  := nil;
     WithOpt := WITHFILE or WITHLINES;
     ArtTxt  := TStringList.Create;

     for ParNo:=2 to ParamCount do begin
        ParVal := ParamStr( ParNo );

        if      ParVal='-i'  then ReOpts  := ReOpts or PCRE_CASELESS
        else if ParVal='-c'  then WithOpt := WITHCOUNT
        else if ParVal='-l'  then WithOpt := WITHFILE
        else if ParVal='-h'  then WithOpt := WITHLINES
        else if ParVal='-n'  then WithOpt := WithOpt or WITHLINENO
        else if ParVal='-va' then WithOpt := WithOpt or WITHARTICLE
        else if ParVal='-ve' then WithOpt := WITHARTICLE or WITHEXPORT
        else if ParVal='-s'  then begin
                                   WithOpt := WithOpt OR WITHARTASTXT;
                                   ReOpts  := ReOpts or PCRE_DOTALL; 
                                  end
        else begin
           if not Assigned(PerlRe) then begin
              PerlRe := TPCRE.Create( True, ReOpts );
              PerlRe.Compile( PChar(ParVal) );
           end else begin
              SelectGroups( ParVal );
           end;
        end;
     end;

     if Assigned(PerlRe) and (SelectedGroups.Count>0) then begin
        for GrpIdx:=0 to SelectedGroups.Count-1 do begin
           GrepGroup( SelectedGroups[GrpIdx] );
        end;
     end;

     ArtTxt.Free;
     if Assigned(PerlRe) then PerlRe.Free;
end;

procedure Do_Locate( MessageID: String );
var  GrpNam: String;
     ArtNo : Integer;
begin
     if copy(MessageID,1,1)<>'<' then MessageID:='<'+MessageID;
     if copy(MessageID,length(MessageID),1)<>'>' then MessageID:=MessageID+'>';

     if HamsterApp.NewsLocateMID( MessageID, GrpNam, ArtNo ) then begin
        writeln( GrpNam, ':', ArtNo, ':', MessageID );
     end else begin
        writeln( 'ERROR: Message-ID "' + MessageID + '" not found.' );
     end;
end;

procedure Do_Delete( MessageID: String );
begin
     if copy(MessageID,1,1)<>'<' then MessageID:='<'+MessageID;
     if copy(MessageID,length(MessageID),1)<>'>' then MessageID:=MessageID+'>';

     if HamsterApp.NewsDeleteByMID( MessageID ) then begin
        writeln( 'Message ' + MessageID + ' deleted.' );
     end else begin
        writeln( 'ERROR: Message-ID "' + MessageID + '" not found.' );
     end;
end;

procedure Do_ScoreView;
begin
     write( HamsterApp.NewsScoreListFor( ParamStr(2) ) );
end;

procedure Do_ScoreTest( TestMsg: String );
var  GrpNam, MatchLog: String;
     GrpHdl, ArtNo, Score, i: Integer;
     Art: TStringList;
begin
     if TestMsg='' then begin
        writeln( 'ERROR: Missing article-file or Message-ID.' );
        exit;
     end;

     Art := TStringList.Create;

     if TestMsg[1]='<' then begin
        if HamsterApp.NewsLocateMID( TestMsg, GrpNam, ArtNo ) then begin
           GrpHdl := HamsterApp.NewsGrpOpen( GrpNam );
           if GrpHdl>=0 then begin
              Art.Text := HamsterApp.NewsArtText( GrpHdl, ArtNo );
           end else begin
              writeln( 'ERROR: Could not open group "' + GrpNam + '"!' );
           end;
        end else begin
           writeln( 'ERROR: Message-ID "' + TestMsg + '" not found.' );
        end;
     end else begin
        try
           Art.LoadFromFile( TestMsg );
        except
           on E:Exception do begin
              writeln( 'ERROR: Loading file "' + TestMsg + '":' + E.Message );
           end;
        end;
     end;

     if Art.Text='' then begin Art.Free; exit; end;

     GrpNam := '?.?';
     for i:=0 to Art.Count-1 do begin
        if LowerCase(copy(Art[i],1,12))='newsgroups: ' then begin
           GrpNam := copy( Art[i], 13, 255 );
           break;
        end;
        if Art[i]='' then break;
     end;
     i := Pos( ',', GrpNam );
     if i>0 then GrpNam:=copy(GrpNam,1,i-1);

     Score := HamsterApp.NewsScoreTest( GrpNam, Art.Text, MatchLog );
     writeln( 'Test-Group: ', GrpNam );
     writeln( 'Final-Score: ', Score );
     writeln( 'Match-List:' );
     write  ( MatchLog );

     Art.Free;
end;


begin
   CoInitialize( nil ); //NEU//
   try                  //NEU//
     Cmd := '?';
     Par := '';
     if ParamCount>=1 then Cmd:=lowercase(ParamStr(1));
     if ParamCount>=2 then Par:=ParamStr(2);

     if Cmd='?'       then Do_HelpExit( Par );
     if Cmd='help'    then Do_HelpExit( Par );
     if Cmd='credits' then Do_HelpExit( 'credits' );

     if Pos( '|'+Cmd+'|', '|info|groups|type|export|grep|locate|delete|scoreview|scoretest|import|' )=0 then begin
        writeln( 'ERROR: Unknown command "' + Cmd + '"! See "ham_fast help" for usage.' );
        exit;
     end;

     // create 'Hamster.App'-object
     try
        HamsterApp := CreateOleObject( 'Hamster.App' );
     except
        on E:Exception do begin
           writeln( 'Object "Hamster.App" could not be created!' );
           writeln( 'ERROR: ' + E.Message );
           exit;
        end;
     end;

     SelectedGroups := TStringList.Create;
     SelectedGroups.Sorted := True;
     SelectedGroups.Duplicates := dupIgnore;
     regex := TPCRE.Create( False, PCRE_CASELESS );

     // functions
     if Cmd='info'      then Do_Info;
     if Cmd='groups'    then Do_Groups;
     if Cmd='type'      then Do_Type( False );
     if Cmd='export'    then Do_Type( True );
     if Cmd='import'    then Do_Import;
     if Cmd='grep'      then Do_Grep;
     if Cmd='locate'    then Do_Locate( Par );
     if Cmd='delete'    then Do_Delete( Par );
     if Cmd='scoreview' then Do_ScoreView;
     if Cmd='scoretest' then Do_ScoreTest( Par );

     // release 'Hamster.App'-object
     HamsterApp := Unassigned;
     SelectedGroups.Free;
     regex.Free;
  finally              //NEU//
     CoUninitialize;   //NEU//
  end;                 //NEU//
end.
