unit DStatus;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TDlgStatus = class(TForm)
    Label1: TLabel;
    labGruppe: TLabel;
    pGruppen: TProgressBar;
    pGruppe: TProgressBar;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

Procedure AnzeigeOeffnen (Const Titel: String);
Procedure AnzeigeSchliessen;

Procedure GruppenInit (Const Min, Max: Longint);
Procedure GruppenFortschritt (Const Pos: Longint);

Procedure GruppeInit (Const Min, Max: Longint);
Procedure GruppeFortschritt (Const Pos: Longint);
Procedure ZeigeGruppenname (Const Bez: String);

implementation

{$R *.DFM}

Var Dlg: TDlgStatus;

Procedure AnzeigeOeffnen (Const Titel: String);
begin
   Dlg := TDlgStatus.Create(Nil);
   Dlg.Caption := Titel;
   Dlg.Show
end;

Procedure AnzeigeSchliessen;
begin
   Dlg.free
end;

Procedure GruppenInit (Const Min, Max: Longint);
begin
   With Dlg do begin
      pGruppen.Min := Min; pGruppen.Max := Max
   end;
   GruppenFortschritt(0)
end;
Procedure GruppenFortschritt (Const Pos: Longint);
begin
   Dlg.pGruppen.Position := Pos;
   Application.ProcessMessages
end;

Procedure GruppeInit (Const Min, Max: Longint);
begin
   With Dlg do begin
      pGruppe.Min := Min; pGruppe.Max := Max
   end;
   GruppeFortschritt(0)
end;
Procedure GruppeFortschritt (Const Pos: Longint);
begin
   Dlg.pGruppe.Position := Pos;
   Application.ProcessMessages
end;

Procedure ZeigeGruppenname (Const Bez: String);
begin
   Dlg.labGruppe.caption := Bez;
   Application.ProcessMessages
end;

end.
