// ============================================================================
// Internal character maps
// Copyright (c) 2002, Juergen Haible. All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit uCharMaps8;

interface

type
   TByteCharsetHalfMap = array[ 0 .. 127 ] of WideChar;

const

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   HALFMAP_UNDEFINED : TByteCharsetHalfMap = (
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF
   );

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   SETNAMES_US_ASCII = 'US-ASCII ANSI_X3.4-1968 iso-ir-6 ANSI_X3.4-1986 ISO_646.irv:1991 ASCII ISO646-US us IBM367 cp367 csASCII';
   LOWERMAP_US_ASCII : TByteCharsetHalfMap = (
      #$0000, #$0001, #$0002, #$0003, #$0004, #$0005, #$0006, #$0007, #$0008, #$0009, #$000A, #$000B, #$000C, #$000D, #$000E, #$000F,
      #$0010, #$0011, #$0012, #$0013, #$0014, #$0015, #$0016, #$0017, #$0018, #$0019, #$001A, #$001B, #$001C, #$001D, #$001E, #$001F,
      #$0020, #$0021, #$0022, #$0023, #$0024, #$0025, #$0026, #$0027, #$0028, #$0029, #$002A, #$002B, #$002C, #$002D, #$002E, #$002F,
      #$0030, #$0031, #$0032, #$0033, #$0034, #$0035, #$0036, #$0037, #$0038, #$0039, #$003A, #$003B, #$003C, #$003D, #$003E, #$003F,
      #$0040, #$0041, #$0042, #$0043, #$0044, #$0045, #$0046, #$0047, #$0048, #$0049, #$004A, #$004B, #$004C, #$004D, #$004E, #$004F,
      #$0050, #$0051, #$0052, #$0053, #$0054, #$0055, #$0056, #$0057, #$0058, #$0059, #$005A, #$005B, #$005C, #$005D, #$005E, #$005F,
      #$0060, #$0061, #$0062, #$0063, #$0064, #$0065, #$0066, #$0067, #$0068, #$0069, #$006A, #$006B, #$006C, #$006D, #$006E, #$006F,
      #$0070, #$0071, #$0072, #$0073, #$0074, #$0075, #$0076, #$0077, #$0078, #$0079, #$007A, #$007B, #$007C, #$007D, #$007E, #$007F
   );

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   SETNAMES_ISO_8859_1 = 'ISO-8859-1 ISO_8859-1:1987 iso-ir-100 ISO_8859-1 latin1 l1 IBM819 CP819 csISOLatin1';
   UPPERMAP_ISO_8859_1 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00BA, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$00D0, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$00D7, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$00DD, #$00DE, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$00F0, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$00F7, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$00FD, #$00FE, #$00FF
   );

   SETNAMES_ISO_8859_2 = 'ISO-8859-2 ISO_8859-2:1987 iso-ir-101 ISO_8859-2 latin2 l2 csISOLatin2';
   UPPERMAP_ISO_8859_2 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0104, #$02D8, #$0141, #$00A4, #$013D, #$015A, #$00A7, #$00A8, #$0160, #$015E, #$0164, #$0179, #$00AD, #$017D, #$017B,
      #$00B0, #$0105, #$02DB, #$0142, #$00B4, #$013E, #$015B, #$02C7, #$00B8, #$0161, #$015F, #$0165, #$017A, #$02DD, #$017E, #$017C,
      #$0154, #$00C1, #$00C2, #$0102, #$00C4, #$0139, #$0106, #$00C7, #$010C, #$00C9, #$0118, #$00CB, #$011A, #$00CD, #$00CE, #$010E,
      #$0110, #$0143, #$0147, #$00D3, #$00D4, #$0150, #$00D6, #$00D7, #$0158, #$016E, #$00DA, #$0170, #$00DC, #$00DD, #$0162, #$00DF,
      #$0155, #$00E1, #$00E2, #$0103, #$00E4, #$013A, #$0107, #$00E7, #$010D, #$00E9, #$0119, #$00EB, #$011B, #$00ED, #$00EE, #$010F,
      #$0111, #$0144, #$0148, #$00F3, #$00F4, #$0151, #$00F6, #$00F7, #$0159, #$016F, #$00FA, #$0171, #$00FC, #$00FD, #$0163, #$02D9
   );

   SETNAMES_ISO_8859_3 = 'ISO-8859-3 ISO_8859-3:1988 iso-ir-109 ISO_8859-3 latin3 l3 csISOLatin3';
   UPPERMAP_ISO_8859_3 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0126, #$02D8, #$00A3, #$00A4, #$00A4, #$0124, #$00A7, #$00A8, #$0130, #$015E, #$011E, #$0134, #$00AD, #$00AD, #$017B,
      #$00B0, #$0127, #$00B2, #$00B3, #$00B4, #$00B5, #$0125, #$00B7, #$00B8, #$0131, #$015F, #$011F, #$0135, #$00BD, #$00BD, #$017C,
      #$00C0, #$00C1, #$00C2, #$00C2, #$00C4, #$010A, #$0108, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$00CF, #$00D1, #$00D2, #$00D3, #$00D4, #$0120, #$00D6, #$00D7, #$011C, #$00D9, #$00DA, #$00DB, #$00DC, #$016C, #$015C, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E2, #$00E4, #$010B, #$0109, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$00EF, #$00F1, #$00F2, #$00F3, #$00F4, #$0121, #$00F6, #$00F7, #$011D, #$00F9, #$00FA, #$00FB, #$00FC, #$016D, #$015D, #$02D9
   );

   SETNAMES_ISO_8859_4 = 'ISO-8859-4 ISO_8859-4:1988 iso-ir-110 ISO_8859-4 latin4 l4 csISOLatin4';
   UPPERMAP_ISO_8859_4 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0104, #$0138, #$0156, #$00A4, #$0128, #$013B, #$00A7, #$00A8, #$0160, #$0112, #$0122, #$0166, #$00AD, #$017D, #$00AF,
      #$00B0, #$0105, #$02DB, #$0157, #$00B4, #$0129, #$013C, #$02C7, #$00B8, #$0161, #$0113, #$0123, #$0167, #$014A, #$017E, #$014B,
      #$0100, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$012E, #$010C, #$00C9, #$0118, #$00CB, #$0116, #$00CD, #$00CE, #$012A,
      #$0110, #$0145, #$014C, #$0136, #$00D4, #$00D5, #$00D6, #$00D7, #$00D8, #$0172, #$00DA, #$00DB, #$00DC, #$0168, #$016A, #$00DF,
      #$0101, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$012F, #$010D, #$00E9, #$0119, #$00EB, #$0117, #$00ED, #$00EE, #$012B,
      #$0111, #$0146, #$014D, #$0137, #$00F4, #$00F5, #$00F6, #$00F7, #$00F8, #$0173, #$00FA, #$00FB, #$00FC, #$0169, #$016B, #$02D9
   );

   SETNAMES_ISO_8859_5 = 'ISO-8859-5 ISO_8859-5:1988 iso-ir-144 ISO_8859-5 cyrillic csISOLatinCyrillic';
   UPPERMAP_ISO_8859_5 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0401, #$0402, #$0403, #$0404, #$0405, #$0406, #$0407, #$0408, #$0409, #$040A, #$040B, #$040C, #$00AD, #$040E, #$040F,
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0416, #$0417, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E, #$041F,
      #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427, #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E, #$042F,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0436, #$0437, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447, #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$044F,
      #$2116, #$0451, #$0452, #$0453, #$0454, #$0455, #$0456, #$0457, #$0458, #$0459, #$045A, #$045B, #$045C, #$00A7, #$045E, #$045F
   );

   SETNAMES_ISO_8859_6 = 'ISO-8859-6 ISO_8859-6:1987 iso-ir-127 ISO_8859-6 ECMA-114 ASMO-708 arabic csISOLatinArabic';
   UPPERMAP_ISO_8859_6 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$FFFF, #$FFFF, #$FFFF, #$00A4, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$060C, #$00AD, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$061B, #$FFFF, #$FFFF, #$FFFF, #$061F,
      #$FFFF, #$0621, #$0622, #$0623, #$0624, #$0625, #$0626, #$0627, #$0628, #$0629, #$062A, #$062B, #$062C, #$062D, #$062E, #$062F,
      #$0630, #$0631, #$0632, #$0633, #$0634, #$0635, #$0636, #$0637, #$0638, #$0639, #$063A, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$0640, #$0641, #$0642, #$0643, #$0644, #$0645, #$0646, #$0647, #$0648, #$0649, #$064A, #$064B, #$064C, #$064D, #$064E, #$064F,
      #$0650, #$0651, #$0652, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF
   );

   SETNAMES_ISO_8859_7 = 'ISO-8859-7 ISO_8859-7:1987 iso-ir-126 ISO_8859-7 ELOT_928 ECMA-118 greek greek8 csISOLatinGreek';
   UPPERMAP_ISO_8859_7 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$2018, #$2019, #$00A3, #$FFFF, #$FFFF, #$00A6, #$00A7, #$00A8, #$00A9, #$FFFF, #$00AB, #$00AC, #$00AD, #$FFFF, #$2015,
      #$00B0, #$00B1, #$00B2, #$00B3, #$0384, #$0385, #$0386, #$00B7, #$0388, #$0389, #$038A, #$00BB, #$038C, #$00BD, #$038E, #$038F,
      #$0390, #$0391, #$0392, #$0393, #$0394, #$0395, #$0396, #$0397, #$0398, #$0399, #$039A, #$039B, #$039C, #$039D, #$039E, #$039F,
      #$03A0, #$03A1, #$FFFF, #$03A3, #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9, #$03AA, #$03AB, #$03AC, #$03AD, #$03AE, #$03AF,
      #$03B0, #$03B1, #$03B2, #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8, #$03B9, #$03BA, #$03BB, #$03BC, #$03BD, #$03BE, #$03BF,
      #$03C0, #$03C1, #$03C2, #$03C3, #$03C4, #$03C5, #$03C6, #$03C7, #$03C8, #$03C9, #$03CA, #$03CB, #$03CC, #$03CD, #$03CE, #$FFFF
   );

   SETNAMES_ISO_8859_8 = 'ISO-8859-8 ISO_8859-8:1988 iso-ir-138 ISO_8859-8 hebrew csISOLatinHebrew';
   UPPERMAP_ISO_8859_8 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$FFFF, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00D7, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00F7, #$00BB, #$00BC, #$00BD, #$00BE, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$2017,
      #$05D0, #$05D1, #$05D2, #$05D3, #$05D4, #$05D5, #$05D6, #$05D7, #$05D8, #$05D9, #$05DA, #$05DB, #$05DC, #$05DD, #$05DE, #$05DF,
      #$05E0, #$05E1, #$05E2, #$05E3, #$05E4, #$05E5, #$05E6, #$05E7, #$05E8, #$05E9, #$05EA, #$FFFF, #$FFFF, #$200E, #$200F, #$FFFF
   );

   SETNAMES_ISO_8859_9 = 'ISO-8859-9 ISO_8859-9:1989 iso-ir-148 ISO_8859-9 latin5 l5 csISOLatin5';
   UPPERMAP_ISO_8859_9 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00BA, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$011E, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$00D7, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$0130, #$015E, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$011F, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$00F7, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$0131, #$015F, #$00FF
   );

   SETNAMES_ISO_8859_10 = 'ISO-8859-10 iso-ir-157 l6 ISO_8859-10:1992 csISOLatin6 latin6';
   UPPERMAP_ISO_8859_10 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0104, #$0112, #$0122, #$012A, #$0128, #$0136, #$00A7, #$013B, #$0110, #$0160, #$0166, #$017D, #$00AD, #$016A, #$014A,
      #$00B0, #$0105, #$0113, #$0123, #$012B, #$0129, #$0137, #$00B7, #$013C, #$0111, #$0161, #$0167, #$017E, #$2015, #$016B, #$014B,
      #$0100, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$012E, #$010C, #$00C9, #$0118, #$00CB, #$0116, #$00CD, #$00CE, #$00CF,
      #$00D0, #$0145, #$014C, #$00D3, #$00D4, #$00D5, #$00D6, #$0168, #$00D8, #$0172, #$00DA, #$00DB, #$00DC, #$00DD, #$00DE, #$00DF,
      #$0101, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$012F, #$010D, #$00E9, #$0119, #$00EB, #$0117, #$00ED, #$00EE, #$00EF,
      #$00F0, #$0146, #$014D, #$00F3, #$00F4, #$00F5, #$00F6, #$0169, #$00F8, #$0173, #$00FA, #$00FB, #$00FC, #$00FD, #$00FE, #$0138
   );

   SETNAMES_ISO_8859_13 = 'ISO-8859-13';
   UPPERMAP_ISO_8859_13 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$201D, #$00A2, #$00A3, #$00A4, #$201E, #$00A6, #$00A7, #$00D8, #$00A9, #$0156, #$00AB, #$00AC, #$00AD, #$00AE, #$00C6,
      #$00B0, #$00B1, #$00B2, #$00B3, #$201C, #$00B5, #$00B6, #$00B7, #$00F8, #$00B9, #$0157, #$00BB, #$00BC, #$00BD, #$00BE, #$00E6,
      #$0104, #$012E, #$0100, #$0106, #$00C4, #$00C5, #$0118, #$0112, #$010C, #$00C9, #$0179, #$0116, #$0122, #$0136, #$012A, #$013B,
      #$0160, #$0143, #$0145, #$00D3, #$014C, #$00D5, #$00D6, #$00D7, #$0172, #$0141, #$015A, #$016A, #$00DC, #$017B, #$017D, #$00DF,
      #$0105, #$012F, #$0101, #$0107, #$00E4, #$00E5, #$0119, #$0113, #$010D, #$00E9, #$017A, #$0117, #$0123, #$0137, #$012B, #$013C,
      #$0161, #$0144, #$0146, #$00F3, #$014D, #$00F5, #$00F6, #$00F7, #$0173, #$0142, #$015B, #$016B, #$00FC, #$017C, #$017E, #$2019
   );

   SETNAMES_ISO_8859_14 = 'ISO-8859-14 iso-ir-199 ISO_8859-14:1998 ISO_8859-14 latin8 iso-celtic l8';
   UPPERMAP_ISO_8859_14 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$1E02, #$1E03, #$00A3, #$010A, #$010B, #$1E0A, #$00A7, #$1E80, #$00A9, #$1E82, #$1E0B, #$1EF2, #$00AD, #$00AE, #$0178,
      #$1E1E, #$1E1F, #$0120, #$0121, #$1E40, #$1E41, #$00B6, #$1E56, #$1E81, #$1E57, #$1E83, #$1E60, #$1EF3, #$1E84, #$1E85, #$1E61,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$0174, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$1E6A, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$00DD, #$0176, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$0175, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$1E6B, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$00FD, #$0177, #$00FF
   );

   SETNAMES_ISO_8859_15 = 'ISO-8859-15 ISO_8859-15';
   UPPERMAP_ISO_8859_15 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$00A1, #$00A2, #$00A3, #$20AC, #$00A5, #$0160, #$00A7, #$0161, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$017D, #$00B5, #$00B6, #$00B7, #$017E, #$00B9, #$00BA, #$00BB, #$0152, #$0153, #$0178, #$00BF,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$00D0, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$00D7, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$00DD, #$00DE, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$00F0, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$00F7, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$00FD, #$00FE, #$00FF
   );

   SETNAMES_ISO_8859_16 = 'ISO-8859-16';
   UPPERMAP_ISO_8859_16 : TByteCharsetHalfMap = (
      #$0080, #$0081, #$0082, #$0083, #$0084, #$0085, #$0086, #$0087, #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$0091, #$0092, #$0093, #$0094, #$0095, #$0096, #$0097, #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0104, #$0105, #$0141, #$20AC, #$201E, #$0160, #$00A7, #$0161, #$00A9, #$0218, #$00AB, #$0179, #$00AD, #$017A, #$017B,
      #$00B0, #$00B1, #$010C, #$0142, #$017D, #$201D, #$00B6, #$00B7, #$017E, #$010D, #$0219, #$00BB, #$0152, #$0153, #$0178, #$017C,
      #$00C0, #$00C1, #$00C2, #$0102, #$00C4, #$0106, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$0110, #$0143, #$00D2, #$00D3, #$00D4, #$0150, #$00D6, #$015A, #$0170, #$00D9, #$00DA, #$00DB, #$00DC, #$0118, #$021A, #$00DF,
      #$00E0, #$00E1, #$00E2, #$0103, #$00E4, #$0107, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$0111, #$0144, #$00F2, #$00F3, #$00F4, #$0151, #$00F6, #$015B, #$0171, #$00F9, #$00FA, #$00FB, #$00FC, #$0119, #$021B, #$00FF
   );

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   SETNAMES_WINDOWS_1250 = 'windows-1250 cp1250 cp-1250';
   UPPERMAP_WINDOWS_1250 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$FFFF, #$201E, #$2026, #$2020, #$2021, #$FFFF, #$2030, #$0160, #$2039, #$015A, #$0164, #$017D, #$0179,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$FFFF, #$2122, #$0161, #$203A, #$015B, #$0165, #$017E, #$017A,
      #$00A0, #$02C7, #$02D8, #$0141, #$00A4, #$0104, #$00A6, #$00A7, #$00A8, #$00A9, #$015E, #$00AB, #$00AC, #$00AD, #$00AE, #$017B,
      #$00B0, #$00B1, #$02DB, #$0142, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$0105, #$015F, #$00BB, #$013D, #$02DD, #$013E, #$017C,
      #$0154, #$00C1, #$00C2, #$0102, #$00C4, #$0139, #$0106, #$00C7, #$010C, #$00C9, #$0118, #$00CB, #$011A, #$00CD, #$00CE, #$010E,
      #$0110, #$0143, #$0147, #$00D3, #$00D4, #$0150, #$00D6, #$00D7, #$0158, #$016E, #$00DA, #$0170, #$00DC, #$00DD, #$0162, #$00DF,
      #$0155, #$00E1, #$00E2, #$0103, #$00E4, #$013A, #$0107, #$00E7, #$010D, #$00E9, #$0119, #$00EB, #$011B, #$00ED, #$00EE, #$010F,
      #$0111, #$0144, #$0148, #$00F3, #$00F4, #$0151, #$00F6, #$00F7, #$0159, #$016F, #$00FA, #$0171, #$00FC, #$00FD, #$0163, #$02D9
   );

   SETNAMES_WINDOWS_1251 = 'windows-1251 cp1251 cp-1251';
   UPPERMAP_WINDOWS_1251 : TByteCharsetHalfMap = (
      #$0402, #$0403, #$201A, #$0453, #$201E, #$2026, #$2020, #$2021, #$20AC, #$2030, #$0409, #$2039, #$040A, #$040C, #$040B, #$040F,
      #$0452, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$FFFF, #$2122, #$0459, #$203A, #$045A, #$045C, #$045B, #$045F,
      #$00A0, #$040E, #$045E, #$0408, #$00A4, #$0490, #$00A6, #$00A7, #$0401, #$00A9, #$0404, #$00AB, #$00AC, #$00AD, #$00AE, #$0407,
      #$00B0, #$00B1, #$0406, #$0456, #$0491, #$00B5, #$00B6, #$00B7, #$0451, #$2116, #$0454, #$00BB, #$0458, #$0405, #$0455, #$0457,
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0416, #$0417, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E, #$041F,
      #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427, #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E, #$042F,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0436, #$0437, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447, #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$044F
   );

   SETNAMES_WINDOWS_1252 = 'windows-1252 cp1252 cp-1252';
   UPPERMAP_WINDOWS_1252 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$0192, #$201E, #$2026, #$2020, #$2021, #$02C6, #$2030, #$0160, #$2039, #$0152, #$FFFF, #$017D, #$FFFF,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$02DC, #$2122, #$0161, #$203A, #$0153, #$FFFF, #$017E, #$0178,
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00BA, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$00D0, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$00D7, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$00DD, #$00DE, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$00F0, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$00F7, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$00FD, #$00FE, #$00FF
   );

   SETNAMES_WINDOWS_1253 = 'windows-1253 cp1253 cp-1253';
   UPPERMAP_WINDOWS_1253 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$0192, #$201E, #$2026, #$2020, #$2021, #$FFFF, #$2030, #$FFFF, #$2039, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$FFFF, #$2122, #$FFFF, #$203A, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$00A0, #$0385, #$0386, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$FFFF, #$00AB, #$00AC, #$00AD, #$00AE, #$2015,
      #$00B0, #$00B1, #$00B2, #$00B3, #$0384, #$00B5, #$00B6, #$00B7, #$0388, #$0389, #$038A, #$00BB, #$038C, #$00BD, #$038E, #$038F,
      #$0390, #$0391, #$0392, #$0393, #$0394, #$0395, #$0396, #$0397, #$0398, #$0399, #$039A, #$039B, #$039C, #$039D, #$039E, #$039F,
      #$03A0, #$03A1, #$FFFF, #$03A3, #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9, #$03AA, #$03AB, #$03AC, #$03AD, #$03AE, #$03AF,
      #$03B0, #$03B1, #$03B2, #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8, #$03B9, #$03BA, #$03BB, #$03BC, #$03BD, #$03BE, #$03BF,
      #$03C0, #$03C1, #$03C2, #$03C3, #$03C4, #$03C5, #$03C6, #$03C7, #$03C8, #$03C9, #$03CA, #$03CB, #$03CC, #$03CD, #$03CE, #$FFFF
   );

   SETNAMES_WINDOWS_1254 = 'windows-1254 cp1254 cp-1254';
   UPPERMAP_WINDOWS_1254 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$0192, #$201E, #$2026, #$2020, #$2021, #$02C6, #$2030, #$0160, #$2039, #$0152, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$02DC, #$2122, #$0161, #$203A, #$0153, #$FFFF, #$FFFF, #$0178,
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00BA, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$011E, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$00D7, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$0130, #$015E, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$011F, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$00F7, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$0131, #$015F, #$00FF
   );

   SETNAMES_WINDOWS_1255 = 'windows-1255 cp1255 cp-1255';
   UPPERMAP_WINDOWS_1255 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$0192, #$201E, #$2026, #$2020, #$2021, #$02C6, #$2030, #$FFFF, #$2039, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$02DC, #$2122, #$FFFF, #$203A, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$00A0, #$00A1, #$00A2, #$00A3, #$20AA, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00D7, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00F7, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$05B0, #$05B1, #$05B2, #$05B3, #$05B4, #$05B5, #$05B6, #$05B7, #$05B8, #$05B9, #$FFFF, #$05BB, #$05BC, #$05BD, #$05BE, #$05BF,
      #$05C0, #$05C1, #$05C2, #$05C3, #$05F0, #$05F1, #$05F2, #$05F3, #$05F4, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$05D0, #$05D1, #$05D2, #$05D3, #$05D4, #$05D5, #$05D6, #$05D7, #$05D8, #$05D9, #$05DA, #$05DB, #$05DC, #$05DD, #$05DE, #$05DF,
      #$05E0, #$05E1, #$05E2, #$05E3, #$05E4, #$05E5, #$05E6, #$05E7, #$05E8, #$05E9, #$05EA, #$FFFF, #$FFFF, #$200E, #$200F, #$FFFF
   );

   SETNAMES_WINDOWS_1256 = 'windows-1256 cp1256 cp-1256';
   UPPERMAP_WINDOWS_1256 : TByteCharsetHalfMap = (
      #$20AC, #$067E, #$201A, #$0192, #$201E, #$2026, #$2020, #$2021, #$02C6, #$2030, #$0679, #$2039, #$0152, #$0686, #$0698, #$0688,
      #$06AF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$06A9, #$2122, #$0691, #$203A, #$0153, #$200C, #$200D, #$06BA,
      #$00A0, #$060C, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$06BE, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$061B, #$00BB, #$00BC, #$00BD, #$00BE, #$061F,
      #$06C1, #$0621, #$0622, #$0623, #$0624, #$0625, #$0626, #$0627, #$0628, #$0629, #$062A, #$062B, #$062C, #$062D, #$062E, #$062F,
      #$0630, #$0631, #$0632, #$0633, #$0634, #$0635, #$0636, #$00D7, #$0637, #$0638, #$0639, #$063A, #$0640, #$0641, #$0642, #$0643,
      #$00E0, #$0644, #$00E2, #$0645, #$0646, #$0647, #$0648, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$0649, #$064A, #$00EE, #$00EF,
      #$064B, #$064C, #$064D, #$064E, #$00F4, #$064F, #$0650, #$00F7, #$0651, #$00F9, #$0652, #$00FB, #$00FC, #$200E, #$200F, #$06D2
   );

   SETNAMES_WINDOWS_1257 = 'windows-1257 cp1257 cp-1257';
   UPPERMAP_WINDOWS_1257 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$FFFF, #$201E, #$2026, #$2020, #$2021, #$FFFF, #$2030, #$FFFF, #$2039, #$FFFF, #$00A8, #$02C7, #$00B8,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$FFFF, #$2122, #$FFFF, #$203A, #$FFFF, #$00AF, #$02DB, #$FFFF,
      #$00A0, #$FFFF, #$00A2, #$00A3, #$00A4, #$FFFF, #$00A6, #$00A7, #$00D8, #$00A9, #$0156, #$00AB, #$00AC, #$00AD, #$00AE, #$00C6,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00F8, #$00B9, #$0157, #$00BB, #$00BC, #$00BD, #$00BE, #$00E6,
      #$0104, #$012E, #$0100, #$0106, #$00C4, #$00C5, #$0118, #$0112, #$010C, #$00C9, #$0179, #$0116, #$0122, #$0136, #$012A, #$013B,
      #$0160, #$0143, #$0145, #$00D3, #$014C, #$00D5, #$00D6, #$00D7, #$0172, #$0141, #$015A, #$016A, #$00DC, #$017B, #$017D, #$00DF,
      #$0105, #$012F, #$0101, #$0107, #$00E4, #$00E5, #$0119, #$0113, #$010D, #$00E9, #$017A, #$0117, #$0123, #$0137, #$012B, #$013C,
      #$0161, #$0144, #$0146, #$00F3, #$014D, #$00F5, #$00F6, #$00F7, #$0173, #$0142, #$015B, #$016B, #$00FC, #$017C, #$017E, #$02D9
   );

   SETNAMES_WINDOWS_1258 = 'windows-1258 cp1258 cp-1258';
   UPPERMAP_WINDOWS_1258 : TByteCharsetHalfMap = (
      #$20AC, #$FFFF, #$201A, #$0192, #$201E, #$2026, #$2020, #$2021, #$02C6, #$2030, #$FFFF, #$2039, #$0152, #$FFFF, #$FFFF, #$FFFF,
      #$FFFF, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014, #$02DC, #$2122, #$FFFF, #$203A, #$0153, #$FFFF, #$FFFF, #$0178,
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7, #$00A8, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$00B4, #$00B5, #$00B6, #$00B7, #$00B8, #$00B9, #$00BA, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$00C0, #$00C1, #$00C2, #$0102, #$00C4, #$00C5, #$00C6, #$00C7, #$00C8, #$00C9, #$00CA, #$00CB, #$0300, #$00CD, #$00CE, #$00CF,
      #$0110, #$00D1, #$0309, #$00D3, #$00D4, #$01A0, #$00D6, #$00D7, #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$01AF, #$0303, #$00DF,
      #$00E0, #$00E1, #$00E2, #$0103, #$00E4, #$00E5, #$00E6, #$00E7, #$00E8, #$00E9, #$00EA, #$00EB, #$0301, #$00ED, #$00EE, #$00EF,
      #$0111, #$00F1, #$0323, #$00F3, #$00F4, #$01A1, #$00F6, #$00F7, #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$01B0, #$20AB, #$00FF
   );

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   SETNAMES_IBM437 = 'IBM437 cp437 437 csPC8CodePage437 cp-437';
   UPPERMAP_IBM437 : TByteCharsetHalfMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7, #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$00EC, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9, #$00FF, #$00D6, #$00DC, #$00A2, #$00A3, #$00A5, #$20A7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA, #$00BF, #$2310, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556, #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F, #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B, #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4, #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248, #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0
   );

   SETNAMES_IBM850 = 'IBM850 cp850 850 csPC850Multilingual cp-850';
   UPPERMAP_IBM850 : TByteCharsetHalfMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7, #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$00EC, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9, #$00FF, #$00D6, #$00DC, #$00F8, #$00A3, #$00D8, #$00D7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA, #$00BF, #$00AE, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$00C1, #$00C2, #$00C0, #$00A9, #$2563, #$2551, #$2557, #$255D, #$00A2, #$00A5, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$00E3, #$00C3, #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$00A4,
      #$00F0, #$00D0, #$00CA, #$00CB, #$00C8, #$0131, #$00CD, #$00CE, #$00CF, #$2518, #$250C, #$2588, #$2584, #$00A6, #$00CC, #$2580,
      #$00D3, #$00DF, #$00D4, #$00D2, #$00F5, #$00D5, #$00B5, #$00FE, #$00DE, #$00DA, #$00DB, #$00D9, #$00FD, #$00DD, #$00AF, #$00B4,
      #$00AD, #$00B1, #$2017, #$00BE, #$00B6, #$00A7, #$00F7, #$00B8, #$00B0, #$00A8, #$00B7, #$00B9, #$00B3, #$00B2, #$25A0, #$00A0
   );

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

   SETNAMES_KOI8_R = 'KOI8-R csKOI8R';
   UPPERMAP_KOI8_R : TByteCharsetHalfMap = (
      #$2500, #$2502, #$250C, #$2510, #$2514, #$2518, #$251C, #$2524, #$252C, #$2534, #$253C, #$2580, #$2584, #$2588, #$258C, #$2590,
      #$2591, #$2592, #$2593, #$2320, #$25A0, #$2219, #$221A, #$2248, #$2264, #$2265, #$00A0, #$2321, #$00B0, #$00B2, #$00B7, #$00F7,
      #$2550, #$2551, #$2552, #$0451, #$2553, #$2554, #$2555, #$2556, #$2557, #$2558, #$2559, #$255A, #$255B, #$255C, #$255D, #$255E,
      #$255F, #$2560, #$2561, #$0401, #$2562, #$2563, #$2564, #$2565, #$2566, #$2567, #$2568, #$2569, #$256A, #$256B, #$256C, #$00A9,
      #$044E, #$0430, #$0431, #$0446, #$0434, #$0435, #$0444, #$0433, #$0445, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E,
      #$043F, #$044F, #$0440, #$0441, #$0442, #$0443, #$0436, #$0432, #$044C, #$044B, #$0437, #$0448, #$044D, #$0449, #$0447, #$044A,
      #$042E, #$0410, #$0411, #$0426, #$0414, #$0415, #$0424, #$0413, #$0425, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E,
      #$041F, #$042F, #$0420, #$0421, #$0422, #$0423, #$0416, #$0412, #$042C, #$042B, #$0417, #$0428, #$042D, #$0429, #$0427, #$042A
   );

   // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

implementation

end.
