// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit uType; // type declarations      

interface

{$INCLUDE Compiler.inc}

type
   // local server types and controls
   TServerTypes    = ( stNNTP, stPOP3, stSMTP, stRECO );
   TServerControls = ( scSTOP, scSTART, scRESTART,
                       scIsActive, scClientCount );

   // SOCKS support
   TSocksVersion        = ( svNoSocks, svSocks4, svSocks4A, svSocks5 );
   TSocksAuthentication = ( saNoAuthentication, saUsernamePassword );
   TSocksProfile = record // profile for SOCKS server usage
      Version: TSocksVersion;
      Server : String;
      Port   : Integer;
      Auth   : TSocksAuthentication;
      User   : String;
      Pass   : String;
   end;

   // SSL/TLS support
   TSslTlsMode = ( sslNone, sslPort, sslTLS );

   // state of global lists
   TGlobalListMarker = ( glOPEN, glDONE, glTEST );

   // classes of active newsgroups
   TActiveClass = ( aclUnknown, aclInternal, aclLocal, aclWasPulled, aclIsPulled );

   // classification of threads
   TActiveThreadTypes = ( attMaintenance, attTransfer, attScript, attUserTask );
   TThreadFreeTypes   = ( tftFreeByCode, tftFreeOnTerminate );

   // used to report current state to parent thread
   TReportSubStateInfo = procedure( NewSubState: String ) of object;

   // function for service checkpoints
   TNewCheckPointFunc = function ( dwWaitHint: Cardinal ): Boolean;

implementation

end.
