// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit uConst; // constants    

interface

{$INCLUDE Compiler.inc}

uses uType, cLogFile;

// -------------------------------------------------------------- General -----

const
  TAB  =  #9;
  LF   = #10;
  CR   = #13;
  SP   = #32;
  CRLF = CR + LF;

// -------------------------------------------------------------- Logfile -----

const
   LOGID_ERROR  = cLogFile.LOGID_ERROR;
   LOGID_WARN   = cLogFile.LOGID_WARN;
   LOGID_SYSTEM = cLogFile.LOGID_SYSTEM;
   LOGID_INFO   = cLogFile.LOGID_INFO;
   LOGID_DETAIL = cLogFile.LOGID_DETAIL;
   LOGID_DEBUG  = cLogFile.LOGID_DEBUG;
   LOGID_STATUS = cLogFile.LOGID_STATUS;
   LOGID_FULL   = cLogFile.LOGID_FULL;

// ------------------------------------------------------------ Filenames -----

const
   CFGFILE_HAMSTER     = 'Hamster.ini';
   CFGFILE_SERVER_NNTP = 'Server.hst';
   CFGFILE_SERVER_POP3 = 'SrvPOP3.hst';
   CFGFILE_SERVER_SMTP = 'SrvSMTP.hst';
   CFGFILE_NEWSGROUPS  = 'Groups.hst';
   CFGFILE_NEWSPULLS   = 'Pulls.hst';
   CFGFILE_SCORES      = 'Scores.hst';
   CFGFILE_MAILFILT    = 'MailFilt.hst';
   CFGFILE_MAILTRAP    = 'MailTrap.hst';
   CFGFILE_PASS        = 'Password.!!!';
   CFGFILE_IPACCESS    = 'IPAccess.hst';
   CFGFILE_RCPROFILES  = 'RCProfiles.hst';
   CFGFILE_HSCACTIONS  = 'HscActions.hst';
   CFGFILE_SMTPROUTER  = 'SmtpRouter.hst';
   CFGFILE_SCHEDULER   = 'Scheduler.hst';

   SRVFILE_ALLDESCS    = 'alldescs.txt';
   SRVFILE_INI         = 'Server.ini';
   SRVFILE_HELPTEXT    = 'help.txt';
   SRVFILE_GROUPS      = 'groups.txt';
   SRVFILE_GRPDESCS    = 'grpdescs.txt';
   SRVFILE_OVERVIEWFMT = 'overview.txt';
   SRVFILE_GREETING    = 'greeting.txt';
   SRVFILE_GETMIDLIST  = 'getmids.txt';

   GRPFILE_SAVEGROUP   = 'savegrp.ini';
   GRPFILE_KILLSLOG    = 'kills.log';
   GRPFILE_DAT         = 'data.dat';
   GRPFILE_IDX         = 'data.idx';
   GRPFILE_INI         = 'data.ini';

   LOGFILE_EXTENSION    = '.log';
   LOGFILE_RASDIAL      = 'RasDial';
   LOGFILE_NNTPSERVER   = 'NntpServer';
   LOGFILE_SMTPSERVER   = 'SmtpServer';
   LOGFILE_NEWSOUT      = 'NewsOut';
   LOGFILE_MAILOUT      = 'MailOut';
   LOGFILE_MAILIN       = 'MailIn';
   LOGFILE_MAILFILTERS  = 'MailFilters';
   LOGFILE_MAILTRAPHITS = 'MailTraps';
   LOGFILE_SPAMREPORT   = 'SpamReport.log';

   REPFILE_EXTENSION    = '.htm';
   REPFILE_INDEXPAGE    = 'Hamster-index' + REPFILE_EXTENSION;
   REPFILE_REPORTTITLES = 'ReportTitles.txt';

   CACHEFILE_SCRIPTDNSCACHE = 'ScriptDnsCache.hst';

// -------------------------------------------------------- ServerControl -----

const
   iFALSE = Integer( 0 );
   iTRUE  = Integer( 1 );

const
   ServerNames: array[ TServerTypes ] of String
              = ( 'NNTP', 'POP3', 'SMTP', 'RECO' );

// ----------------------------------------------------------- Live-Queue -----

const
   // Live Message Types

   // type markers
   LMINF = $1000; // information
   LMREQ = $2000; // request
   LMREP = $4000; // reply
   LMXXX = $8000; // special

   // information ($1xxx)
   LMINF_LOCALSERVER_STATES  = LMINF or $020;
   LMINF_LOCALSERVER_CLIENTS = LMINF or $021;  
   LMINF_COUNTERS_LIST       = LMINF or $030;
   LMINF_TASKS_LIST          = LMINF or $040;
   LMINF_LOGFILE_ADD         = LMINF or $050;

   // requests ($2xxx)
   LMREQ_APP_SETTING_GET     = LMREQ or $000;
   LMREQ_APP_SETTING_SET     = LMREQ or $001;

   LMREQ_HAM_SETTING_GET     = LMREQ or $010;
   LMREQ_HAM_SETTING_SET     = LMREQ or $011;

   LMREQ_LOCALSERVER_CONTROL = LMREQ or $020;
   LMREQ_LOCALSERVER_CLIENTS = LMREQ or $021;

   LMREQ_COUNTERS_LIST       = LMREQ or $030;
   LMREQ_COUNTERS_RESET      = LMREQ or $031;

   LMREQ_TASKS_LIST          = LMREQ or $040;
   LMREQ_TASKS_STOPALL       = LMREQ or $041;
   LMREQ_TASKS_STOPBYID      = LMREQ or $042;

   LMREQ_LOGFILE_LIST        = LMREQ or $050;
   LMREQ_LOGFILE_ROTATE      = LMREQ or $051;
   LMREQ_LOGFILE_LISTERRORS  = LMREQ or $052;
   LMREQ_LOGFILE_FIND        = LMREQ or $053;

   LMREQ_GROUPS_LIST         = LMREQ or $100;
   LMREQ_GROUPS_ADD          = LMREQ or $101;
   LMREQ_GROUPS_DELETE       = LMREQ or $102;
   LMREQ_GROUPS_SETTING_GET  = LMREQ or $103;
   LMREQ_GROUPS_SETTING_SET  = LMREQ or $104;

   LMREQ_PULLS_LIST          = LMREQ or $120;
   LMREQ_PULLS_ADD           = LMREQ or $121;
   LMREQ_PULLS_DELETE        = LMREQ or $122;
   LMREQ_PULLS_SETTING_GET   = LMREQ or $123;
   LMREQ_PULLS_SETTING_SET   = LMREQ or $124;

   LMREQ_SRVNNTP_LIST        = LMREQ or $140;
   LMREQ_SRVNNTP_ADD         = LMREQ or $141;
   LMREQ_SRVNNTP_DEL         = LMREQ or $142;
   LMREQ_SRVNNTP_SETTING_GET = LMREQ or $143;
   LMREQ_SRVNNTP_SETTING_SET = LMREQ or $144;

   LMREQ_SRVPOP3_LIST        = LMREQ or $160;
   LMREQ_SRVPOP3_ADD         = LMREQ or $161;
   LMREQ_SRVPOP3_DEL         = LMREQ or $162;
   LMREQ_SRVPOP3_SETTING_GET = LMREQ or $163;
   LMREQ_SRVPOP3_SETTING_SET = LMREQ or $164;

   LMREQ_SRVSMTP_LIST        = LMREQ or $180;
   LMREQ_SRVSMTP_ADD         = LMREQ or $181;
   LMREQ_SRVSMTP_DEL         = LMREQ or $182;
   LMREQ_SRVSMTP_SETTING_GET = LMREQ or $183;
   LMREQ_SRVSMTP_SETTING_SET = LMREQ or $184;

   LMREQ_SCRIPT_DIR          = LMREQ or $200;
   LMREQ_SCRIPT_GET          = LMREQ or $201;
   LMREQ_SCRIPT_PUT          = LMREQ or $202;
   LMREQ_SCRIPT_DELETE       = LMREQ or $203;
   LMREQ_SCRIPT_START        = LMREQ or $204;

   LMREQ_PASSWORD_LIST       = LMREQ or $300;
   LMREQ_PASSWORD_GET        = LMREQ or $301;
   LMREQ_PASSWORD_SET        = LMREQ or $302;

   LMREQ_ACCOUNTS_LIST       = LMREQ or $320;
   LMREQ_ACCOUNTS_ADD        = LMREQ or $321;
   LMREQ_ACCOUNTS_DEL        = LMREQ or $322;
   LMREQ_ACCOUNTS_GET        = LMREQ or $323;
   LMREQ_ACCOUNTS_SET        = LMREQ or $324;

   LMREQ_RCPROFILES_LIST     = LMREQ or $340;

   LMREQ_MAILLISTS_LIST      = LMREQ or $360;
   LMREQ_MAILLISTS_DEL       = LMREQ or $362;
   LMREQ_MAILLISTS_GET       = LMREQ or $363;
   LMREQ_MAILLISTS_SET       = LMREQ or $364;

   LMREQ_USERTASKS_LIST      = LMREQ or $380;
   LMREQ_USERTASKS_DEL       = LMREQ or $382;
   LMREQ_USERTASKS_GET       = LMREQ or $383;
   LMREQ_USERTASKS_SET       = LMREQ or $384;

   LMREQ_FILE_GET            = LMREQ or $3F0;
   LMREQ_FILE_SET            = LMREQ or $3F1;

   LMREQ_REPORTS_LIST        = LMREQ or $400;

   LMREQ_RUN_PURGE           = LMREQ or $500;
   LMREQ_RUN_REBUILDHISTORY  = LMREQ or $501;
   LMREQ_RUN_REBUILDLISTS    = LMREQ or $502;
   LMREQ_RUN_STATISTICS      = LMREQ or $503;
   LMREQ_RUN_AUTOUNSUBSCRIBE = LMREQ or $504;
   LMREQ_RUN_REPORTS         = LMREQ or $505;

   LMREQ_RUN_RASDIAL         = LMREQ or $520;
   LMREQ_RUN_RASHANGUP       = LMREQ or $521;

   LMREQ_RUN_FETCHMAIL       = LMREQ or $540;
   LMREQ_RUN_SENDMAIL        = LMREQ or $550;
   LMREQ_RUN_SENDMAILMX      = LMREQ or $551;
   LMREQ_RUN_NEWSJOBS        = LMREQ or $560;
   LMREQ_RUN_USERTASK        = LMREQ or $570;

   LMREQ_INVALID             = LMREQ or $FFF;

   // replies ($4xxx)
   LMREP_OK                  = LMREP or $000;

   LMREP_FAILED              = LMREP or $100;
   LMREP_UNKNOWN_ITEM        = LMREP or $101;

   LMREP_EXCEPTION           = LMREP or $200;
   LMREP_UNKNOWN_MESSAGE     = LMREP or $201;

   // special ($8xxx)
   LMXXX_HC_GUI_LOG          = LMXXX or $100;
   LMXXX_RC_LIVE_OFF         = LMXXX or $888;

// -------------------------------------------------------- Configuration -----

const
   // application settings
   asServiceFile             = 1;
   asServiceName             = 2;
   asDisplayName             = 3;
   asDependencies            = 4;
   asInteractive             = 5;
   asObjectPrefix            = 6;
   asServiceVersion          = 7;

   asLogFileMask             = 10;
   asLogViewMask             = 11;
   asLogTaskMask             = 12;
   asLogFileMax              = 13;
   asLogViewMax              = 14;
   asLogMSecs                = 15; 

   asPathStartup             = 20;   asPathFirst = asPathStartup;
   asPathBase                = 21;          
   asPathLogs                = 22;
   asPathServer              = 23;
   asPathGroups              = 24;
   asPathMails               = 25;
   asPathNewsOut             = 26;
   asPathMailOut             = 27;
   asPathNewsErr             = 28;
   asPathScripts             = 29;
   asPathModules             = 30;
   asPathReports             = 31;   asPathLast = asPathReports;
   // Note: 32-39 reserved for future path settings


const
   // hamster settings
   hsFQDNforMID              = 1;
   hsIsLocalDomain           = 2;
   hsTasksLimit              = 3;
   hsLocalTimeoutInactivity  = 4;
   hsLocalTimeoutQuitDelay   = 5;

   hsLocalNntpAutostart      = 10;
   hsLocalNntpBind           = 11;
   hsLocalNntpPort           = 12;
   hsLocalNntpClients        = 13;
   hsLocalNntpLimitLineLen   = 14;
   hsLocalNntpLimitTextSize  = 15;
   hsLocalNntpGetUnknownMIDs = 16;
   hsLocalNntpLocalInjection = 17;

   hsLocalPop3Autostart      = 20;
   hsLocalPop3Bind           = 21;
   hsLocalPop3Port           = 22;
   hsLocalPop3Clients        = 23;
   hsLocalPop3LimitLineLen   = 24;
   hsLocalPop3LimitTextSize  = 25;
   hsLocalPop3SASL           = 26;

   hsLocalSmtpAutostart      = 30;
   hsLocalSmtpBind           = 31;
   hsLocalSmtpPort           = 32;
   hsLocalSmtpClients        = 33;
   hsLocalSmtpLimitLineLen   = 34;
   hsLocalSmtpLimitTextSize  = 35;
   hsLocalSmtpSASL           = 36;
   hsLocalSmtpAuthReq        = 37;
   hsLocalSmtpEAuthReq       = 38;
   hsLocalSmtpAfterPop3Time  = 39;

   hsLocalRecoAutostart      = 40;
   hsLocalRecoBind           = 41;
   hsLocalRecoPort           = 42;
   hsLocalRecoClients        = 43;
   hsLocalRecoLimitLineLen   = 44;
   hsLocalRecoLimitTextSize  = 45;
   hsLocalRecoSASL           = 46;

   hsLocalSmtpNoAuthForLocal = 50; 
   hsLocalNntpSameCli        = 51;
   hsLocalPop3SameCli        = 52;
   hsLocalSmtpSameCli        = 53;
   hsLocalRecoSameCli        = 54;
   hsLocalNntpInactivitySec  = 55;
   hsLocalPop3InactivitySec  = 56;
   hsLocalSmtpInactivitySec  = 57;
   hsLocalRecoInactivitySec  = 58;
   hsLocalSmtpApplyTraps     = 59;

   hsGenerateNewsMID         = 60;
   hsGenerateMailMID         = 61;
   hsMailAddXHamster         = 62;
   hsMailAddReceived         = 63;
   hsNewsAddXHamster         = 64;
   hsNewsAddXTrace           = 65;
   hsPullLimit               = 66;
   hsPullLimitFirst          = 67;
   hsAutoUnsubscribePulls    = 68;
   hsAutoUnsubscribeGroups   = 69;
   hsPurgeArticlesKeepDays   = 70;
   hsPurgeHistoryKeepDays    = 71;
   hsPurgeKillsKeepDays      = 72;
   hsPurgeMHistoryKeepDays   = 73;
   hsRemoteTimeoutConnect    = 74;
   hsRemoteTimeoutCommand    = 75;
   hsPasswordCodeBase        = 76;
   hsHistoryChunkBits        = 77;
   hsScoreLogLimit           = 78;
   hsPostServer              = 79;
   hsSmtpServer              = 80;
   hsLeaveMailsOnServer      = 81;
   hsIgnoreAlreadyLoaded     = 82;
   hsFilterByUIDL            = hsIgnoreAlreadyLoaded;
   hsMailSizeIgnore          = 83;
   hsMailSizeKill            = 84;
   hsMailSizeNotify          = 85;
   hsNoOfTopLinesToLoad      = 86;
   hsSendMailAttemptsMax     = 87;
   hsSendMailAttemptsDel     = 88;
   hsGateAddFUpPoster        = 89;

   hsDailyUnsubscribe        = 90;
   hsDailyPurge              = 91;
   hsDailyBuildLists         = 92;
   hsDailyStatistics         = 93;
   hsStatsLastInfoMsg        = 94;
   hsLastAutoUnsubscribe     = 95;
   hsLastDaily               = 96;

   hsMailDeleteLoadedAfter   = 110;
   hsMailJunkAccount         = 111;
   hsMailTrapAcceptScore     = 112;
   hsMailTrapDeleteScore     = 113;
   hsMailTopSkipSize         = 114;
   hsMailJunkSkipFiltKill    = 115;
   hsMailJunkSkipTrapDelete  = 116;
   hsMailJunkSkipTrapScore   = 117;
   hsMailJunkSkipScoreLimit  = 118;
   hsMailSpamReportAccount   = 119;
   hsIgnoreAlreadyFiltered   = 120;
   hsLeaveButDeleteFiltered  = 121;

   hsSocksVersion            = 150;
   hsSocksServer             = 151;
   hsSocksPort               = 152;
   hsSocksAuth               = 153;
   hsSocksUser               = 154;
   hsSocksPass               = 155;

   hsHamGroupDefault         = 160;   hsHamGroupFirst = hsHamGroupDefault;
   hsHamGroupPostOk          = 161;
   hsHamGroupPostErrors      = 162;
   hsHamGroupStatistics      = 163;
   hsHamGroupCancelNotify    = 164;
   hsHamGroupNewGroups       = 165;
   hsHamGroupUnknownGroup    = 166;
   hsHamGroupPullErrors      = 167;   hsHamGroupLast = hsHamGroupPullErrors;
   // Note: 168-179 reserved for future special groups


const
   // server settings
   ssTimeoutConnect          = 1;
   ssTimeoutCommand          = 2;
   ssUseSocks                = 3;
   ssDisabled                = 4;
   ssSSLMode                 = 5;
   ssSSLVersion              = 6;
   ssSSLCipher               = 7;

   ssPop3LocalUser           = 10;
   ssPop3FilterSection       = 11;
   ssPop3LeaveOnServer       = 12;
   ssPop3UseAuthPass         = 13;
   ssPop3UseAuthApop         = 14;
   ssPop3UseAuthAuth         = 15;
   ssPop3UseSasl             = 16;
   ssPop3AutoDistribute      = 17;

   ssSmtpUseAuth             = 20;
   ssSmtpUseSasl             = 21;

   ssNntpReadOnly            = 30;
   ssNntpPullThreads         = 31;
   ssNntpReloadGroups        = 32;
   ssNntpReloadGroupsDT      = 33;
   ssNntpLoadDescsMode       = 34;
   ssNntpReloadDescs         = 35;
   ssNntpReloadDescsDT       = 36;
   ssNntpLastNewGroups       = 37;
   ssNntpNewGroupsY2K        = 38;


const    
   // group settings
   gsLocalMin                = 1;
   gsLocalMax                = 2;
   gsCreated                 = 3;
   gsPullLimit               = 4;
   gsPurgeKeepDays           = 5;
   gsDescription             = 6;
   gsGroupType               = 7;
   gsPostServer              = 8;
   gsLastClientRead          = 9;
   gsLastServerPull          = 10;
   gsAutoUnsubscribe         = 11;
   gsAutoAddPulls            = 12;
   gsModerator               = 13;
   gsFeedOnly                = 14;


const
   // pull settings
   psArtNoMin                = 1;
   psArtNoMax                = 2;
   psFirstPullDone           = 3;
   psFeederLast              = 4;


// ------------------------------------------------------------- Accounts -----

const
  // account properties
  apUsername        = 1;
  apPassword        = 2;
  apFullname        = 3;
  apUniqueID        = 4;
  apIpRestriction   = 5;
  apNewsPost        = 10;
  apNewsRead        = 11;
  apNewsNewNews     = 12;
  apNewsAutoSub     = 13;
  apNewsXHSearch    = 14; // (removed)
  apNewsPeer        = 15;
  apMailbox         = 20;
  apMailSend        = 21;
  apMailAddress     = 22;
  apMailFwdAccount  = 23;
  apMailFwdAddress  = 24;
  apMailFwdMailList = 25;
  apMailFwdKeepCopy = 26;
  apRemoteControl   = 30;

  ACTID_NEW     = -1;
  ACTID_INVALID = -1;
  ACTID_ADMIN   =  1;

  ACTPW_NOACCESS  = ' ';
  ACTPW_NOTNEEDED = '';    

  // mail list property names      
  mlpDescription  = '!Description';
  mlpOwnerAccount = '!OwnerAccount';
  mlpRestrictFrom = '!RestrictFrom';
  mlprfNoRestrict = 0;
  mlprfMemberFrom = 1;
  mlprfMemberAuth = 2;
  mlprfOwnerAuth  = 3;

  LOCALMAILTYPE_NORMAL  = 0; // known local recipient         
  LOCALMAILTYPE_INVALID = 1; // .invalid -> assume local, send to admin
  LOCALMAILTYPE_UNKNOWN = 2; // unknown local recipient -> notify admin

  // Auto Subscribe modes (apNewsAutoSub):
  NEWSAUTOSUB_NONE = 0; // no auto subscribe (default)
  NEWSAUTOSUB_PREF = 1; // auto subscribe from preferred or first server only
  NEWSAUTOSUB_ALL  = 2; // auto subscribe from all servers

  // RC profiles (apRemoteControl):
  RC_PROFILE_FIRST          = 0; // min. supported
  RC_PROFILE_NOACCESS       = 0; // Predefined: No access
  RC_PROFILE_CHANGEPASSWORD = 1; // Predefined: Change own password only
  RC_PROFILE_INFORMATIONAL  = 2; // Predefined: Informational and change passw.
  RC_PROFILE_FULLACCESS     = 9; // Predefined: Full access (administration)
  RC_PROFILE_LAST           = 9; // max. supported

// --------------------------------------------------------------- Others -----

const
  // Supported SASL mechanisms with preferred ones on the left:
  SASL_SUPPORTED = 'CRAM-SHA1 CRAM-MD5 DIGEST-MD5 PLAIN LOGIN';

  HAM_PURGEOPT_DONOTHING  = $0;
  HAM_PURGEOPT_DOALL      = $F;
  HAM_PURGEOPT_DONEWS     = $1;
  HAM_PURGEOPT_DOHISTORY  = $2;
  HAM_PURGEOPT_DOKILLS    = $4;
  HAM_PURGEOPT_DOMHISTORY = $8;

  SERVER_PORT_SEP  = ','; // Remote server port  separator ('name/alias,port')
  SERVER_ALIAS_SEP = '/'; // Remote server alias separator ('name/alias,port')
                                                      
  CountAsActiveTasksSet = [ attMaintenance, attTransfer ];

  TActiceClassDesc: array[ TActiveClass ] of String =
                    ( 'Unknown', 'Internal', 'Local', 'WasPulled', 'Pulled' );

// ----------------------------------------------------------------------------

implementation

end.
