// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit cHscAction;

interface

uses SysUtils, Classes;

type
   THscActionTypes = ( actIgnore,
                       actStartup, actShutdown,
                       actNewsOut, actNewsIn,
                       actMailOut, actMailIn,
                       actMailWaiting, actNewsWaiting, actMsgWaiting,
                       actMailOutFile, actMailInFile,
                       actNewsInLocal,
                       actReportsCreated,
                       actMailInHeader, actMailInHeaderFile, actMailToNews );

const
  THscActionNames: array[ THscActionTypes ] of String =
                   ( 'Ignore',
                     'Startup', 'Shutdown',
                     'NewsOut', 'NewsIn',
                     'MailOut', 'MailIn',
                     'MailWaiting', 'NewsWaiting', 'MsgWaiting',
                     'MailOutFile', 'MailInFile',
                     'NewsInLocal',
                     'ReportsCreated',
                     'MailInHeader', 'MailInHeaderFile', 'MailToNews' );

type
   THscNewsInTypes = ( nitUnknown,
                       nitModerated, nitGateway,
                       nitRemote, nitLocal, nitRemoteAndLocal,
                       nitFeed );

type
   THscAction = class
      public
         ActionName: String;
         ActionFile: String; // either *.hsc (script) or *.hut (user task)
         WaitForEnd: Boolean;
         LockedExec: Boolean;
         ExecSilent: Boolean;

         function IsUserTask: Boolean;

         constructor Create( const AActionName, AActionFile: String;
                             const AWaitForEnd, ALockedExec, AExecSilent: Boolean );
   end;

   
implementation

uses uTools, cUserTasks;

{ THscAction }

constructor THscAction.Create( const AActionName, AActionFile: String;
                               const AWaitForEnd, ALockedExec, AExecSilent: Boolean );
begin
   inherited Create;
   ActionName := AActionName;
   ActionFile := AActionFile;
   WaitForEnd := AWaitForEnd;
   LockedExec := ALockedExec;
   ExecSilent := AExecSilent;
end;

function THscAction.IsUserTask: Boolean;
var  s: String;
     i: Integer;
begin
   i := length( USERTASK_EXTENSION );
   s := TrimWhSpace( ActionFile );
   s := copy( s, length(s)-i+1, MaxInt );
   Result := ( CompareText( s, USERTASK_EXTENSION ) = 0 );
end;

end.
