// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit uVar; // global variables

interface

{$INCLUDE Compiler.inc}

uses SyncObjs, cSyncObjects, cSettings;

var
   // global counters
   CounterByteIn   : Int64 = 0;
   CounterByteOut  : Int64 = 0;
   CounterMailNew  : Int64 = 0;
   CounterArtNew   : Int64 = 0;
   CounterArtLoad  : Int64 = 0;
   CounterArtHist  : Int64 = 0;
   CounterArtKill  : Int64 = 0;
   CounterOutboxChk: Int64 = 1;
   CounterOutboxM  : Int64 = 0;
   CounterOutboxN  : Int64 = 0;

var
   // global synchronization objects
   CS_MAINTENANCE     : TCriticalSection = nil;
   CS_LOCK_NEWSOUT    : TCriticalSection = nil;
   CS_LOCK_NEWSFEED   : TCriticalSection = nil;
   CS_LOCK_MAILBOX_ALL: TCriticalSection = nil;
   CS_LOCK_MAILOUT_USE: TCriticalSection = nil;
   CS_LOCK_MAILOUT_ADD: TCriticalSection = nil;
   SEM_LIMITTASKS     : TSemaphoreObj = nil;

   // application and version info
   OUR_VERINFO: String = 'Hamster-Pg'; // version is added at initialization

   // global kernel objects
   AppIsRunningMutexName: String;   AppIsRunningMutex: TMutexObj = nil;
   AppIsServiceMutexName: String;   AppIsServiceMutex: TMutexObj = nil;
   AppTerminateEventName: String;   AppTerminateEvent: TEvent    = nil;

   // application settings
   AppSettings: TSettingsPlain;


implementation

uses SysUtils, Windows, uTools, uType, uConst, uConstVar, IniFiles;

function Init_AppSettings: Boolean;   
var PathStartup, PathBase: String;

   procedure InitPath( const asPath: Integer; const Default: String );
   var  Path: String;
   begin
      // expand path setting
      Path := AppSettings.GetStr( asPath );
      if Path = '' then Path := Default;
      Path := IncludeTrailingBackslash( Path );
      if (copy(Path,2,1) <> ':') and (copy(Path,1,2) <> '\\') then begin
         if copy(Path,1,1) = '\' then Path := copy(PathBase,1,2) + Path
                                 else Path := PathBase + Path
      end;
      AppSettings.SetStr( asPath, Path );

      AppSettings.SetChanged( asPath, False ); // don't save
      ForceDirectories( Path );                // create directory
   end;

var  ServiceName, ObjectPrefix: String;
begin
   // get startup and base path
   PathStartup := ExtractFilePath( ParamStr(0) );
   with TIniFile.Create( PathStartup + CFGFILE_HAMSTER ) do try
      PathBase := ReadString( SettingsDef_App.Def[ asPathBase ].Section,
                              SettingsDef_App.Def[ asPathBase ].Keyword,
                              PathStartup );
      if PathBase = '' then PathBase := PathStartup;
      PathBase := IncludeTrailingBackslash( PathBase );
      SetCurrentDirectory( PChar( PathBase ) );
   finally Free end;

   // init/load settings
   AppSettings := TSettingsPlain.Create(
      SettingsDef_App,
      TSettingsHandler_IniFile.Create( PathBase + CFGFILE_HAMSTER ),
      True
   );

   // reflect startup and base path in settings
   AppSettings.SetStr( asPathStartup, PathStartup );
   AppSettings.SetStr( asPathBase,    PathBase    );

   // init directories
   InitPath( asPathStartup, PathStartup );
   InitPath( asPathBase,    PathBase    );
   InitPath( asPathLogs,    AppSettings.GetStr( asPathBase    ) + 'Logs'     );
   InitPath( asPathServer,  AppSettings.GetStr( asPathBase    ) + 'Server'   );
   InitPath( asPathGroups,  AppSettings.GetStr( asPathBase    ) + 'Groups'   );
   InitPath( asPathMails,   AppSettings.GetStr( asPathBase    ) + 'Mails'    );
   InitPath( asPathNewsOut, AppSettings.GetStr( asPathGroups  ) + 'News.Out' );
   InitPath( asPathMailOut, AppSettings.GetStr( asPathMails   ) + 'Mail.Out' );
   InitPath( asPathNewsErr, AppSettings.GetStr( asPathGroups  ) + 'News.Err' );
   InitPath( asPathScripts, AppSettings.GetStr( asPathBase    )              );
   InitPath( asPathModules, AppSettings.GetStr( asPathScripts )              );
   InitPath( asPathReports, AppSettings.GetStr( asPathLogs    )              );

   // reflect service programm in settings
   AppSettings.SetStr( asServiceFile, AppSettings.GetStr(asPathStartup) + 'HService.exe' );
   AppSettings.SetChanged( asServiceFile, False ); // don't save

   // init names of app's kernel objects
   ServiceName  := AppSettings.GetStr( asServiceName  );
   ObjectPrefix := AppSettings.GetStr( asObjectPrefix );
   AppIsRunningMutexName := ObjectPrefix + 'mux' + ServiceName + 'IsRunning';
   AppIsServiceMutexName := ObjectPrefix + 'mux' + ServiceName + 'IsService';
   AppTerminateEventName := ObjectPrefix + 'evt' + ServiceName + 'Terminate';

   Result := True;
end;

initialization
   OUR_VERINFO := OUR_VERINFO + '/' + GetExeVersion;
   Init_AppSettings;

finalization
   if Assigned( AppSettings )         then AppSettings.Free;
   if Assigned( CS_MAINTENANCE )      then CS_MAINTENANCE.Free;
   if Assigned( CS_LOCK_MAILBOX_ALL ) then CS_LOCK_MAILBOX_ALL.Free;
   if Assigned( CS_LOCK_MAILOUT_USE ) then CS_LOCK_MAILOUT_USE.Free;
   if Assigned( CS_LOCK_MAILOUT_ADD ) then CS_LOCK_MAILOUT_ADD.Free;
   if Assigned( CS_LOCK_NEWSOUT )     then CS_LOCK_NEWSOUT.Free;
   if Assigned( CS_LOCK_NEWSFEED )    then CS_LOCK_NEWSFEED.Free;
   if Assigned( SEM_LIMITTASKS )      then SEM_LIMITTASKS.Free;
   if Assigned( AppIsServiceMutex )   then AppIsServiceMutex.Free;
   if Assigned( AppTerminateEvent )   then AppTerminateEvent.Free;
   if Assigned( AppIsRunningMutex )   then AppIsRunningMutex.Free;

end.
