// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1998-2003, Juergen Haible (<juergen.haible@t-online.de>).
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

program HService;

{$APPTYPE CONSOLE}

{$INCLUDE Compiler.inc}

uses
  SysUtils,
  Classes,
  Windows,
  Messages,
  IniFiles,
  SyncObjs,
  uMD5 in 'lib\uMD5.pas',
  uSHA1 in 'lib\uSHA1.pas',
  uSASL in 'lib\uSASL.pas',
  uPCRE in 'lib\uPCRE.pas',
  cPCRE in 'lib\cPCRE.pas',
  uCRC32 in 'lib\uCRC32.pas',
  uBlowfish in 'lib\uBlowfish.pas',
  uDateTime in 'lib\uDateTime.pas',
  uUnicoding in 'lib\uUnicoding.pas',
  uCharMaps8 in 'lib\uCharMaps8.pas',
  uCharsetsU in 'lib\uCharsetsU.pas',
  uCharsets8 in 'lib\uCharsets8.pas',
  uCharsetsW in 'lib\uCharsetsW.pas',
  uCharsets in 'lib\uCharsets.pas',
  uEncoding in 'lib\uEncoding.pas',
  uRasDyn in 'lib\uRasDyn.pas',
  uTools in 'lib\uTools.pas',
  uWinSock in 'lib\uWinSock.pas',
  uWinSvc in 'lib\uWinSvc.pas',
  uIpHelper in 'lib\uIpHelper.pas',
  cLogFile in 'lib\cLogFile.pas',
  cSyncObjects in 'lib\cSyncObjects.pas',
  cStream64 in 'lib\cStream64.pas',
  cFileStream64 in 'lib\cFileStream64.pas',
  cTxtFile in 'lib\cTxtFile.pas',
  cMsgFile in 'lib\cMsgFile.pas',
  uType in 'common\uType.pas',
  uConst in 'common\uConst.pas',
  uConstVar in 'common\uConstVar.pas',
  uHamTools in 'common\uHamTools.pas',
  cLiveMsg in 'common\cLiveMsg.pas',
  cLiveQueue in 'common\cLiveQueue.pas',
  cSettings in 'common\cSettings.pas',
  cSettingsDef in 'common\cSettingsDef.pas',
  uVar in 'HService\uVar.pas',
  uDynDll in 'HService\uDynDll.pas',
  cChunkRc in 'HService\cChunkRc.pas',
  cIndexRc in 'HService\cIndexRc.pas',
  cArticle in 'common\cArticle.pas',
  cArtFile in 'HService\cArtFile.pas',
  cArtFiles in 'HService\cArtFiles.pas',
  cHistoryNews in 'HService\cHistoryNews.pas',
  cHistoryMail in 'HService\cHistoryMail.pas',
  cServerBase in 'HService\cServerBase.pas',
  cServerNNTP in 'HService\cServerNNTP.pas',
  cServerPOP3 in 'HService\cServerPOP3.pas',
  cServerSMTP in 'HService\cServerSMTP.pas',
  cServerRECO in 'HService\cServerRECO.pas',
  cClientBase in 'HService\cClientBase.pas',
  cClientNNTP in 'HService\cClientNNTP.pas',
  cClientPOP3 in 'HService\cClientPOP3.pas',
  cClientSMTP in 'HService\cClientSMTP.pas',
  cFiltersBase in 'HService\cFiltersBase.pas',
  cFiltersMail in 'HService\cFiltersMail.pas',
  cFiltersNews in 'HService\cFiltersNews.pas',
  cDnsResolver in 'HService\cDnsResolver.pas',
  cSmtpRouter in 'HService\cSmtpRouter.pas',
  cAccounts in 'HService\cAccounts.pas',
  cPasswords in 'HService\cPasswords.pas',
  cIPAccess in 'HService\cIPAccess.pas',
  cHscEngine in 'HService\cHscEngine.pas',
  cHscHelpers in 'HService\cHscHelpers.pas',
  cHscHamster in 'HService\cHscHamster.pas',
  cHscFiles in 'HService\cHscFiles.pas',
  cHscActions in 'HService\cHscActions.pas',
  cNewsJobs in 'HService\cNewsJobs.pas',
  cNewsSearcher in 'HService\cNewsSearcher.pas',
  cRasDialer in 'HService\cRasDialer.pas',
  cResControl in 'HService\cResControl.pas',
  cLogFileHamster in 'HService\cLogFileHamster.pas',
  cHamsterCfg in 'HService\cHamsterCfg.pas',
  cHamster in 'HService\cHamster.pas',
  cLiveServer in 'HService\cLiveServer.pas',
  tBase in 'HService\tBase.pas',
  tTransfer in 'HService\tTransfer.pas',
  tMaintenance in 'HService\tMaintenance.pas',
  tScript in 'HService\tScript.pas',
  xAppServiceManager in 'HService\xAppServiceManager.pas',
  xAppStarter in 'HService\xAppStarter.pas',
  xApplication in 'HService\xApplication.pas',
  cMailUsers in 'HService\cMailUsers.pas',
  cMailItem in 'HService\cMailItem.pas',
  cMailDispatcher in 'HService\cMailDispatcher.pas',
  cMailLists in 'HService\cMailLists.pas',
  cMailTrap in 'HService\cMailTrap.pas',
  cTraps in 'common\cTraps.pas',
  tReports in 'HService\tReports.pas',
  tUserTasks in 'HService\tUserTasks.pas',
  cUserTasks in 'common\cUserTasks.pas',
  cScheduler in 'HService\cScheduler.pas',
  cSchedulerCommon in 'common\cSchedulerCommon.pas',
  cHscAction in 'common\cHscAction.pas',
  cXML in 'lib\cXML.pas',
  cWebChannel in 'lib\cWebChannel.pas';

{$R *.RES}

procedure ShowHelp;
begin
   writeln;
   writeln( StringOfChar( '=', 79 ) );
   writeln( GetMyStringFileInfo( 'ProductName', 'Hamster' )
            + ' ' + GetMyVersionInfo );
   writeln( GetMyStringFileInfo('LegalCopyright','') );
   writeln( 'Maintainer: ' + GetMyStringFileInfo('Maintainer','') );
   writeln( 'Download: '   + GetMyStringFileInfo('Download','') );
   writeln( StringOfChar( '=', 79 ) );

   writeln;
   writeln( '/hidden      Hides HService window while it is running.' );
   writeln( '/stop        Stops an already running HService.' );

   if IsPlatformNT and IsWinSvcAvailable then begin
   writeln;
   writeln( '/noservice   Forces HService to be started as a "normal" application' );
   writeln( '             (avoids delay if service installed but started directly).' );
   writeln( '/install     Installs HService as a service application.' );
   writeln( '/uninstall   Uninstalls service.' );
   writeln;
   end;
   
   writeln( StringOfChar( '=', 79 ) );
end;

var  StartHamster, StartAsServiceEnabled: Boolean;
     i: Integer;
     s: String;
begin
   // make sure we have a console window
   AllocConsole;

   // prepare logfile (Note: .RotateLog is delayed until AppStartup below)
   UidMapper := TUidMapper.Create;
   LogFile := TLogFileHamster.Create(
                 AppSettings.GetStr(asPathLogs),
                 AppSettings.GetInt(asLogFileMax),
                 False
              );
   LogFile.FileMask := AppSettings.GetHexInt(asLogFileMask);
   LogFile.ViewMask := AppSettings.GetHexInt(asLogViewMask);
   LogFile.TaskMask := AppSettings.GetHexInt(asLogTaskMask);
   LogFile.ViewMax  := AppSettings.GetInt   (asLogViewMax );
   LogFile.LogMSecs := AppSettings.GetBoo   (asLogMSecs   );

   // prepare global kernel objects
   AppIsRunningMutex := TMutexObj.Create(
      lpSecurityAttributesEveryone, False, AppIsRunningMutexName );
   AppTerminateEvent := TEvent.Create(
      lpSecurityAttributesEveryone, True, False, AppTerminateEventName );

   // check and handle command line parameters
   StartHamster := True;
   StartAsServiceEnabled := ( IsPlatformNT and IsWinSvcAvailable );

   for i := 1 to ParamCount do begin

      s := LowerCase( ParamStr( i ) );

      if ( s = '/?' ) or ( s = '/help' ) then begin
         StartHamster := False;
         ShowHelp;
         break;

      end else if s = '/hidden' then begin
         AppHide;
         StartAsServiceEnabled := False;

      end else if s = '/stop' then begin
         StartHamster := False;
         LogConsole( LOGID_INFO, 'Stopping HService ...' );
         if AppIsRunningMutex.Acquire( 0 ) then begin
            LogConsole( LOGID_ERROR, 'No running HService found!' )
         end else begin
            AppTerminateEvent.SetEvent;
            if AppIsRunningMutex.Acquire( 5000 ) then begin
               LogConsole( LOGID_INFO,  'HService stopped.' );
            end else begin
               LogConsole( LOGID_ERROR, 'Stopping HService failed!' );
            end;
         end;
         break;

      end else if s = '/noservice' then begin
         StartAsServiceEnabled := False;

      end else if (s = '/install') and StartAsServiceEnabled then begin
         StartHamster := False;
         LogConsole( LOGID_INFO, 'Install service ...' );
         if AppServiceInstall( s ) then begin
            LogConsole( LOGID_INFO,  'Service installed.' );
         end else begin
            LogConsole( LOGID_ERROR, 'Install service failed: ' + s );
         end;
         break;

      end else if (s = '/uninstall') and StartAsServiceEnabled then begin
         StartHamster := False;
         LogConsole( LOGID_INFO, 'Uninstall service ...' );
         if AppServiceUninstall( s ) then begin
            LogConsole( LOGID_INFO,  'Service uninstalled.' );
         end else begin
            LogConsole( LOGID_ERROR, 'Uninstall service failed: ' + s );
         end;
         break;

      end else begin
         StartHamster := False;
         LogConsole( LOGID_ERROR, 'Unsupported parameter: ' + s );
         break;

      end;

   end;

   // start application
   if StartHamster then begin

      if not Winsock2Installed( True ) then begin
         LogConsole( LOGID_ERROR,
            'This application requires Winsock2 to be installed!' );
         exit;
      end;

      if not AppIsRunningMutex.Acquire( 0 ) then begin
         LogConsole( LOGID_ERROR, 'Application is already running!' );
         exit;
      end;

      try
         LogFile.RotateLog( False );
         LogConsole( LOGID_INFO, 'Command line: ' + String(GetCommandLine) );
         try
            AppStartup( StartAsServiceEnabled );
         except
            on E: Exception do begin
               try Log( LOGID_ERROR, E.Message ) except end;
               if IsPlatformNT then begin
                  EvtLogError( 'HService terminated with Exception: '
                             + E.Message, EVTID_ERROR_DIED );
               end;               
            end;
         end;
      finally
         AppTerminateEvent.ResetEvent;
         AppIsRunningMutex.Release;
      end;
   end;
end.

