// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit uGlobal;

interface

{$INCLUDE Compiler.inc}

uses SysUtils, Classes, Messages, IniFiles, Forms, Graphics, FileCtrl,
     {$IFDEF USE_HTMLHELPKIT} hh, hh_funcs, {$ENDIF} // see Compiler.inc
     cLiveConnector, cTraps;

const
   WM_GUI_CHECKCONNECTION = WM_USER + 1;

   RES_UNSUPPORTED = 501;

   // Note: Values below are also .Tag of Actions!
   Cmd_ServerRefresh   = 10;
   Cmd_NntpStart       = 11;
   Cmd_NntpStop        = 12;
   Cmd_NntpRestart     = 13;
   Cmd_Pop3Start       = 21;
   Cmd_Pop3Stop        = 22;
   Cmd_Pop3Restart     = 23;
   Cmd_SmtpStart       = 31;
   Cmd_SmtpStop        = 32;
   Cmd_SmtpRestart     = 33;
   Cmd_RecoStop        = 42;
   Cmd_RecoRestart     = 43;
   Cmd_ScriptRefresh   = 50;
   Cmd_ScriptStop      = 51;
   Cmd_ScriptStart     = 52;
   // Cmd_ScriptStartWait = 53;
   Cmd_ScriptGet       = 54;
   Cmd_ScriptPut       = 55;
   Cmd_ScriptDel       = 56;
   Cmd_ScriptStartPar  = 57;
   Cmd_LogRefresh      = 60;
   Cmd_LogRotate       = 61;
   Cmd_ServerStop      = 65;
   Cmd_TaskStopSel     = 66;
   Cmd_TasksRefresh    = 67;
   Cmd_UserTasksSetup  = 68;
   Cmd_NewsRefresh     = 70;
   Cmd_NewsGroupAdd    = 71;
   Cmd_NewsGroupDel    = 72;
   Cmd_NewsPullAdd     = 73;
   Cmd_NewsPullDel     = 74; 
   Cmd_MAX             = 79;

var
   PATH_BASE, RCServer, RCPort, RCUser, RCPass: String;

   MainWindowHWnd   : Cardinal = 0;
   TimeoutConnectSec: Integer = 30;
   TimeoutCommandSec: Integer = 30;
   InitialLogSize   : Integer = 16;
   LogLinesMax      : Integer = 5000;
   MinimizeOnClose  : Boolean = False;
   SavePassword     : Boolean = False;
   RCSessionKey     : String = '';
   HServiceVersion  : String = '?.?.?.?';
   FontLogfile      : TFont;
   FontEditor       : TFont;
   SvcComputerName  : String = '';
   SvcServiceName   : String = 'HamsterService';

   AppIni       : TIniFile = nil;
   AppIniError  : String = '';
   LiveConnector: TLiveConnector = nil;
   {$IFDEF USE_HTMLHELPKIT}
   HtmlHelpHook : THookHelpSystem = nil;
   {$ENDIF} 

   MailTrapTestHdr: String = MTSpecialHeader_Contents;
   MailTrapTestMsg: String = ''
   + 'Return-Path: <return.path@spammer.xyz>' + #13#10
   + 'Received: from second.xyz ([123.123.123.123]) by myserver.xyz' + #13#10
   + #9 + ' with smtp id 123456789; Mon, 21 Apr 2003 11:24:04 +0200' + #13#10
   + 'Received: from first.xyz ([123.123.123.123]) by second.xyz' + #13#10
   + #9 + ' with smtp id 123456789; Mon, 21 Apr 2003 11:24:04 +0200' + #13#10
   + 'Received: from sender.xyz (HELO sender.xyz) (123.123.123.123)' + #13#10
   + #9 + ' by first.xyz with SMTP; 21 Apr 2003 11:23:59 +0200' + #13#10
   + 'From: <fake.name@domain.xyz>' + #13#10
   + 'To: <myname@mydomain.xyz>' + #13#10
   + 'Subject: Foo bar!' + #13#10
   + 'Date: Mon, 21 Apr 2003 18:21:23 -0900' + #13#10
   + '' + #13#10
   + 'Foo bar foo bar foo bar foo bar foo bar foo bar foo bar' + #13#10
   + 'foo bar foo bar foo bar foo bar. Foo? Bar!' + #13#10;

procedure LoadWindowState( TheForm: TForm; Section: String );
procedure SaveWindowState( TheForm: TForm; Section: String );

procedure LoadLocalSettings;
procedure SaveLocalSettings;

procedure GrowDpiForm( form: TForm );

implementation

uses uConst, uBlowfish;

const
   PasswordPassword = 'Security'#0'by'#0'obscurity';

function PWEncode( var buf: String ): String;
var  i: Integer;
     s: String;
begin
   Result := '';
   try
      s := HamBlowfishEncipher( PasswordPassword, buf );
      Result := '';
      for i:=1 to length(s) do begin
         Result := Result + inttohex( ord(s[i]), 2 );
      end;
   except Result := '' end;
end;

function PWDecode( var buf: String ): String;
var  i: Integer;
     s: String;
begin
   Result := '';
   try
      s := '';
      for i:=1 to length(buf) div 2 do begin
         s := s + chr( strtoint( '$' + copy(buf,i*2-1,2) ) );
      end;
      Result := HamBlowfishDecipher( PasswordPassword, s );
   except Result := '' end;
end;

procedure GrowDpiForm( form: TForm );
var  dw, dh, l, t, w, h: Integer;
begin
   if Screen.PixelsPerInch = 96 then exit;
   try

      dw := ( form.Width  * Screen.PixelsPerInch div 96 ) - form.Width;
      dh := ( form.Height * Screen.PixelsPerInch div 96 ) - form.Height;

      l := form.Left - dw div 2;
      t := form.Top - dh div 2;

      w := form.Width + dw;
      h := form.Height + dh;

      if l + w > Screen.Width  then l := l - (l + w - Screen.Width );
      if t + h > Screen.Height then t := t - (t + h - Screen.Height);
      
      if l < 0 then l := 0;
      if t < 0 then t := 0;

      form.SetBounds( l, t, w, h );

   except end;
end;

procedure LoadWindowState( TheForm: TForm; Section: String );
var  i: Integer;
begin
   if not Assigned(AppIni) then exit;

   i := AppIni.ReadInteger( Section, 'Left',   -1 ); if i>=0 then TheForm.Left  :=i;
   i := AppIni.ReadInteger( Section, 'Top',    -1 ); if i>=0 then TheForm.Top   :=i;
   i := AppIni.ReadInteger( Section, 'Width',  -1 ); if i>=0 then TheForm.Width :=i;
   i := AppIni.ReadInteger( Section, 'Height', -1 ); if i>=0 then TheForm.Height:=i;

   i := AppIni.ReadInteger( Section, 'State', -1 );
   if i=0 then TheForm.WindowState:=wsNormal;
   if i=1 then TheForm.WindowState:=wsMinimized;
   if i=2 then TheForm.WindowState:=wsMaximized;
end;

procedure SaveWindowState( TheForm: TForm; Section: String );
begin
   if not Assigned(AppIni) then exit;

   try
      case TheForm.WindowState of
         wsNormal   : AppIni.WriteInteger( Section, 'State', 0 );
         wsMinimized: AppIni.WriteInteger( Section, 'State', 1 );
         wsMaximized: AppIni.WriteInteger( Section, 'State', 2 );
      end;

      if TheForm.WindowState=wsNormal then begin
         AppIni.WriteInteger( Section, 'Left',   TheForm.Left );
         AppIni.WriteInteger( Section, 'Top',    TheForm.Top );
         AppIni.WriteInteger( Section, 'Width',  TheForm.Width );
         AppIni.WriteInteger( Section, 'Height', TheForm.Height );
      end;

   except
      on ex: Exception do begin
         if AppIniError <> ex.Message then begin
            AppIniError := ex.Message;
            Application.ShowException( ex );
         end;
      end;
   end;
end;

procedure LoadLocalSettings;
var  s: String;
begin
   TimeoutCommandSec := AppIni.ReadInteger( 'Setup', 'TimeoutCommand',  TimeoutCommandSec );
   TimeoutConnectSec := AppIni.ReadInteger( 'Setup', 'TimeoutConnect',  TimeoutConnectSec );
   InitialLogSize    := AppIni.ReadInteger( 'Setup', 'InitialLogSize',  InitialLogSize    );
   LogLinesMax       := AppIni.ReadInteger( 'Setup', 'LogLinesMax',     LogLinesMax       );
   MinimizeOnClose   := AppIni.ReadBool   ( 'Setup', 'MinimizeOnClose', MinimizeOnClose   );
   SavePassword      := AppIni.ReadBool   ( 'Setup', 'SavePassword',    SavePassword      );
   HServiceVersion   := AppIni.ReadString ( 'Setup', 'HServiceVersion', HServiceVersion   );

   RCServer := AppIni.ReadString( 'Setup', 'Server', '127.0.0.1' );
   RCPort   := AppIni.ReadString( 'Setup', 'Port',   '23' );
   RCUser   := AppIni.ReadString( 'Setup', 'User',   'admin' );
   RCPass   := '';

   if SavePassword then begin
      s := AppIni.ReadString( 'Setup', 'Pass',   '' );
      if s <> '' then RCPass := PWDecode( s );
   end;

   FontLogfile.Name := AppIni.ReadString ( 'Setup', 'Font.Log.Name', FontLogfile.Name );
   FontLogfile.Size := AppIni.ReadInteger( 'Setup', 'Font.Log.Size', FontLogfile.Size );

   FontEditor.Name := AppIni.ReadString ( 'Setup', 'Font.Editor.Name', FontEditor.Name );
   FontEditor.Size := AppIni.ReadInteger( 'Setup', 'Font.Editor.Size', FontEditor.Size );

   SvcComputerName := AppIni.ReadString ( 'Setup', 'SvcComputerName', SvcComputerName );
   SvcServiceName  := AppIni.ReadString ( 'Setup', 'SvcServiceName',  SvcServiceName  );

end;

procedure SaveLocalSettings;
begin
   try
      AppIni.WriteInteger( 'Setup', 'TimeoutCommand',  TimeoutCommandSec );
      AppIni.WriteInteger( 'Setup', 'TimeoutConnect',  TimeoutConnectSec );
      AppIni.WriteInteger( 'Setup', 'InitialLogSize',  InitialLogSize    );
      AppIni.WriteInteger( 'Setup', 'LogLinesMax',     LogLinesMax       );
      AppIni.WriteBool   ( 'Setup', 'MinimizeOnClose', MinimizeOnClose   );
      AppIni.WriteBool   ( 'Setup', 'SavePassword',    SavePassword      );
      AppIni.WriteString ( 'Setup', 'HServiceVersion', HServiceVersion   );

      AppIni.WriteString( 'Setup', 'Server', RCServer );
      AppIni.WriteString( 'Setup', 'Port',   RCPort   );
      AppIni.WriteString( 'Setup', 'User',   RCUser   );

      if SavePassword then begin
         AppIni.WriteString( 'Setup', 'Pass', PWEncode( RCPass ) );
      end else begin
         AppIni.WriteString( 'Setup', 'Pass', '' );
      end;

      AppIni.WriteString ( 'Setup', 'Font.Log.Name', FontLogfile.Name );
      AppIni.WriteInteger( 'Setup', 'Font.Log.Size', FontLogfile.Size );

      AppIni.WriteString ( 'Setup', 'Font.Editor.Name', FontEditor.Name );
      AppIni.WriteInteger( 'Setup', 'Font.Editor.Size', FontEditor.Size );

      AppIni.WriteString ( 'Setup', 'SvcComputerName', SvcComputerName );
      AppIni.WriteString ( 'Setup', 'SvcServiceName',  SvcServiceName  );

   except
      on ex: Exception do begin
         if AppIniError <> ex.Message then begin
            AppIniError := ex.Message;
            Application.ShowException( ex );
         end;
      end;
   end;
end;

initialization
   PATH_BASE := IncludeTrailingBackslash(
                   ExtractFilePath( Application.ExeName )
                );
   FontLogfile := TFont.Create;
   FontEditor  := TFont.Create;
   FontEditor.Name := 'Courier New';
   FontEditor.Size := 9;

finalization
   if Assigned( FontLogfile ) then FreeAndNil( FontLogfile );
   if Assigned( FontEditor  ) then FreeAndNil( FontEditor  );
   if Assigned( AppIni ) then FreeAndNil( AppIni );

end.
