// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fStartTasks;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TfrmStartTasks = class(TForm)
    btnCancel: TButton;
    btnRefresh: TButton;
    PageControl1: TPageControl;
    pgMaintenance: TTabSheet;
    pgRAS: TTabSheet;
    pgNNTP: TTabSheet;
    pgPOP3: TTabSheet;
    pgSMTP: TTabSheet;
    StatusBar1: TStatusBar;
    grpM: TGroupBox;
    ckStatistics: TCheckBox;
    ckRebuildLists: TCheckBox;
    ckAutoUnsub: TCheckBox;
    ckPurgeNews: TCheckBox;
    ckPurgeHistory: TCheckBox;
    ckPurgeKills: TCheckBox;
    ckPurgeMailHist: TCheckBox;
    ckRebuildHistory: TCheckBox;
    btnMaintenance: TButton;
    grpR: TGroupBox;
    lbRasConns: TListBox;
    btnRasDial: TButton;
    btnRasHangup: TButton;
    Label1: TLabel;
    grpN: TGroupBox;
    grpMI: TGroupBox;
    grpMO: TGroupBox;
    Label2: TLabel;
    lbNNTP: TListBox;
    Label3: TLabel;
    lbPOP3: TListBox;
    Label4: TLabel;
    lbSMTP: TListBox;
    btnNNTP: TButton;
    btnPOP3: TButton;
    btnSMTP: TButton;
    ckLogRotate: TCheckBox;
    btnSMTPMX: TButton;
    ckCreateReports: TCheckBox;
    pgUserTasks: TTabSheet;
    grpUT: TGroupBox;
    Label5: TLabel;
    lbUserTasks: TListBox;
    btnUserTasks: TButton;
    btnManageUserTasks: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnMaintenanceClick(Sender: TObject);
    procedure btnRasDialClick(Sender: TObject);
    procedure btnRasHangupClick(Sender: TObject);
    procedure btnNNTPClick(Sender: TObject);
    procedure btnPOP3Click(Sender: TObject);
    procedure btnSMTPClick(Sender: TObject);
    procedure btnSMTPMXClick(Sender: TObject);
    procedure btnUserTasksClick(Sender: TObject);
    procedure btnManageUserTasksClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure Status( const s: String );
    function Request( Which: String; ReqType: Integer; ReqData: String ): Boolean;
  end;

implementation

{$R *.DFM}

uses uConst, uTools, uGlobal, cLiveMsg, fUserTasks;

procedure TfrmStartTasks.FormCreate(Sender: TObject);
begin
   GrowDpiForm( self );

   PageControl1.ActivePage := pgUserTasks;
   btnRefresh.Click;
end;

procedure TfrmStartTasks.FormResize(Sender: TObject);
begin
   PageControl1.Width  := ClientWidth - 2 * PageControl1.Left;
   PageControl1.Height := ClientHeight - 3 * PageControl1.Top - StatusBar1.Height - btnRefresh.Height;
   btnRefresh.Top := ClientHeight - btnRefresh.Height - StatusBar1.Height - PageControl1.Top;
   btnCancel.Top  := ClientHeight - btnRefresh.Height - StatusBar1.Height - PageControl1.Top;
end;

procedure TfrmStartTasks.btnRefreshClick(Sender: TObject);
var  Reply: TLiveMsg;
     SL: TStringList;
     s, s1, s2: String;
     i: Integer;
begin
   lbUserTasks.Clear;
   lbRasConns.Clear;
   lbNNTP.Clear;
   lbPOP3.Clear;
   lbSMTP.Clear;

   SL := TStringList.Create;
   try

      // User Tasks
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( LMREQ_USERTASKS_LIST, '' )
      );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then lbUserTasks.Items.Text := Reply.MsgData;
      finally FreeAndNil(Reply) end;

      // RAS connection (only available as items in password list)
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( LMREQ_PASSWORD_LIST, '' )
      );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then begin
            SL.Text := Reply.MsgData;
            for i := 0 to SL.Count - 1 do begin
               s  := SL[i]; // <identifier> TAB <description> TAB <pwset>
               s1 := UnDQuoteStr( NextSepPart( s, TAB ) );
               s2 := UnDQuoteStr( NextSepPart( s, TAB ) );
               if UpperCase(copy(s2,1,4))='RAS:' then lbRasConns.Items.Add(s1);
            end;
         end;
      finally FreeAndNil(Reply) end;

      // NNTP server
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( LMREQ_SRVNNTP_LIST, '' )
      );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then lbNNTP.Items.Text := Reply.MsgData;
      finally FreeAndNil(Reply) end;

      // POP3 server
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( LMREQ_SRVPOP3_LIST, '' )
      );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then lbPOP3.Items.Text := Reply.MsgData;
      finally FreeAndNil(Reply) end;

      // SMTP server
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( LMREQ_SRVSMTP_LIST, '' )
      );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then lbSMTP.Items.Text := Reply.MsgData;
      finally FreeAndNil(Reply) end;

   finally SL.Free end;
end;

procedure TfrmStartTasks.Status( const s: String );
begin
   StatusBar1.SimpleText := s;
end;

function TfrmStartTasks.Request( Which  : String;
                                 ReqType: Integer;
                                 ReqData: String ): Boolean;
var  Title: String;
     Reply: TLiveMsg;
begin
   Result := False;
   Title  := 'Starting ' + Which + ': ';

   Status( Title + '...' );
   try
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( ReqType, ReqData )
      );

      if Assigned( Reply ) then begin
         try
            if Reply.MsgType = LMREP_OK then begin
               Result := True;
               Status( Title + 'OK'
                             + iif( length(Reply.MsgData) > 0,
                                    ', Reply: ' + Reply.MsgData, '' )
               );
            end else begin
               Status( Title + 'Failed, code ' + inttohex(Reply.MsgType,4) );
            end;
         finally Reply.Free end;
      end else begin
         Status( Title + 'Failed (unknown reason)' );
      end;

   except
      on E: Exception do Status( Title + 'Failed, ' + E.Message );
   end;
end;

procedure TfrmStartTasks.btnMaintenanceClick(Sender: TObject);
var  i: Integer;
begin
   if ckLogRotate.Checked then
      if Request( 'Start New Logfile', LMREQ_LOGFILE_ROTATE, '' ) then
         ckLogRotate.Checked := False;

   if ckStatistics.Checked then
      if Request( 'Statistics', LMREQ_RUN_STATISTICS, '' ) then
         ckStatistics.Checked := False;

   if ckCreateReports.Checked then
      if Request( 'Reports', LMREQ_RUN_REPORTS, '' ) then
         ckCreateReports.Checked := False;

   if ckRebuildLists.Checked then
      if Request( 'Rebuild Lists', LMREQ_RUN_REBUILDLISTS, '' ) then
         ckRebuildLists.Checked := False;

   if ckRebuildHistory.Checked then
      if Request( 'Rebuild History', LMREQ_RUN_REBUILDHISTORY, '' ) then
         ckRebuildHistory.Checked := False;

   if ckAutoUnsub.Checked then
      if Request( 'Auto Unsubscribe', LMREQ_RUN_AUTOUNSUBSCRIBE, '' ) then
         ckAutoUnsub.Checked := False;

   i := 0;
   if ckPurgeNews    .Checked then i := i or HAM_PURGEOPT_DONEWS;
   if ckPurgeHistory .Checked then i := i or HAM_PURGEOPT_DOHISTORY;
   if ckPurgeKills   .Checked then i := i or HAM_PURGEOPT_DOKILLS;
   if ckPurgeMailHist.Checked then i := i or HAM_PURGEOPT_DOMHISTORY;
   if i > 0 then begin
      if Request( 'Purge ' + inttostr(i), LMREQ_RUN_PURGE, inttostr(i) ) then begin
         ckPurgeNews    .Checked := False;
         ckPurgeHistory .Checked := False;
         ckPurgeKills   .Checked := False;
         ckPurgeMailHist.Checked := False;
      end;
   end;
end;

procedure TfrmStartTasks.btnRasDialClick(Sender: TObject);
var  s: String;
     OldTimeoutCommand: Integer;
begin
   if lbRasConns.ItemIndex < 0 then exit;
   if lbRasConns.ItemIndex >= lbRasConns.Items.Count then exit;
   s := lbRasConns.Items[ lbRasConns.ItemIndex ];

   OldTimeoutCommand := TimeoutCommandSec;
   try
      if TimeoutCommandSec < 60 then TimeoutCommandSec := 60;
      Request( 'RAS Dial ' + s, LMREQ_RUN_RASDIAL, s );
   finally
      TimeoutCommandSec := OldTimeoutCommand;
   end;
end;

procedure TfrmStartTasks.btnRasHangupClick(Sender: TObject);
begin
   if lbRasConns.Items.Count = 0 then exit;
   Request( 'RAS Hangup', LMREQ_RUN_RASHANGUP, '' );
end;

procedure TfrmStartTasks.btnNNTPClick(Sender: TObject);
var  s: String;
begin
   if lbNNTP.ItemIndex < 0 then exit;
   if lbNNTP.ItemIndex >= lbNNTP.Items.Count then exit;
   s := lbNNTP.Items[ lbNNTP.ItemIndex ];
   Request( 'NNTP ' + s, LMREQ_RUN_NEWSJOBS, s );
end;

procedure TfrmStartTasks.btnPOP3Click(Sender: TObject);
var  s: String;
begin
   if lbPOP3.ItemIndex < 0 then exit;
   if lbPOP3.ItemIndex >= lbPOP3.Items.Count then exit;
   s := lbPOP3.Items[ lbPOP3.ItemIndex ];
   Request( 'POP3 ' + s, LMREQ_RUN_FETCHMAIL, s );
end;

procedure TfrmStartTasks.btnSMTPClick(Sender: TObject);
var  s: String;
begin
   if lbSMTP.ItemIndex < 0 then exit;
   if lbSMTP.ItemIndex >= lbSMTP.Items.Count then exit;
   s := lbSMTP.Items[ lbSMTP.ItemIndex ];
   Request( 'SMTP ' + s, LMREQ_RUN_SENDMAIL, s );
end;

procedure TfrmStartTasks.btnSMTPMXClick(Sender: TObject);
begin
   Request( 'SMTP MX', LMREQ_RUN_SENDMAILMX, '' );
end;

procedure TfrmStartTasks.btnUserTasksClick(Sender: TObject);
var  s: String;
begin
   if lbUserTasks.ItemIndex < 0 then exit;
   if lbUserTasks.ItemIndex >= lbUserTasks.Items.Count then exit;
   s := lbUserTasks.Items[ lbUserTasks.ItemIndex ];
   Request( 'User task ' + s, LMREQ_RUN_USERTASK, s );
end;

procedure TfrmStartTasks.btnManageUserTasksClick(Sender: TObject);
var  s: String;
begin
   s := '';
   if lbUserTasks.ItemIndex >= 0 then begin
      if lbUserTasks.ItemIndex < lbUserTasks.Items.Count then begin
         s := lbUserTasks.Items[ lbUserTasks.ItemIndex ];
      end;
   end;

   TfrmUserTasks.ShowDialog( self, s );
   btnRefresh.Click;
end;

end.
