// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fSettings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, uGlobal;

type
  TfrmSettings = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    emTimeoutConnect: TEdit;
    Label2: TLabel;
    emTimeoutCommand: TEdit;
    Label4: TLabel;
    emInitialLogSize: TEdit;
    Label3: TLabel;
    emLogLinesMax: TEdit;
    ckMinimizeOnClose: TCheckBox;
    ckSavePassword: TCheckBox;
    btnFontLog: TButton;
    FontDialog1: TFontDialog;
    procedure btnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFontLogClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private-Deklarationen }
    TempFontLog: TFont;
  public
    { Public-Deklarationen }
  end;

var
  frmSettings: TfrmSettings;

implementation

{$R *.DFM}

procedure TfrmSettings.FormCreate(Sender: TObject);
begin
   emTimeoutConnect.Text     := inttostr( TimeoutConnectSec );
   emTimeoutCommand.Text     := inttostr( TimeoutCommandSec );
   emInitialLogSize.Text     := inttostr( InitialLogSize    );
   emLogLinesMax.Text        := inttostr( LogLinesMax       );
   ckMinimizeOnClose.Checked := MinimizeOnClose;
   ckSavePassword.Checked    := SavePassword;

   TempFontLog := TFont.Create;
   TempFontLog.Assign( FontLogfile );
   btnFontLog.Font.Assign( TempFontLog );
end;

procedure TfrmSettings.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TfrmSettings.FormDestroy(Sender: TObject);
begin
   if Assigned( TempFontLog ) then FreeAndNil( TempFontLog );
end;

procedure TfrmSettings.btnOKClick(Sender: TObject);
begin
   TimeoutConnectSec := strtointdef( emTimeoutConnect.Text, TimeoutConnectSec );
   TimeoutCommandSec := strtointdef( emTimeoutCommand.Text, TimeoutCommandSec );
   InitialLogSize    := strtointdef( emInitialLogSize.Text, InitialLogSize    );
   LogLinesMax       := strtointdef( emLogLinesMax.Text,    LogLinesMax       );
   MinimizeOnClose   := ckMinimizeOnClose.Checked;
   SavePassword      := ckSavePassword.Checked;
   FontLogfile.Assign( TempFontLog );

   SaveLocalSettings;
end;

procedure TfrmSettings.btnFontLogClick(Sender: TObject);
begin
   FontDialog1.Font.Assign( TempFontLog );
   if not FontDialog1.Execute then exit;
   TempFontLog.Assign( FontDialog1.Font );
   btnFontLog.Font.Assign( TempFontLog );
end;

end.
