unit fReports;

interface

{$INCLUDE Compiler.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF USE_THTMLLITE} HTMLLite, {$ENDIF} // see Compiler.inc
  StdCtrls, ComCtrls, ExtCtrls;

type
  TfrmReports = class(TForm)
    rtfReport: TRichEdit;
    lbReports: TListBox;
    Splitter1: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure lbReportsClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
    ReportsList, ReportTitles: TStringList;
    Reports: array of String;
    {$IFDEF USE_THTMLLITE}
    htmReport: THtmlLite;
    {$ENDIF}
    procedure OnHotSpotClick( Sender: TObject;
                              const URL: string;
                              var Handled: Boolean );
    procedure LoadReportsList;
    function  LoadReport( const RepIdx: Integer ): String;
    procedure ShowReport( const Report: String );
  public
    { Public-Deklarationen }
  end;

var
  frmReports: TfrmReports;

implementation

{$R *.DFM}

uses uTools, uConst, cLiveMsg, dDialogs, uGlobal;

procedure TfrmReports.FormCreate( Sender: TObject );
begin
   ReportsList  := TStringList.Create;
   ReportTitles := TStringList.Create;

   LoadWindowState( Self, self.ClassName );

   {$IFDEF USE_THTMLLITE}
      rtfReport.Visible := False;
      htmReport := THtmlLite.Create( self );
      htmReport.Parent := self;
      htmReport.Align  := alClient;
      htmReport.SetBounds( rtfReport.Left, rtfReport.Top,
                           rtfReport.Width, rtfReport.Height );
      htmReport.DefBackground  := clWhite;
      htmReport.DefFontName    := 'Arial';
      htmReport.DefFontSize    := 10;
      htmReport.OnHotSpotClick := OnHotSpotClick;
   {$ENDIF}

   LoadReportsList;
end;

procedure TfrmReports.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   SaveWindowState( Self, self.ClassName );
   ReportsList.Free;
   ReportTitles.Free;
   Reports := nil;
   Action := caFree;
end;

procedure TfrmReports.LoadReportsList;
var  Reply: TLiveMsg;
     i: Integer;
     s: String;
begin
   // load list of available reports
   try
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_REPORTS_LIST, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            ReportsList.Text := Reply.MsgData;
         end;
      finally Reply.Free end;

   except
      on E:Exception do begin
         HMessageDlg( 'Reports list could not be downloaded!'
                    + #13#10#13#10 + 'Error: ' + E.Message, mtError, [mbOK] );
      end;
   end;

   ReportsList.Sort;

   // load list of available report titles
   try
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_FILE_GET, REPFILE_REPORTTITLES )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            ReportTitles.Text := Reply.MsgData;
         end;
      finally Reply.Free end;

   except
      on E:Exception do begin
         HMessageDlg( 'Report titles could not be downloaded!'
                    + #13#10#13#10 + 'Error: ' + E.Message, mtError, [mbOK] );
      end;
   end;

   // show available reports
   SetLength( Reports, ReportsList.Count );
   for i := 0 to ReportsList.Count - 1 do begin
      s := ReportTitles.Values[ ReportsList[i] ];
      if s = '' then s := ReportsList[i];
      lbReports.Items.AddObject( s, Pointer(i) );
   end;
end;

function TfrmReports.LoadReport( const RepIdx: Integer ): String;

   function LoadFile( const Filename: String ): String;
   var  Reply: TLiveMsg;
   begin
      Result := '';

      try
         Reply := LiveConnector.RCLiveRequest(
                     TLiveMsg.Create( LMREQ_FILE_GET, DQuoteStr(Filename) )
                  );
         if Assigned( Reply ) then try
            if ( Reply.MsgType = LMREP_OK ) then begin
               Result := Reply.MsgData;
            end;
         finally Reply.Free end;

      except
         on E:Exception do begin
            HMessageDlg( 'File ' + CFGFILE_MAILTRAP + ' could not be downloaded!'
                       + #13#10#13#10 + 'Error: ' + E.Message, mtError, [mbOK] );
         end;
      end;

   end;

begin
   if length( Reports[RepIdx] ) > 0 then begin
      Result := Reports[RepIdx];
      exit;
   end;

   Result := LoadFile( ReportsList[RepIdx] );
   Reports[RepIdx] := Result;
end;

procedure TfrmReports.ShowReport( const Report: String );
begin
   rtfReport.Text := Report;
   rtfReport.SelStart := 0;

   {$IFDEF USE_THTMLLITE}
   htmReport.Clear;
   if length(Report) > 0 then htmReport.LoadFromString( Report, '' );
   {$ENDIF}
end;

procedure TfrmReports.lbReportsClick(Sender: TObject);
var  i: Integer;
     s: String;
begin
   Screen.Cursor := crHourGlass;
   try
      ShowReport( '' );
      Application.ProcessMessages;

      i := lbReports.ItemIndex;
      if (i < 0) or (i >= lbReports.Items.Count) then exit;
      i := Integer( lbReports.Items.Objects[i] );
      if (i < 0) or (i >= ReportsList.Count) then exit;

      s := LoadReport( i );
      ShowReport( s );

   finally
      Screen.Cursor := crDefault;
   end;
end;

procedure TfrmReports.OnHotSpotClick(Sender: TObject; const URL: string;
  var Handled: Boolean);
var  i, k: Integer;
     s: String;
begin
   i := -1;
   for k := 0 to ReportsList.Count - 1 do begin
      if CompareText( URL, ReportsList[k] ) = 0 then begin
         i := k;
         break;
      end;
   end;

   if i >= 0 then begin
      s := LoadReport( i );
      ShowReport( s );
   end;
end;

end.
