unit fLogFind;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TfrmLogFind = class(TForm)
    Label1: TLabel;
    rbFindText: TRadioButton;
    rbFindRegex: TRadioButton;
    emFindText: TEdit;
    emFindRegex: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    emMaxLines: TEdit;
    emFrom: TEdit;
    emUntil: TEdit;
    udFrom: TUpDown;
    udUntil: TUpDown;
    btnOk: TButton;
    lblFrom: TLabel;
    lblUntil: TLabel;
    btnCancel: TButton;
    lblWaiting: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnOkClick(Sender: TObject);
    procedure emFromChange(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure reflectControls;
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

uses uConst, uTools, cLiveMsg, uGlobal, fConfFile, dDialogs;

var  lastPattern : String = '';
     lastIsRegex : Boolean = False;
     lastFrom    : Integer = 0;
     lastUntil   : Integer = 0;
     lastMaxLines: Integer = 500;

procedure TfrmLogFind.FormCreate(Sender: TObject);
begin
   if lastIsRegex then begin
      rbFindRegex.Checked := True;
      emFindRegex.Text := lastPattern;
   end else begin
      rbFindText.Checked := True;
      emFindText.Text := lastPattern;
   end;
   udFrom.Position := lastFrom;
   udUntil.Position := lastUntil;
   emMaxLines.Text := IntToStr( lastMaxLines );

   reflectControls;
end;

procedure TfrmLogFind.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TfrmLogFind.reflectControls;

   function agoLabel( days: Integer ): String;
   begin
      case days of
         0: Result := '(today, ';
         1: Result := '(yesterday, ';
         else Result := '(' + IntToStr(days) + ' days ago, ';
      end;
      Result := Result + FormatDateTime( 'ddd, c', Date - days ) + ')';
   end;

var  i: Integer;
begin
   emFindText.Enabled  := rbFindText.Checked;
   emFindRegex.Enabled := rbFindRegex.Checked;

   i := StrToIntDef( emFrom.Text, 0 );
   lblFrom.Caption := agoLabel( i );

   i := StrToIntDef( emUntil.Text, 0 );
   lblUntil.Caption := agoLabel( i );
end;

procedure TfrmLogFind.emFromChange(Sender: TObject);
begin
   reflectControls;
end;

procedure TfrmLogFind.btnOkClick(Sender: TObject);
var  logLines: String;
     Reply: TLiveMsg;
begin
   try

      lastIsRegex  := rbFindRegex.Checked;
      lastPattern  := iif( lastIsRegex, emFindRegex.Text, emFindText.Text );
      lastFrom     := StrToIntDef( emFrom.Text, 0 );
      lastUntil    := StrToIntDef( emUntil.Text, 0 );
      lastMaxLines := StrToIntDef( emMaxLines.Text, 100 );

      lblWaiting.Visible := True;
      try

         Application.ProcessMessages;

         Reply := LiveConnector.RCLiveRequest(
                     TLiveMsg.Create( LMREQ_LOGFILE_FIND,
                                      lastPattern
                                      + CRLF + iif( lastIsRegex, '1', '0' )
                                      + CRLF + IntToStr( lastFrom )
                                      + CRLF + IntToStr( lastUntil  )
                                      + CRLF + IntToStr( lastMaxLines ) )
                  );
         logLines := '';
         if Assigned( Reply ) then try
            if ( Reply.MsgType = LMREP_OK ) then begin
               logLines := Reply.MsgData;
            end;
         finally Reply.Free end;

      finally lblWaiting.Visible := False end;

      EditLocalText( 'Find In Logfiles: ' + lastPattern, logLines );

   except
      on ex: Exception do HMessageDlg( ex.Message, Application.Title,
                                       mtWarning, [mbOK] );
   end;
end;

end.
