// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fGroupPull;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmGroupPull = class(TForm)
    GroupBox1: TGroupBox;
    lblGroup: TLabel;
    lblServer: TLabel;
    btnOK: TButton;
    btnCancel: TButton;
    cboGroup: TComboBox;
    cboServer: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  frmGroupPull: TfrmGroupPull;

implementation

{$R *.DFM}

uses uTools, fMain;

procedure TfrmGroupPull.FormCreate(Sender: TObject);
var  G, P: TStringList;
     i, k: Integer;
     s: String;
begin
   G := TStringList.Create;
   G.Sorted := True;
   G.Duplicates := dupIgnore;

   P := TStringList.Create;
   P.Sorted := True;
   P.Duplicates := dupIgnore;

   try
      with frmMain.lbNews do begin
         for i:=0 to Items.Count-1 do begin
            s := Items[i];
            k := PosWhSpace( s );

            if k = 0 then begin
               G.Add( s );
            end else begin
               P.Add( copy( s, k+1, MaxInt ) );
            end;
         end;
      end;

      cboGroup .Items.Text := G.Text;
      cboServer.Items.Text := P.Text;

   finally
      P.Free;
      G.Free;
   end;
end;

procedure TfrmGroupPull.FormClose( Sender: TObject; var Action: TCloseAction );
begin
   Action := caFree;
end;

end.
