// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fConfPwd; 

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dDialogs, StdCtrls, ImgList;

type
  TfrmConfPwd = class(TForm)
    lbItems: TListBox;
    Label1: TLabel;
    btnPWChange: TButton;
    btnPWClear: TButton;
    btnOK: TButton;
    btnApply: TButton;
    btnRefresh: TButton;
    btnCancel: TButton;
    imglstItems: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lbItemsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure lbItemsClick(Sender: TObject);
    procedure btnPWChangeClick(Sender: TObject);
    procedure btnPWClearClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
    SelItemType: Integer;
    SelItemName: String;
    Args       : TStringList;
    procedure ChangePasswordInfo( Identifier, User, Pass: String );
    // procedure SettingsToForm;
    // procedure FormToSettings;
    function  LoadItemList: Boolean;
    function  LoadSettings: Boolean;
    // function  SaveSettings: Boolean;
  public
    { Public-Deklarationen }
  end;

implementation

uses uConst, uConstVar, uGlobal, uTools, cLiveMsg, cLiveQueue, dInput;

{$R *.DFM}

const
   selNone = 0;
   selPWD  = 1;

procedure TfrmConfPwd.FormCreate(Sender: TObject);
begin
   GrowDpiForm( self );

   SelItemType := selNone;
   SelItemName := '';
   Args := TStringList.Create;

   // LoadItemList;
   btnRefresh.Click;
end;

procedure TfrmConfPwd.FormResize(Sender: TObject);
begin
   lbItems.Height := ClientHeight - lbItems.Top - lbItems.Left;
   lbItems.Width  := ClientWidth - 3 * lbItems.Left - btnOk.Width;
   
   btnPwChange.Left := ClientWidth - btnPwChange.Width - lbItems.Left;
   btnPwClear.Left  := ClientWidth - btnPwChange.Width - lbItems.Left;
   btnRefresh.Left  := ClientWidth - btnPwChange.Width - lbItems.Left;
   btnCancel.Left   := ClientWidth - btnPwChange.Width - lbItems.Left;
   btnOk.Left       := ClientWidth - btnPwChange.Width - lbItems.Left;
   btnApply.Left    := ClientWidth - btnPwChange.Width - lbItems.Left;
end;

procedure TfrmConfPwd.FormDestroy(Sender: TObject);
begin
   if Assigned( Args ) then Args.Free;
end;

function TfrmConfPwd.LoadItemList: Boolean;

   procedure AddItems( LqReqId, setId: Integer );
   var  Reply: TLiveMsg;
        SL: TStringList;
        i: Integer;
   begin
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LqReqId, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            SL := TStringList.Create;
            try
               SL.Text := Reply.MsgData;
               for i:=0 to SL.Count-1 do begin
                  lbItems.Items.AddObject( SL[i], Pointer( setId ) );
               end;
            finally SL.Free end;
         end;
      finally Reply.Free end;
   end;

begin
   Result := False;

   try
      SelItemType := selNone;
      SelItemName := '';

      lbItems.Items.BeginUpdate;
      try
         lbItems.Items.Clear;
         lbItems.ItemIndex := -1;
         AddItems( LMREQ_PASSWORD_LIST, selPWD );
      finally lbItems.Items.EndUpdate end;

      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Load Item List', mtError, [mbOK] );
      end;
   end;
end;

function TfrmConfPwd.LoadSettings: Boolean;
begin
   Result := False;

   try
      if lbItems.Items.Count = 0 then LoadItemList;

      if SelItemName = '' then SelItemType := selNone;

      // SettingsToForm;

      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Load Passwords', mtError, [mbOK] );
      end;
   end;
end;

procedure TfrmConfPwd.btnRefreshClick(Sender: TObject);
var  Idx, Top: Integer;
begin
   Idx := lbItems.ItemIndex;
   Top := lbItems.TopIndex;
   LoadItemList;

   if ( Idx >= 0 ) and ( Idx < lbItems.Items.Count ) then begin
      if Top >= 0 then lbItems.TopIndex := Top;
      lbItems.ItemIndex := Idx;
      lbItemsClick( nil );
   end;
   
   btnOK.Enabled := LoadSettings;
end;

procedure TfrmConfPwd.btnOKClick(Sender: TObject);
begin
   // if not SaveSettings then ModalResult := mrNone;
end;

procedure TfrmConfPwd.btnApplyClick(Sender: TObject);
begin
   // SaveSettings;
end;

procedure TfrmConfPwd.lbItemsDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
   with (Control as TListBox).Canvas do begin
      ArgsWhSpaceDQuoted( (Control as TListBox).Items[Index], Args, 3 );

      FillRect( Rect );

      imglstItems.Draw( (Control as TListBox).Canvas,
                        Rect.Left+2, Rect.Top,
                        iif( Args[2]='1', 0, 1 ), True );

      if odSelected in State then Font.Style := [ fsBold ]
                             else Font.Style := [ ];

      TextOut( Rect.Left+20, Rect.Top+1, Args[1] );
   end;
end;

procedure TfrmConfPwd.lbItemsClick(Sender: TObject);
var  b: Boolean;
begin
   with lbItems do begin
      if ( ItemIndex < 0 ) or ( ItemIndex >= Items.Count ) then begin
         SelItemType := selNone;
         SelItemName := '';
      end else begin
         SelItemType := Integer( Items.Objects[ ItemIndex ] );
         SelItemName := Items[ ItemIndex ];
      end;
   end;

   LoadSettings;

   b := ( SelItemType = selPWD );
   if b then begin
      ArgsWhSpaceDQuoted( SelItemName, Args, 3 );
      if Args[2] <> '1' then b := False;
   end;
   btnPWClear.Enabled := b;
end;

procedure TfrmConfPwd.ChangePasswordInfo( Identifier, User, Pass: String );
begin
   try
      if not LiveConnector.RCLiveRequestOK(
         TLiveMsg.Create( LMREQ_PASSWORD_SET,
                          Identifier + CRLF + User + CRLF + Pass )
      ) then begin

         HMessageDlg( 'Changing password settings failed!',
                      SelItemName, mtWarning, [mbOK] );
      end;
   except end;
end;

procedure TfrmConfPwd.btnPWChangeClick(Sender: TObject);
var  User, Pass, Pass2: String;
begin
   if ( SelItemType <> selPWD ) or ( SelItemName = '' ) then exit;
   ArgsWhSpaceDQuoted( SelItemName, Args, 3 );

   User  := '';
   Pass  := '';
   Pass2 := '';

   if not InputDlgStr( Args[1], 'Username:', User, 0 ) then exit;
   if not InputDlgPwd( Args[1], 'Password:', Pass, 0 ) then exit;
   if not InputDlgPwd( Args[1], 'Repeat Password:', Pass2, 0 ) then exit;

   if Pass <> Pass2 then begin
      HMessageDlg( 'Given passwords were not equal!',
                   Args[1], mtWarning, [mbOK] );
      exit;
   end;

   ChangePasswordInfo( Args[0], User, Pass );
   btnRefreshClick( nil );
end;

procedure TfrmConfPwd.btnPWClearClick(Sender: TObject);
var  s: String;
begin
   if ( SelItemType <> selPWD ) or ( SelItemName = '' ) then exit;
   ArgsWhSpaceDQuoted( SelItemName, Args, 3 );

   s := Format( 'Clear password settings for "%s" now?', [Args[1]] );
   if HMessageDlg( PChar(s), mtConfirmation, [mbYes,mbNo] ) <> mrYes then exit;

   ChangePasswordInfo( Args[0], '', '' );
   btnRefreshClick( nil );
end;

end.
