// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fConfMailTrapTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ImgList, ExtCtrls, ActnList, Menus, ComCtrls;

type
  TfrmConfMailTrapTest = class(TForm)
    imglstItems: TImageList;
    ActionList1: TActionList;
    acTest: TAction;
    acClose: TAction;
    acPaste: TAction;
    acShowBase: TAction;
    PageControl1: TPageControl;
    tabTestMessage: TTabSheet;
    tabFilterBase: TTabSheet;
    emmFlt: TMemo;
    emmMsg: TMemo;
    btnPaste: TButton;
    cbHeaderLine: TComboBox;
    Label1: TLabel;
    PageControl2: TPageControl;
    tabMatches: TTabSheet;
    tabResult: TTabSheet;
    Label2: TLabel;
    lblScoreAll: TLabel;
    lbItems: TListBox;
    Label3: TLabel;
    lblScoreReal: TLabel;
    emmResult: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure lbItemsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure FormResize(Sender: TObject);
    procedure acTestExecute(Sender: TObject);
    procedure acCloseExecute(Sender: TObject);
    procedure acPasteExecute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure acShowBaseExecute(Sender: TObject);
    procedure cbHeaderLineChange(Sender: TObject);
    procedure emmMsgChange(Sender: TObject);
  private
    { Private-Deklarationen }
    lbTraps: TListBox;
    ScoreAccept, ScoreDelete: Integer;
    LastTestTxt, LastBaseTxt, LastBaseHdr: String;
    function GetTestMessage: String;
  public
    { Public-Deklarationen }
    procedure LinkItems( AScoreAccept, AScoreDelete: Integer; lbTrapsToTest: TListBox );
  end;

var
  frmConfMailTrapTest: TfrmConfMailTrapTest;

implementation

{$R *.DFM}

uses uGlobal, cTraps, cArticle, ClipBrd;

type
   TMailTrapTester = class( TMailTrapCustom )

      protected
         procedure Clear; override;

      public
         constructor Create( AAcceptScore, ADeleteScore: Integer );

   end;


{ TMailTrapTester }

constructor TMailTrapTester.Create( AAcceptScore, ADeleteScore: Integer );
begin
   inherited Create();
   FAcceptScore := AAcceptScore;
   FDeleteScore := ADeleteScore;
end;

procedure TMailTrapTester.Clear;
begin
   FList.Clear; // Don't .Free items, they are still in use!
end;

{ TfrmConfMailTrapTest }

procedure TfrmConfMailTrapTest.FormCreate(Sender: TObject);
begin
   LoadWindowState( Self, self.ClassName );
   acClose.ShortCut := ShortCut( VK_ESCAPE, [] );

   cbHeaderLine.Items.Add( MTSpecialHeader_Contents        );
   cbHeaderLine.Items.Add( MTSpecialHeader_RawContents     );
   cbHeaderLine.Items.Add( MTSpecialHeader_AnyHeader       );
   cbHeaderLine.Items.Add( MTSpecialHeader_AnySender       );
   cbHeaderLine.Items.Add( MTSpecialHeader_AnyRecipient    );
   cbHeaderLine.Items.Add( MTSpecialHeader_MessageHeaders  );
   cbHeaderLine.Items.Add( MTSpecialHeader_MessageBody     );
   cbHeaderLine.Items.Add( MTSpecialHeader_WholeMessage    );
   cbHeaderLine.Items.Add( MTSpecialHeader_BodySubject     );
   cbHeaderLine.Items.Add( 'Subject' );
   cbHeaderLine.Items.Add( 'From' );
   cbHeaderLine.Items.Add( 'Received' );
   cbHeaderLine.Items.Add( 'Return-Path' );

   lbTraps           := nil;
   emmMsg.Text       := MailTrapTestMsg;
   cbHeaderLine.Text := MailTrapTestHdr;
end;

procedure TfrmConfMailTrapTest.FormResize(Sender: TObject);
begin
   PageControl1.Width := ClientWidth - PageControl1.Left;
   PageControl1.Height := ClientHeight - 3 * PageControl1.Top - PageControl2.Height;

   PageControl2.Width := ClientWidth - PageControl2.Left;
   PageControl2.Top   := ClientHeight - PageControl1.Top - PageControl2.Height;

   lbItems.Invalidate;
end;

procedure TfrmConfMailTrapTest.FormDestroy(Sender: TObject);
begin
   SaveWindowState( Self, self.ClassName );
end;

procedure TfrmConfMailTrapTest.LinkItems( AScoreAccept, AScoreDelete: Integer;
                                          lbTrapsToTest: TListBox );
begin
   ScoreAccept := AScoreAccept;
   ScoreDelete := AScoreDelete;
   lbTraps := lbTrapsToTest;
   
   acTest.Execute;
   acShowBase.Execute;
end;

procedure TfrmConfMailTrapTest.lbItemsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var  s, c: String;
     t: TMailTrapItem;
     i: Integer;
begin
   t := TMailTrapItem( (Control as TListBox).Items.Objects[Index] );
   s := t.AsInfo;
   i := Pos( MailTrapAsInfoCommentSeparator, s );
   if i = 0 then begin
      c := '';
   end else begin
      c := ' ' + Trim( copy( s, i, MaxInt ) );
      s := Trim( copy( s, 1, i-1 ) );
   end;

   i := ord( t.Action ) * 2;
   if (t.Action = mtaScore) and (t.ScoreValue < 0 ) then inc( i, 2 );
   if t.Disabled then inc( i );

   with (Control as TListBox).Canvas do begin

      FillRect( Rect );
      imglstItems.Draw( (Control as TListBox).Canvas,
                        Rect.Left+2, Rect.Top, i, True );

      // if odSelected in State then Font.Style := [ fsBold ]
      //                        else Font.Style := [ ];
      TextOut( Rect.Left+20, Rect.Top+1, s );

      if length( c ) > 0 then begin
         Font.Color := clGray;
         TextOut( Rect.Right - TextWidth(c) - 2, Rect.Top+1, c );
      end;
   end;
end;

function TfrmConfMailTrapTest.GetTestMessage: String;
begin
   Result := emmMsg.Text;
   while (length(Result) > 0) and (Result[1] in [#13,#10]) do System.Delete(Result,1,1);
end;

procedure TfrmConfMailTrapTest.acTestExecute(Sender: TObject);
var  iTrap, Score, ScoreSum: Integer;
     tTester: TMailTrapTester;
     t: TMailTrapItem;
     msg: TMess;
     Reason, s: String;
     Deleted, DeleTrap: Boolean;
begin
   if not Assigned( lbTraps ) then exit;

   MailTrapTestMsg := GetTestMessage;
   if MailTrapTestMsg = LastTestTxt then exit;
   LastTestTxt := MailTrapTestMsg;

   lbItems.Clear;
   emmResult.Text := '';

   msg := TMess.Create();
   try

      tTester := TMailTrapTester.Create( ScoreAccept, ScoreDelete );
      try

         msg.FullText := MailTrapTestMsg;

         // test every trap separately (including disabled ones here)
         ScoreSum := 0;
         if Assigned( lbTraps ) then begin
            for iTrap := 0 to lbTraps.Items.Count - 1 do begin

               t := TMailTrapItem( lbTraps.Items.Objects[ iTrap ] );
               tTester.Clear;
               tTester.FList.Add( t );

               tTester.Reject( msg, Reason, DeleTrap, Score );
               if Reason <> '' then begin
                  lbItems.Items.AddObject( '', t );
                  inc( ScoreSum, Score );
               end;

            end;
         end;
         lblScoreAll.Caption := 'Virtual score: ' + inttostr(ScoreSum);
         tabMatches.Caption := ' Matches (score ' + inttostr(ScoreSum) + ') ';

         // test all traps at once like it is done by HService
         tTester.Clear;
         if Assigned( lbTraps ) then begin
            for iTrap := 0 to lbTraps.Items.Count - 1 do begin
               t := tMailTrapItem( lbTraps.Items.Objects[ iTrap ] );
               if not t.Disabled then tTester.FList.Add( t );
            end;
         end;

         Deleted := tTester.Reject( msg, Reason, DeleTrap, ScoreSum );

         if Deleted then begin
            s := 'Message would have been DELETED!' + #13#10;
            tabResult.ImageIndex := 2;
            tabResult.Caption := 'Result = DELETE  (score ' + inttostr(ScoreSum) + ') ';
         end else begin
            s := 'Message would have been ACCEPTED.' + #13#10;
            tabResult.ImageIndex := 0;
            tabResult.Caption := 'Result = ACCEPT  (score ' + inttostr(ScoreSum) + ') ';
         end;
         lblScoreReal.Caption := 'Actual score: ' + inttostr(ScoreSum);

         if Reason <> '' then begin
            s := s + 'Matches:' + #13#10'   '
                   + StringReplace( Reason, #9, #13#10'   ', [rfReplaceAll] )
                   + #13#10;
         end;

         emmResult.Text := s;

      finally tTester.Free end;

   finally msg.Free end;
end;

procedure TfrmConfMailTrapTest.acShowBaseExecute(Sender: TObject);
var  msg: TMess;
     flt: TStringList;
     txt, hdr: String;
begin
   if not Assigned( lbTraps ) then exit;

   txt := GetTestMessage;
   hdr := cbHeaderLine.Text;
   if (txt = LastBaseTxt) and (hdr = LastBaseHdr) then exit;
   LastBaseTxt  := txt;
   LastBaseHdr  := hdr;

   msg := TMess.Create();
   flt := TStringList.Create();
   try

      msg.FullText := LastBaseTxt;
      hdr          := LastBaseHdr;

      MailTrapGetHeaderValues( msg, hdr, flt );
      emmFlt.Text := flt.Text;

   finally
      flt.Free;
      msg.Free;
   end;
end;

procedure TfrmConfMailTrapTest.acCloseExecute(Sender: TObject);
begin
   ModalResult := mrCancel;
end;

procedure TfrmConfMailTrapTest.emmMsgChange(Sender: TObject);
begin
   acTest.Execute;
   acShowBase.Execute;
end;

procedure TfrmConfMailTrapTest.acPasteExecute(Sender: TObject);
begin
   emmMsg.Text := Clipboard.AsText;
   acTest.Execute;
   acShowBase.Execute;
end;

procedure TfrmConfMailTrapTest.cbHeaderLineChange(Sender: TObject);
begin
   MailTrapTestHdr := cbHeaderLine.Text;
   acShowBase.Execute;
end;

end.
