// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fConfGrp; 

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dDialogs, StdCtrls, ExtCtrls, ImgList, cSettings, Menus, ComCtrls;

type
  TfrmConfGrp = class(TForm)
    Label1: TLabel;
    lbItems: TListBox;
    btnOK: TButton;
    btnApply: TButton;
    btnRefresh: TButton;
    btnCancel: TButton;
    popItems: TPopupMenu;
    mnuGrpDel: TMenuItem;
    mnuGrpAdd: TMenuItem;
    N1: TMenuItem;
    PageControl1: TPageControl;
    pgSettings: TTabSheet;
    pgInformation: TTabSheet;
    grpSet: TGroupBox;
    Label6: TLabel;
    Label15: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    labPWBase: TLabel;
    Label4: TLabel;
    Label11: TLabel;
    emPullLimit: TEdit;
    emKeepDays: TEdit;
    emDescription: TEdit;
    ckAutoUnsubscribe: TCheckBox;
    cbGroupType: TComboBox;
    grpInf: TGroupBox;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    emLocalMin: TEdit;
    emLocalMax: TEdit;
    emCreation: TEdit;
    emLastPull: TEdit;
    emLastRead: TEdit;
    Bevel1: TBevel;
    cbPostServer: TComboBox;
    ckAutoAddPulls: TCheckBox;
    Label12: TLabel;
    emModerator: TEdit;
    ckFeedOnly: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure lbItemsClick(Sender: TObject);
    procedure mnuGrpDelClick(Sender: TObject);
    procedure mnuGrpAddClick(Sender: TObject);
    procedure popItemsPopup(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
    SelItemType: Integer;
    SelItemName: String;
    SelSettings: TSettingsPlain;
    procedure SettingsToForm;
    procedure FormToSettings;
    function  LoadItemList: Boolean;
    function  LoadSettings: Boolean;
    function  SaveSettings: Boolean;
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

uses uConst, uConstVar, uGlobal, cSettingsHdlLive, uTools, cLiveMsg, cLiveQueue,
     uDateTime, dInput;

const
   selNone = 0;
   selGrp  = 1;

procedure TfrmConfGrp.FormCreate(Sender: TObject);
begin
   GrowDpiForm( self );

   SelItemType := selNone;
   SelItemName := '';
   SelSettings := nil;

   PageControl1.ActivePageIndex := 0;
   LoadItemList;
   btnRefresh.Click;
end;

procedure TfrmConfGrp.FormResize(Sender: TObject);
begin
   PageControl1.Width  := ClientWidth  - 4 * lbItems.Left - lbItems.Width - Bevel1.Width;
   PageControl1.Height := ClientHeight - 3 * PageControl1.Top - btnOk.Height;
   lbItems.Height      := ClientHeight - lbItems.Top - PageControl1.Top;
   btnOk.Top      := ClientHeight - btnOk.Height - PageControl1.Top;
   btnApply.Top   := ClientHeight - btnOk.Height - PageControl1.Top;
   btnRefresh.Top := ClientHeight - btnOk.Height - PageControl1.Top;
   btnCancel.Top  := ClientHeight - btnOk.Height - PageControl1.Top;
end;

procedure TfrmConfGrp.FormDestroy(Sender: TObject);
begin
   if Assigned( SelSettings ) then SelSettings.Free;
end;

procedure TfrmConfGrp.SettingsToForm;

   function DT( const s: String ): String;
   var  x: TDateTime;
   begin
      x := uDateTime.TimeStampToDateTime( s );
      if x = 0 then Result := ''
               else Result := DateTimeToStr( x );
   end;

var  i: Integer;
begin
   if not Assigned( SelSettings ) then exit;

   with SelSettings do begin

      emDescription.Text        := GetStr( gsDescription );

      i := pos( GetStr( gsGroupType ), 'ynmg' );
      if i > 0 then dec( i );
      cbGroupType.ItemIndex := i;

      cbPostServer.Text         := GetStr( gsPostServer );
      emModerator.Text          := GetStr( gsModerator );
      emPullLimit.Text          := GetStr( gsPullLimit );
      emKeepDays.Text           := GetStr( gsPurgeKeepDays );
      ckAutoUnsubscribe.Checked := GetBoo( gsAutoUnsubscribe );
      ckAutoAddPulls.Checked    := GetBoo( gsAutoAddPulls );
      ckFeedOnly.Checked        := GetBoo( gsFeedOnly );

      emLocalMin.Text := GetStr( gsLocalMin );
      emLocalMax.Text := GetStr( gsLocalMax );
      emCreation.Text := DT( GetStr( gsCreated ) );
      emLastPull.Text := DT( GetStr( gsLastServerPull ) );
      emLastRead.Text := DT( GetStr( gsLastClientRead ) );
      
   end;
end;

procedure TfrmConfGrp.FormToSettings;

   procedure TakeEM( ID: Integer; EM: TEdit ); overload;
   begin
      if not EM.Enabled then exit;
      if SelSettings.GetStr( ID ) = EM.Text then exit;
      SelSettings.SetStr( ID, EM.Text );
   end;

   procedure TakeEM( ID: Integer; EM: TComboBox ); overload;
   begin
      if not EM.Enabled then exit;
      if SelSettings.GetStr( ID ) = EM.Text then exit;
      SelSettings.SetStr( ID, EM.Text );
   end;

   procedure TakeCK( ID: Integer; CK: TCheckBox );
   begin
      if not CK.Enabled then exit;
      if SelSettings.GetBoo( ID ) = CK.Checked then exit;
      SelSettings.SetBoo( ID, CK.Checked );
   end;

   procedure TakeCB( ID: Integer; CB: TComboBox );
   begin
      if not CB.Enabled then exit;
      if SelSettings.GetInt( ID ) = CB.ItemIndex then exit;
      SelSettings.SetInt( ID, CB.ItemIndex );
   end;

var  s: String;
begin
   if SelItemType = selNone       then exit;
   if SelItemName = ''            then exit;
   if not Assigned( SelSettings ) then exit;

   TakeEM( gsDescription, emDescription );

   s := copy( 'ynmg', cbGroupType.ItemIndex + 1, 1 );
   if s <> SelSettings.GetStr(gsGroupType) then SelSettings.SetStr(gsGroupType,s);

   TakeEM( gsPostServer, cbPostServer );
   TakeEM( gsModerator, emModerator );
   TakeEM( gsPullLimit, emPullLimit );
   TakeEM( gsPurgeKeepDays, emKeepDays );
   TakeCK( gsAutoUnsubscribe, ckAutoUnsubscribe );
   TakeCK( gsAutoAddPulls, ckAutoAddPulls );
   TakeCK( gsFeedOnly, ckFeedOnly );
end;

function TfrmConfGrp.LoadItemList: Boolean;

   procedure AddItems( LqReqId, setId: Integer );
   var  Reply: TLiveMsg;
        SL: TStringList;
        i: Integer;
   begin
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LqReqId, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            SL := TStringList.Create;
            try
               SL.Text := Reply.MsgData;
               for i:=0 to SL.Count-1 do begin
                  lbItems.Items.AddObject( SL[i], Pointer( setId ) );
               end;
            finally SL.Free end;
         end;
      finally Reply.Free end;
   end;

begin
   Result := False;

   try
      SelItemType := selNone;
      SelItemName := '';
      SelSettings := nil;

      lbItems.Items.BeginUpdate;
      try
         lbItems.Items.Clear;
         lbItems.ItemIndex := -1;
         AddItems( LMREQ_GROUPS_LIST, selGrp );
      finally lbItems.Items.EndUpdate end;

      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Load Item List', mtError, [mbOK] );
      end;
   end;
end;

function TfrmConfGrp.LoadSettings: Boolean;

   procedure LoadServers;
   var  Reply: TLiveMsg;
   begin
      cbPostServer.Clear;

      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_SRVNNTP_LIST, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            cbPostServer.Items.Text := Reply.MsgData;
         end;
      finally Reply.Free end;
   end;

begin
   Result := False;

   try
      if lbItems.Items.Count = 0 then LoadItemList;

      if Assigned( SelSettings ) then FreeAndNil( SelSettings );
      if SelItemName = '' then SelItemType := selNone;

      case SelItemType of
         selNone: SelSettings := TSettingsPlain.Create(
                     SettingsDef_Groups,
                     TSettingsHandler_InMemory.Create( '' ),
                     False {don't AutoFlush}
                  );
         selGrp : SelSettings := TSettingsPlain.Create(
                     SettingsDef_Groups,
                     TSettingsHandler_LiveRemote.Create(
                        LiveConnector, SelItemName,
                        LMREQ_GROUPS_SETTING_GET, LMREQ_GROUPS_SETTING_SET
                     ),
                     False {don't AutoFlush}
                  );
      end;

      LoadServers;
      
      SettingsToForm;

      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Load Settings', mtError, [mbOK] );
      end;
   end;
end;

function TfrmConfGrp.SaveSettings: Boolean;
begin
   Result := False;

   try
      if SelItemType = selNone       then exit;
      if SelItemName = ''            then exit;
      if not Assigned( SelSettings ) then exit;

      FormToSettings;
      SelSettings.Flush;

      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Save Settings', mtError, [mbOK] );
      end;
   end;
end;

procedure TfrmConfGrp.btnRefreshClick(Sender: TObject);
begin
   btnOK.Enabled := LoadSettings;
end;

procedure TfrmConfGrp.btnOKClick(Sender: TObject);
begin
   if not SaveSettings then ModalResult := mrNone;
end;

procedure TfrmConfGrp.btnApplyClick(Sender: TObject);
begin
   SaveSettings;
end;

procedure TfrmConfGrp.lbItemsClick(Sender: TObject);
begin
   with lbItems do begin
      if ( ItemIndex < 0 ) or ( ItemIndex >= Items.Count ) then begin
         SelItemType := selNone;
         SelItemName := '';
      end else begin
         SelItemType := Integer( Items.Objects[ ItemIndex ] );
         SelItemName := Items[ ItemIndex ];
      end;
   end;

   LoadSettings;

   grpSet.Enabled := ( SelItemType <> selNone );
   grpInf.Enabled := ( SelItemType <> selNone );
end;

procedure TfrmConfGrp.popItemsPopup(Sender: TObject);
begin
   with lbItems do begin
      mnuGrpDel.Enabled := ( ItemIndex >= 0 ) and ( ItemIndex < Items.Count );
   end;
end;

procedure TfrmConfGrp.mnuGrpAddClick(Sender: TObject);
var  Nam: String;
     Idx: Integer;
begin
   Nam := '';
   if not InputDlgStr( 'Add group', 'Group name:', Nam, 0 ) then exit;
   if Nam = '' then exit;

   if not IsNewsgroup( Nam ) then begin
      HMessageDlg( 'Invalid group name "' + Nam + '"!',
                   'Add group', mtWarning, [mbOK] );
      exit;
   end;

   Idx := lbItems.Items.IndexOf( Nam );
   if Idx >= 0 then begin
      HMessageDlg( 'Group "' + Nam + '" already exists!',
                   'Add group', mtWarning, [mbOK] );
      exit;
   end;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_GROUPS_ADD, Nam )
   );

   LoadItemList;
   btnRefresh.Click;

   Idx := lbItems.Items.IndexOf( Nam );
   if Idx >= 0 then begin lbItems.ItemIndex:=Idx; lbItemsClick(nil) end;
end;

procedure TfrmConfGrp.mnuGrpDelClick(Sender: TObject);
var  Idx: Integer;
     Nam, s: String;
begin
   Idx := lbItems.ItemIndex;
   if ( Idx < 0 ) or ( Idx >= lbItems.Items.Count ) then exit;
   Nam := lbItems.Items[Idx];

   s := Format( 'Delete group "%s" with all its articles now?', [Nam] );
   if HMessageDlg( PChar(s), mtConfirmation, [mbYes,mbNo] ) <> mrYes then exit;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_GROUPS_DELETE, Nam )
   );

   LoadItemList;
   btnRefresh.Click;

   if Idx >= lbItems.Items.Count then dec( Idx );
   if Idx >= 0 then begin lbItems.ItemIndex:=Idx; lbItemsClick(nil) end;
end;

end.
