// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fConfApp; 

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dDialogs, StdCtrls, cSettings, ComCtrls;

type
  TfrmConfApp = class(TForm)
    btnRefresh: TButton;
    btnOK: TButton;
    btnCancel: TButton;
    btnApply: TButton;
    PageControl1: TPageControl;
    pgService: TTabSheet;
    pgLogFile: TTabSheet;
    pgDirs: TTabSheet;
    grpSvc: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    emSvcFile: TEdit;
    emSvcName: TEdit;
    emSvcDisplayName: TEdit;
    emSvcDependencies: TEdit;
    ckSvcInteractive: TCheckBox;
    grpLog: TGroupBox;
    Label17: TLabel;
    Label18: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    chkVError: TCheckBox;
    chkVWarning: TCheckBox;
    chkVSystem: TCheckBox;
    chkVInfo: TCheckBox;
    chkVDebug: TCheckBox;
    chkFError: TCheckBox;
    chkFWarning: TCheckBox;
    chkFSystem: TCheckBox;
    chkFInfo: TCheckBox;
    chkFDebug: TCheckBox;
    emLogFiles: TEdit;
    emLogView: TEdit;
    chkFDetail: TCheckBox;
    chkVDetail: TCheckBox;
    GroupBox1: TGroupBox;
    Label5: TLabel;
    emDirStartup: TEdit;
    Label6: TLabel;
    emDirBase: TEdit;
    Label7: TLabel;
    emDirLogs: TEdit;
    Label8: TLabel;
    emDirServer: TEdit;
    Label9: TLabel;
    emDirGroups: TEdit;
    Label10: TLabel;
    emDirMails: TEdit;
    Label11: TLabel;
    emDirNewsOut: TEdit;
    Label12: TLabel;
    emDirMailOut: TEdit;
    Label15: TLabel;
    emDirNewsErr: TEdit;
    Label16: TLabel;
    emDirScripts: TEdit;
    Label19: TLabel;
    emDirModules: TEdit;
    Label20: TLabel;
    Label21: TLabel;
    emSvcVersion: TEdit;
    ckLogMSecs: TCheckBox;
    Label22: TLabel;
    emDirReports: TEdit;
    procedure btnRefreshClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
    Settings: TSettingsPlain;
    procedure SettingsToForm;
    procedure FormToSettings;
    function  LoadSettings: Boolean;
    function  SaveSettings: Boolean;
  public
    { Public-Deklarationen }
  end;


implementation

{$R *.DFM}

uses uConst, uConstVar, uGlobal, cSettingsHdlLive, uTools;

procedure TfrmConfApp.FormCreate( Sender: TObject );
begin
   GrowDpiForm( self );

   Settings := nil;
   PageControl1.ActivePageIndex := 0;
   btnRefresh.Click;
end;

procedure TfrmConfApp.FormResize(Sender: TObject);
begin
   PageControl1.Width  := ClientWidth  - 2 * PageControl1.Left;
   PageControl1.Height := ClientHeight - 3 * PageControl1.Top - btnOk.Height;
   btnOk.Top      := ClientHeight - btnOk.Height - PageControl1.Top;
   btnApply.Top   := ClientHeight - btnOk.Height - PageControl1.Top;
   btnRefresh.Top := ClientHeight - btnOk.Height - PageControl1.Top;
   btnCancel.Top  := ClientHeight - btnOk.Height - PageControl1.Top;
end;

procedure TfrmConfApp.FormDestroy( Sender: TObject );
begin
   if Assigned( Settings ) then Settings.Free;
end;

procedure TfrmConfApp.SettingsToForm;
var  i: Integer;
begin
   if not Assigned( Settings ) then exit;

   with Settings do begin

      // Service
      emSvcFile.Text           := GetStr( asServiceFile );
      emSvcName.Text           := GetStr( asServiceName );
      emSvcDisplayName.Text    := GetStr( asDisplayName );
      emSvcDependencies.Text   := GetStr( asDependencies );
      ckSvcInteractive.Checked := GetBoo( asInteractive );
      emSvcVersion.Text        := GetStr( asServiceVersion );
      if emSvcVersion.Text <> HServiceVersion then begin
         HServiceVersion := emSvcVersion.Text;
         SaveLocalSettings;  
      end;

      // Log File
      emLogFiles.Text := GetStr( asLogFileMax );
      emLogView.Text  := GetStr( asLogViewMax );

      i := GetHexInt( asLogFileMask );
      chkFError  .Checked := (i and LOGID_ERROR )<>0;
      chkFWarning.Checked := (i and LOGID_WARN  )<>0;
      chkFSystem .Checked := (i and LOGID_SYSTEM)<>0;
      chkFInfo   .Checked := (i and LOGID_INFO  )<>0;
      chkFDetail .Checked := (i and LOGID_DETAIL)<>0;
      chkFDebug  .Checked := (i and LOGID_DEBUG )<>0;

      i := GetHexInt( asLogViewMask );
      chkVError  .Checked := (i and LOGID_ERROR )<>0;
      chkVWarning.Checked := (i and LOGID_WARN  )<>0;
      chkVSystem .Checked := (i and LOGID_SYSTEM)<>0;
      chkVInfo   .Checked := (i and LOGID_INFO  )<>0;
      chkVDetail .Checked := (i and LOGID_DETAIL)<>0;
      chkVDebug  .Checked := (i and LOGID_DEBUG )<>0;

      ckLogMSecs.Checked := GetBoo( asLogMSecs );

      // Directories
      emDirStartup.Text := GetStr( asPathStartup );
      emDirBase.Text    := GetStr( asPathBase );
      emDirLogs.Text    := GetStr( asPathLogs );
      emDirServer.Text  := GetStr( asPathServer );
      emDirGroups.Text  := GetStr( asPathGroups );
      emDirMails.Text   := GetStr( asPathMails );
      emDirNewsOut.Text := GetStr( asPathNewsOut );
      emDirMailOut.Text := GetStr( asPathMailOut );
      emDirNewsErr.Text := GetStr( asPathNewsErr );
      emDirScripts.Text := GetStr( asPathScripts );
      emDirModules.Text := GetStr( asPathModules );
      emDirReports.Text := GetStr( asPathReports );

   end;
end;

procedure TfrmConfApp.FormToSettings;

   procedure TakeEM( ID: Integer; EM: TEdit );
   begin
      if not EM.Enabled then exit;
      if Settings.GetStr( ID ) = EM.Text then exit;
      Settings.SetStr( ID, EM.Text );
   end;

   procedure TakeCK( ID: Integer; CK: TCheckBox );
   begin
      if not CK.Enabled then exit;
      if Settings.GetBoo( ID ) = CK.Checked then exit;
      Settings.SetBoo( ID, CK.Checked );
   end;

var  i: Integer;
begin
   if not Assigned( Settings ) then exit;

   // Service
   // {readonly} TakeEM( asServiceFile, emSvcFile );
   // {readonly} TakeEM( asServiceName, emSvcName );
   TakeEM( asDisplayName,  emSvcDisplayName  );
   TakeEM( asDependencies, emSvcDependencies );
   TakeCK( asInteractive,  ckSvcInteractive  );

   // Log File
   TakeEM( asLogFileMax, emLogFiles );
   TakeEM( asLogViewMax, emLogView  );

   i := 0;
   if chkFError  .Checked then i := (i or LOGID_ERROR );
   if chkFWarning.Checked then i := (i or LOGID_WARN  );
   if chkFSystem .Checked then i := (i or LOGID_SYSTEM);
   if chkFInfo   .Checked then i := (i or LOGID_INFO  );
   if chkFDetail .Checked then i := (i or LOGID_DETAIL);
   if chkFDebug  .Checked then i := (i or LOGID_DEBUG );
   if i <> Settings.GetHexInt( asLogFileMask ) then begin
      Settings.SetHexInt( asLogFileMask, i );
   end;

   i := 0;
   if chkVError  .Checked then i := (i or LOGID_ERROR );
   if chkVWarning.Checked then i := (i or LOGID_WARN  );
   if chkVSystem .Checked then i := (i or LOGID_SYSTEM);
   if chkVInfo   .Checked then i := (i or LOGID_INFO  );
   if chkVDetail .Checked then i := (i or LOGID_DETAIL);
   if chkVDebug  .Checked then i := (i or LOGID_DEBUG );
   if i <> Settings.GetHexInt( asLogViewMask ) then begin
      Settings.SetHexInt( asLogViewMask, i );
   end;

   TakeCK( asLogMSecs, ckLogMSecs );

   // Directories
   // (all read-only)
end;

function TfrmConfApp.LoadSettings: Boolean;
begin
   Result := False;

   try
      if Assigned( Settings ) then FreeAndNil( Settings );

      Settings := TSettingsPlain.Create(
         SettingsDef_App,
         TSettingsHandler_LiveRemote.Create(
            LiveConnector, '',
            LMREQ_APP_SETTING_GET, LMREQ_APP_SETTING_SET
         ),
         False {don't AutoFlush}
      );

      SettingsToForm;
      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Load Settings', mtError, [mbOK] );
      end;
   end;
end;

function TfrmConfApp.SaveSettings: Boolean;
begin
   Result := False;

   try
      if not Assigned( Settings ) then exit;
      FormToSettings;
      Settings.Flush;
      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Save Settings', mtError, [mbOK] );
      end;
   end;
end;

procedure TfrmConfApp.btnRefreshClick(Sender: TObject);
begin
   btnOK.Enabled := LoadSettings;
end;

procedure TfrmConfApp.btnOKClick(Sender: TObject);
begin
   if not SaveSettings then ModalResult := mrNone;
end;

procedure TfrmConfApp.btnApplyClick(Sender: TObject);
begin
   SaveSettings;
end;

end.
