// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit dDialogs;

interface

{$INCLUDE Compiler.inc}

uses Dialogs;

// Like Dialogs.MessageDlg, but Form/Button captions translated to English.
function HMessageDlg( const Msg: string;
                      DlgType: TMsgDlgType;
                      Buttons: TMsgDlgButtons ): Integer; overload;
function HMessageDlg( const Msg, Cap: string;
                      DlgType: TMsgDlgType;
                      Buttons: TMsgDlgButtons ): Integer; overload;

implementation

uses Consts, Forms, StdCtrls;

function DlgTranslate( const s: String ): String;
begin
   if      s=SMsgDlgWarning     then Result := 'Warning'
   else if s=SMsgDlgError       then Result := 'Error'
   else if s=SMsgDlgInformation then Result := 'Information'
   else if s=SMsgDlgConfirm     then Result := 'Confirm'
   else if s=SMsgDlgYes         then Result := '&Yes'
   else if s=SMsgDlgNo          then Result := '&No'
   else if s=SMsgDlgOK          then Result := 'OK'
   else if s=SMsgDlgCancel      then Result := 'Cancel'
   else if s=SMsgDlgHelp        then Result := '&Help'
   else if s=SMsgDlgHelpNone    then Result := 'No help available'
   else if s=SMsgDlgHelpHelp    then Result := 'Help'
   else if s=SMsgDlgAbort       then Result := '&Abort'
   else if s=SMsgDlgRetry       then Result := '&Retry'
   else if s=SMsgDlgIgnore      then Result := '&Ignore'
   else if s=SMsgDlgAll         then Result := '&All'
   else if s=SMsgDlgNoToAll     then Result := '&All No'
   else if s=SMsgDlgYesToAll    then Result := 'A&ll Yes'
   else                              Result := s;
end;

function HMessageDlg( const Msg: string;
                      DlgType: TMsgDlgType;
                      Buttons: TMsgDlgButtons ): Integer;
begin
   Result := HMessageDlg( Msg, '', DlgType, Buttons );
end;

function HMessageDlg( const Msg, Cap: string;
                      DlgType: TMsgDlgType;
                      Buttons: TMsgDlgButtons ): Integer;
var  F: TForm;
     i: Integer;
begin
   F := CreateMessageDialog( Msg, DlgType, Buttons );
   try
      if Cap = '' then F.Caption := DlgTranslate( F.Caption )
                  else F.Caption := Cap;
      for i := 0 to F.ControlCount - 1 do begin
         if F.Controls[i] is TButton then begin
            with TButton( F.Controls[i] ) do Caption := DlgTranslate(Caption);
         end;
      end;
      F.Position := poScreenCenter;
      Result := F.ShowModal;
   finally F.Free end;
end;

end.
