// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit uConstVar; // "constant variables" (initialized on startup)    

interface

{$INCLUDE Compiler.inc}

uses Windows, SyncObjs, cSyncObjects, uConst, uType, cSettingsDef, cSettings;

// ----------------------------------------------------------------------------

var
   // settings definitions
   SettingsDef_App     : TSettingsDef;
   SettingsDef_Hamster : TSettingsDef;
   SettingsDef_Server  : TSettingsDef;
   SettingsDef_Groups  : TSettingsDef;
   SettingsDef_Pulls   : TSettingsDef;
   SettingsDef_Accounts: TSettingsDef;

// ----------------------------------------------------------------------------

var
   // security attributes and descriptor for kernel objects
   SecurityAttributesEveryone  : SECURITY_ATTRIBUTES;
   lpSecurityAttributesEveryone: Pointer  = nil;
   lpSecurityDescriptorEveryone: PSECURITY_DESCRIPTOR = nil;

// ----------------------------------------------------------------------------

implementation

uses SysUtils, uTools, IniFiles;

procedure Init_SecurityAttributes;
begin
   lpSecurityAttributesEveryone := nil;
   lpSecurityDescriptorEveryone := nil;

   if not IsWindowsNT then exit;

   // create descriptor
   lpSecurityDescriptorEveryone := PSECURITY_DESCRIPTOR(
      LocalAlloc( LPTR, SECURITY_DESCRIPTOR_MIN_LENGTH )
   );
   if Assigned( lpSecurityDescriptorEveryone ) then begin

      if InitializeSecurityDescriptor(
            lpSecurityDescriptorEveryone, SECURITY_DESCRIPTOR_REVISION
         ) then begin

         // assign security descriptor a "NULL DACL" (-> "everyone")
         if SetSecurityDescriptorDacl(
               lpSecurityDescriptorEveryone, TRUE, nil, FALSE
            ) then begin

            // init security attributes with new descriptor
            with SecurityAttributesEveryone do begin
               nLength              := sizeof( SecurityAttributesEveryone );
               lpSecurityDescriptor := lpSecurityDescriptorEveryone;
               bInheritHandle       := TRUE;
            end;
            lpSecurityAttributesEveryone := @SecurityAttributesEveryone;

         end;

      end;

   end;
end;

procedure Init_SettingsDef_App;
var  i: Integer;
begin
   SettingsDef_App := TSettingsDef.Create;

   with SettingsDef_App do begin

      Add( asServiceFile,    'App', 'ServiceFile',   ''               );
      Add( asServiceName,    'App', 'ServiceName',   'HamsterService' );
      Add( asDisplayName,    'App', 'DisplayName',   'HamsterService' );
      Add( asDependencies,   'App', 'Dependencies',  ''{'RPCSS'}      );
      Add( asInteractive,    'App', 'Interactive',   '0'              );
      Add( asObjectPrefix,   'App', 'ObjectPrefix',  ''               );
      Add( asServiceVersion, 'App', 'ServiceVersion', GetExeVersion  ); 

      i := LOGID_ERROR or LOGID_WARN or LOGID_SYSTEM or LOGID_INFO or LOGID_DETAIL;
      Add( asLogFileMask, 'Setup', 'log.file.mask',   inttohex(i,4) );

      i := LOGID_ERROR or LOGID_WARN or LOGID_SYSTEM or LOGID_INFO;
      Add( asLogViewMask, 'Setup', 'log.view.mask',   inttohex(i,4) );

      i := LOGID_ERROR or LOGID_WARN or LOGID_SYSTEM or LOGID_INFO or LOGID_STATUS;
      Add( asLogTaskMask, 'Setup', 'log.thread.mask', inttohex(i,4) );

      Add( asLogFileMax,  'Setup', 'log.file.max', '14'  );
      Add( asLogViewMax,  'Setup', 'log.view.max', '250' );
      Add( asLogMSecs,    'Setup', 'log.msecs',    '0'   );

      Add( asPathStartup, 'Directories', 'Startup',  '' );
      Add( asPathBase,    'Directories', 'Main',     '' );
      Add( asPathLogs,    'Directories', 'Logs',     '' );
      Add( asPathServer,  'Directories', 'Server',   '' );
      Add( asPathGroups,  'Directories', 'Groups',   '' );
      Add( asPathMails,   'Directories', 'Mails',    '' );
      Add( asPathNewsOut, 'Directories', 'News.Out', '' );
      Add( asPathMailOut, 'Directories', 'Mail.Out', '' );
      Add( asPathNewsErr, 'Directories', 'News.Err', '' );
      Add( asPathScripts, 'Directories', 'Scripts',  '' );
      Add( asPathModules, 'Directories', 'Modules',  '' );
      Add( asPathReports, 'Directories', 'Reports',  '' );

   end;
end;

procedure Init_SettingsDef_Hamster;
begin
   SettingsDef_Hamster := TSettingsDef.Create;

   with SettingsDef_Hamster do begin

      Add( hsLocalNntpAutostart,      'Setup', 'local.autostart.nntp',      '1'            );
      Add( hsLocalNntpBind,           'Setup', 'local.bind.nntp',           '127.0.0.1'    );
      Add( hsLocalNntpPort,           'Setup', 'local.port.nntp',           '119'          );
      Add( hsLocalNntpClients,        'Setup', 'local.clients.nntp',        '10'           );
      Add( hsLocalNntpSameCli,        'Setup', 'local.samecli.nntp',        '4'            );
      Add( hsLocalNntpLimitLineLen,   'Setup', 'local.limit.linelen.nntp',  '1000'         );
      Add( hsLocalNntpLimitTextSize,  'Setup', 'local.limit.textsize.nntp', '1048576'      );
      Add( hsLocalNntpGetUnknownMIDs, 'Setup', 'local.nntp.SearchUnknownMIDs', '1' );
      Add( hsLocalNntpLocalInjection, 'Setup', 'news.localinjection',          '0' );
      Add( hsLocalNntpInactivitySec,  'Setup', 'local.nntp.inactivitysec',  '0' );

      Add( hsLocalPop3Autostart,      'Setup', 'local.autostart.pop3',      '1'            );
      Add( hsLocalPop3Bind,           'Setup', 'local.bind.pop3',           '127.0.0.1'    );
      Add( hsLocalPop3Port,           'Setup', 'local.port.pop3',           '110'          );
      Add( hsLocalPop3Clients,        'Setup', 'local.clients.pop3',        '10'           );
      Add( hsLocalPop3SameCli,        'Setup', 'local.samecli.pop3',        '4'            );
      Add( hsLocalPop3LimitLineLen,   'Setup', 'local.limit.linelen.pop3',  '1000'         );
      Add( hsLocalPop3LimitTextSize,  'Setup', 'local.limit.textsize.pop3', '5242880'      );
      Add( hsLocalPop3SASL,           'Setup', 'local.pop3.sasl',           SASL_SUPPORTED );
      Add( hsLocalPop3InactivitySec,  'Setup', 'local.pop3.inactivitysec',  '0' );

      Add( hsLocalSmtpAutostart,      'Setup', 'local.autostart.smtp',      '1'            );
      Add( hsLocalSmtpBind,           'Setup', 'local.bind.smtp',           '127.0.0.1'    );
      Add( hsLocalSmtpPort,           'Setup', 'local.port.smtp',           '25'           );
      Add( hsLocalSmtpClients,        'Setup', 'local.clients.smtp',        '10'           );
      Add( hsLocalSmtpSameCli,        'Setup', 'local.samecli.smtp',        '4'            );
      Add( hsLocalSmtpLimitLineLen,   'Setup', 'local.limit.linelen.smtp',  '1000'         );
      Add( hsLocalSmtpLimitTextSize,  'Setup', 'local.limit.textsize.smtp', '5242880'      );
      Add( hsLocalSmtpSASL,           'Setup', 'local.smtp.sasl',           SASL_SUPPORTED );
      Add( hsLocalSmtpAuthReq,        'Setup', 'local.authreq.smtp',        '0' );
      Add( hsLocalSmtpEAuthReq,       'Setup', 'local.authreq.esmtp',       '0' );
      Add( hsLocalSmtpAfterPop3Time,  'Setup', 'local.smtpafterpop3.period', '300' );
      Add( hsLocalSmtpNoAuthForLocal, 'Setup', 'local.mail.reqnotauth',     '0' );
      Add( hsLocalSmtpInactivitySec,  'Setup', 'local.smtp.inactivitysec',  '0' );
      Add( hsLocalSmtpApplyTraps,     'Setup', 'local.smtp.applytraps',     '0' );

      Add( hsLocalRecoAutostart,      'Setup', 'local.autostart.reco',      '1'            );
      Add( hsLocalRecoBind,           'Setup', 'local.bind.reco',           '127.0.0.1'    );
      Add( hsLocalRecoPort,           'Setup', 'local.port.reco',           '23'           );
      Add( hsLocalRecoClients,        'Setup', 'local.clients.reco',        '10'           );
      Add( hsLocalRecoSameCli,        'Setup', 'local.samecli.reco',        '4'            );
      Add( hsLocalRecoLimitLineLen,   'Setup', 'local.limit.linelen.reco',  '1000'         );
      Add( hsLocalRecoLimitTextSize,  'Setup', 'local.limit.textsize.reco', '1048576'      );
      Add( hsLocalRecoSASL,           'Setup', 'local.reco.sasl',           SASL_SUPPORTED );
      Add( hsLocalRecoInactivitySec,  'Setup', 'local.reco.inactivitysec',  '0' );

      Add( hsMailAddReceived, 'Setup', 'mail.addreceived', '1' );
      Add( hsMailAddXHamster, 'Setup', 'mail.addxhamster', '1' );
      Add( hsNewsAddXHamster, 'Setup', 'news.addxhamster', '1' );
      Add( hsNewsAddXTrace,   'Setup', 'news.addxtrace',   '0' );

      Add( hsTasksLimit,            'Setup', 'tasks.limit',             '8'    );
      Add( hsPullLimit,             'Setup', 'pull.limit',              '-100' );
      Add( hsPullLimitFirst,        'Setup', 'pull.limit.first',        '100'  );
      Add( hsPurgeArticlesKeepDays, 'Setup', 'purge.articles.keepdays', '7'    );
      Add( hsPurgeHistoryKeepDays,  'Setup', 'purge.history.keepdays',  '7'    );
      Add( hsPurgeKillsKeepDays,    'Setup', 'purge.kills.keepdays',    '7'    );
      Add( hsPurgeMHistoryKeepDays, 'Setup', 'purge.mhistory.keepdays', '14'   );

      Add( hsLocalTimeoutInactivity, 'Setup', 'local.timeout.inactivity', '60'  );
      Add( hsLocalTimeoutQuitDelay,  'Setup', 'local.timeout.quitdelay',  '100' );
      Add( hsRemoteTimeoutConnect,   'Setup', 'remote.timeout.connect',   '120' );
      Add( hsRemoteTimeoutCommand,   'Setup', 'remote.timeout.command',   '120' );
      Add( hsPasswordCodeBase,       'Setup', 'password.codebase',        '0'   );

      Add( hsGenerateNewsMID, 'Setup', 'generate.MID',      '0' );
      Add( hsGenerateMailMID, 'Setup', 'mail.generate.MID', '0' );
      Add( hsFQDNforMID,      'Setup', 'FQDN',              ''  );

      Add( hsHistoryChunkBits,      'Setup', 'history.chunkbits',      '4' );
      Add( hsIsLocalDomain,         'Setup', 'local.mail.islocaldomain', '.*hamster|\[?127\.0\.0\.1\]?|.*invalid' );
      Add( hsPostServer,            'Setup', 'preferred.postserver',   ''  );
      Add( hsSmtpServer,            'Setup', 'preferred.smtpserver',   ''  );
      Add( hsLeaveMailsOnServer,    'Setup', 'mail.leaveonserver',     '1' );
      Add( hsIgnoreAlreadyLoaded,   'Setup', 'mail.filterbyuidl',      '0' );
      Add( hsMailDeleteLoadedAfter, 'Setup', 'mail.deleteloadedafter', '0' );
      Add( hsMailJunkAccount,       'Setup', 'mail.junkaccount',       'admin' );
      Add( hsMailTrapAcceptScore,   'Setup', 'mail.trap.acceptscore',  '10' );
      Add( hsMailTrapDeleteScore,   'Setup', 'mail.trap.deletescore',  '-10' );
      Add( hsMailTopSkipSize,       'Setup', 'mail.topskip.size',      '4096' );
      Add( hsMailJunkSkipFiltKill,   'Setup', 'mail.junkskip.FiltKill',   '0' );
      Add( hsMailJunkSkipTrapDelete, 'Setup', 'mail.junkskip.TrapDelete', '0' );
      Add( hsMailJunkSkipTrapScore,  'Setup', 'mail.junkskip.TrapScore',  '0' );
      Add( hsMailJunkSkipScoreLimit, 'Setup', 'mail.junkskip.ScoreLimit', '-100' );
      Add( hsMailSpamReportAccount,  'Setup', 'mail.spamreportaccount',   'admin' );
      Add( hsIgnoreAlreadyFiltered,  'Setup', 'mail.ignorefiltered',      '0' );
      Add( hsLeaveButDeleteFiltered, 'Setup', 'mail.leavebutdelfilt',     '0' );
      Add( hsMailNotifyAccount,      'Setup', 'mail.notifyaccount',       'admin' );

      Add( hsMailSizeIgnore,      'Setup', 'mail.filter.mailsize.ignore', '0'     );
      Add( hsMailSizeKill,        'Setup', 'mail.filter.mailsize.kill',   '0'     );
      Add( hsMailSizeNotify,      'Setup', 'mail.filter.mailsize.notify', '0'     );
      Add( hsNoOfTopLinesToLoad,  'Setup', 'mail.filter.toplines',        '50'    );
      Add( hsScoreLogLimit,       'Setup', 'score.loglimit',              '-9999' );
      Add( hsSendMailAttemptsMax, 'Setup', 'sendmail.attempts.max',       '10'    );
      Add( hsSendMailAttemptsDel, 'Setup', 'sendmail.attempts.del',       '0'     );
      Add( hsGateAddFUpPoster,    'Setup', 'mail.flupforgate',            '1'     );

      Add( hsAutoUnsubscribePulls,  'Setup', 'autounsubscribe.pulls',  '0' );
      Add( hsAutoUnsubscribeGroups, 'Setup', 'autounsubscribe.groups', '0' );
      
      Add( hsDailyUnsubscribe, 'Setup', 'daily.unsubscribe', '0' );
      Add( hsDailyPurge,       'Setup', 'daily.purge',       inttostr(HAM_PURGEOPT_DONOTHING) );
      Add( hsDailyBuildLists,  'Setup', 'daily.buildlists',  '1' );
      Add( hsDailyStatistics,  'Setup', 'daily.statistics',  '1' );

      Add( hsSocksVersion, 'Setup', 'socks.version', '0'    );
      Add( hsSocksServer,  'Setup', 'socks.server',  ''     );
      Add( hsSocksPort,    'Setup', 'socks.port',    '1080' );
      Add( hsSocksAuth,    'Setup', 'socks.auth',    '0'    );
      Add( hsSocksUser,    'Setup', 'socks.user',    ''     );
      Add( hsSocksPass,    'Setup', 'socks.pass',    ''     );

      Add( hsHamGroupDefault,      'Setup', 'internalgroup.default',      'internal.misc' );
      Add( hsHamGroupPostOk,       'Setup', 'internalgroup.postok',       'internal.misc' );
      Add( hsHamGroupPostErrors,   'Setup', 'internalgroup.posterrors',   'internal.misc' );
      Add( hsHamGroupStatistics,   'Setup', 'internalgroup.statistics',   'internal.misc' );
      Add( hsHamGroupCancelNotify, 'Setup', 'internalgroup.cancelnotify', 'internal.misc' );
      Add( hsHamGroupNewGroups,    'Setup', 'internalgroup.newgroups',    'internal.misc' );
      Add( hsHamGroupUnknownGroup, 'Setup', 'internalgroup.unknowngroup', 'internal.misc' );
      Add( hsHamGroupPullErrors,   'Setup', 'internalgroup.pullerrors',   'internal.misc' );

      Add( hsStatsLastInfoMsg,    'Stats',  'LastInfoMsg', '' );
      Add( hsLastAutoUnsubscribe, 'Marker', 'LastAutoUnsubscribe', '' );
      Add( hsLastDaily,           'Marker', 'LastDaily', '' );

   end;
end;

procedure Init_SettingsDef_Server;
begin
   SettingsDef_Server := TSettingsDef.Create;

   with SettingsDef_Server do begin

      Add( ssTimeoutConnect, 'Setup', 'RemoteTimeoutConnect', ''  );
      Add( ssTimeoutCommand, 'Setup', 'RemoteTimeoutCommand', ''  );
      Add( ssUseSocks,       'Setup', 'SOCKS',                '1' );
      Add( ssDisabled,       'Setup', 'Disabled',             '0' );
      Add( ssSSLMode,        'Setup', 'UseSSL',               '0' );
      Add( ssSSLVersion,     'Setup', 'SSLVersion',           '2' ); // =sslvSSLv3
      Add( ssSSLCipher,      'Setup', 'SSLCipher',            ''  );

      Add( ssNntpReadOnly,       'Setup',     'ReadOnly',         '0' );
      Add( ssNntpPullThreads,    'Pull',      'Threads',          '1' );
      Add( ssNntpReloadGroups,   'Pull',      'ReloadGroups',     '0' );
      Add( ssNntpReloadGroupsDT, 'Pull',      'ReloadGroupsLast', ''  );
      Add( ssNntpLoadDescsMode,  'Newgroups', 'LoadDescs',        '0' );
      Add( ssNntpReloadDescs,    'Pull',      'ReloadDescs',      '0' );
      Add( ssNntpReloadDescsDT,  'Pull',      'ReloadDescsLast',  ''  );
      Add( ssNntpLastNewGroups,  'Newgroups', 'LastGMT',          ''  );
      Add( ssNntpNewGroupsY2K,   'Newgroups', '4-Digit-Years',    '0' );

      Add( ssPop3LocalUser,     'POP3', 'LocalUser',     'admin' );
      Add( ssPop3FilterSection, 'POP3', 'FilterSection', '*'     );
      Add( ssPop3LeaveOnServer, 'POP3', 'LeaveOnServer', '0'     );
      Add( ssPop3UseAuthPass,   'POP3', 'AuthPass',      '1'     );
      Add( ssPop3UseAuthApop,   'POP3', 'AuthApop',      '0'     );
      Add( ssPop3UseAuthAuth,   'POP3', 'AuthAuth',      '0'     );
      Add( ssPop3UseSasl,       'POP3', 'SASL',   SASL_SUPPORTED );
      Add( ssPop3AutoDistribute,'POP3', 'AutoDistribute', '0' );

      Add( ssSmtpUseAuth, 'SMTP', 'AUTH', '0'            );
      Add( ssSmtpUseSasl, 'SMTP', 'SASL', SASL_SUPPORTED );

   end;
end;

procedure Init_SettingsDef_Groups;
begin
   SettingsDef_Groups := TSettingsDef.Create;

   with SettingsDef_Groups do begin

      Add( gsLocalMin,        'Ranges', 'Local.Min',               '1' );
      Add( gsLocalMax,        'Ranges', 'Local.Max',               '0' );
      Add( gsCreated,         'Info',   'Created',                 ''  );
      Add( gsPullLimit,       'Setup',  'pull.limit',              ''  );
      Add( gsPurgeKeepDays,   'Setup',  'purge.articles.keepdays', ''  );
      Add( gsDescription,     'Info',   'Description',             ''  );
      Add( gsGroupType,       'Setup',  'type',                    'y' );
      Add( gsPostServer,      'Setup',  'postserver',              ''  );
      Add( gsLastClientRead,  'Info',   'LastClientRead',          ''  );
      Add( gsLastServerPull,  'Info',   'LastServerPull',          ''  );
      Add( gsAutoUnsubscribe, 'Setup',  'autounsubscribe',         '1' );
      Add( gsAutoAddPulls,    'Setup',  'autoaddpulls',            '1' );
      Add( gsModerator,       'Setup',  'moderator',               ''  );
      Add( gsFeedOnly,        'Setup',  'feedonly',                ''  );

   end;
end;

procedure Init_SettingsDef_Pulls;
begin
   SettingsDef_Pulls := TSettingsDef.Create;

   with SettingsDef_Pulls do begin      

      Add( psArtNoMin,      'Ranges', {Server + } '.Min',           '0' );
      Add( psArtNoMax,      'Ranges', {Server + } '.Max',           '0' );
      Add( psFirstPullDone, 'Ranges', {Server + } '.FirstPullDone', '0' );
      Add( psFeederLast,    'Ranges', {Server + } '.LastFeed',      '0' );

   end;
end;

procedure Init_SettingsDef_Accounts;
begin
   SettingsDef_Accounts := TSettingsDef.Create;

   with SettingsDef_Accounts do begin

      Add( apUsername,        '', 'Username',          '' );
      Add( apPassword,        '', '!Password',         '' );
      Add( apFullname,        '', 'Fullname',          '' );
      Add( apUniqueID,        '', 'ID',                '' );
      Add( apIpRestriction,   '', 'IpRestriction',     '' );
      Add( apNewsPost,        '', 'NewsPost',          '' );
      Add( apNewsRead,        '', 'NewsRead',          '' );
      Add( apNewsNewNews,     '', 'NewsNewNews',       '' );
      Add( apNewsAutoSub,     '', 'NewsAutoSubscribe', '' );
      Add( apNewsXHSearch,    '', 'NewsXHSearch',      '' );
      Add( apNewsPeer,        '', 'NewsPeer',          '' );
      Add( apMailbox,         '', 'Mailbox',           '' );
      Add( apMailSend,        '', 'MailSend',          '' );
      Add( apMailAddress,     '', 'MailAddr',          '' );
      Add( apMailFwdAccount,  '', 'MailFwdAccount',    '' );
      Add( apMailFwdAddress,  '', 'MailFwdAddress',    '' );
      Add( apMailFwdMailList, '', 'MailFwdMailList',   '' );
      Add( apMailFwdKeepCopy, '', 'MailFwdKeepCopy',   '' );
      Add( apRemoteControl,   '', 'RemoteControl',     '' );

   end;
end;

// ----------------------------------------------------------------------------

initialization
   Init_SecurityAttributes;
   Init_SettingsDef_App;
   Init_SettingsDef_Hamster;
   Init_SettingsDef_Server;
   Init_SettingsDef_Groups;
   Init_SettingsDef_Pulls;
   Init_SettingsDef_Accounts;

finalization
   if Assigned( SettingsDef_Accounts ) then SettingsDef_Accounts.Free;
   if Assigned( SettingsDef_Pulls    ) then SettingsDef_Pulls.Free;
   if Assigned( SettingsDef_Groups   ) then SettingsDef_Groups.Free;
   if Assigned( SettingsDef_Server   ) then SettingsDef_Server.Free;
   if Assigned( SettingsDef_Hamster  ) then SettingsDef_Hamster.Free;
   if Assigned( SettingsDef_App      ) then SettingsDef_App.Free;
   if Assigned(lpSecurityDescriptorEveryone) then begin
      LocalFree( HLOCAL(lpSecurityDescriptorEveryone) );
   end;

end.
