// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fMain;

interface

{$INCLUDE Compiler.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dDialogs, StdCtrls, cClientReco, ComCtrls, ExtCtrls, ToolWin, ImgList,
  ActnList, Menus, IniFiles, Clipbrd, ShellApi, uGlobal, Buttons, cLiveQueue,
  cLiveConnector, uConst, uType;

const
  WM_TRAYNOTIFY = WM_USER + 2;
  WM_INTERNAL   = WM_USER + 4;

type
  TfrmMain = class(TForm)
    sbMain: TStatusBar;
    pgMain: TPageControl;
    ilMain: TImageList;
    alMain: TActionList;
    acConnect: TAction;
    acDisconnect: TAction;
    tsServer: TTabSheet;
    tsScripts: TTabSheet;
    acServerRefresh: TAction;
    acNntpStart: TAction;
    acNntpStop: TAction;
    acNntpRestart: TAction;
    acPop3Start: TAction;
    acPop3Stop: TAction;
    acPop3Restart: TAction;
    acSmtpStart: TAction;
    acSmtpStop: TAction;
    acSmtpRestart: TAction;
    acRecoStop: TAction;
    acRecoRestart: TAction;
    tbServer: TToolBar;
    ToolButton7: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton16: TToolButton;
    ToolButton17: TToolButton;
    ToolButton18: TToolButton;
    ToolButton19: TToolButton;
    ToolButton20: TToolButton;
    ToolButton21: TToolButton;
    ToolButton22: TToolButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    MainMenu1: TMainMenu;
    mnuFile: TMenuItem;
    mnuFileExit: TMenuItem;
    mnuSrv: TMenuItem;
    StartNNTPserver1: TMenuItem;
    StopNNTPserver1: TMenuItem;
    RestartNNTPserver1: TMenuItem;
    StartPOP3server1: TMenuItem;
    StopPOP3server1: TMenuItem;
    RestartPOP3server1: TMenuItem;
    StartSMTPserver1: TMenuItem;
    StopSMTPserver1: TMenuItem;
    RestartSMTPserver1: TMenuItem;
    StopRCserver1: TMenuItem;
    RestartRCserver1: TMenuItem;
    N4: TMenuItem;
    Refreshserverinfo1: TMenuItem;
    acExit: TAction;
    N5: TMenuItem;
    Connect1: TMenuItem;
    Disconnect1: TMenuItem;
    acRefreshCurrentPage: TAction;
    N6: TMenuItem;
    Refreshcurrentpage1: TMenuItem;
    acReconnect: TAction;
    tbScripts: TToolBar;
    acScriptRefresh: TAction;
    Scripts1: TMenuItem;
    Refreshlogfile2: TMenuItem;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    acScriptStop: TAction;
    tvScriptRemote: TTreeView;
    acScriptStart: TAction;
    acScriptEdit: TAction;
    acScriptNew: TAction;
    acScriptDel: TAction;
    ToolButton26: TToolButton;
    ToolButton27: TToolButton;
    ToolButton28: TToolButton;
    ToolButton29: TToolButton;
    ToolButton30: TToolButton;
    N9: TMenuItem;
    N10: TMenuItem;
    Startscript1: TMenuItem;
    Downloadscript1: TMenuItem;
    Uploadscript1: TMenuItem;
    Deletescript1: TMenuItem;
    acSettings: TAction;
    N11: TMenuItem;
    Settings1: TMenuItem;
    acNewsRefresh: TAction;
    acNewsGroupAdd: TAction;
    acNewsGroupDel: TAction;
    acNewsPullAdd: TAction;
    acNewsPullDel: TAction;
    Newsgroups1: TMenuItem;
    Addnewsgroup1: TMenuItem;
    Deleteselectednewsgroup1: TMenuItem;
    N12: TMenuItem;
    Addnewspull1: TMenuItem;
    Deleteselectednewspull1: TMenuItem;
    N13: TMenuItem;
    RefreshNewsLists1: TMenuItem;
    tsNewsgroups: TTabSheet;
    tbNewsgroups: TToolBar;
    ToolButton32: TToolButton;
    ToolButton33: TToolButton;
    ToolButton34: TToolButton;
    ToolButton36: TToolButton;
    ToolButton38: TToolButton;
    ToolButton39: TToolButton;
    ToolButton40: TToolButton;
    lbNews: TListBox;
    tsLog: TTabSheet;
    lbLog: TListBox;
    acServerStopAllTasks: TAction;
    NNTP1: TMenuItem;
    POP31: TMenuItem;
    SMTPServer1: TMenuItem;
    RC1: TMenuItem;
    ToolButton1: TToolButton;
    TEST1: TMenuItem;
    acConfApp: TAction;
    acConfHam: TAction;
    ApplicationSettings1: TMenuItem;
    HamsterSettings1: TMenuItem;
    acConfSrv: TAction;
    RemoteServers1: TMenuItem;
    acConfGrp: TAction;
    Newsgroups2: TMenuItem;
    acConfPwd: TAction;
    Passwords1: TMenuItem;
    acConfAcc: TAction;
    Accounts1: TMenuItem;
    Files1: TMenuItem;
    acConfFileIPAccess: TAction;
    acConfFileScores: TAction;
    acConfFileMailFilt: TAction;
    acConfFileKillsLog: TAction;
    IPAccess1: TMenuItem;
    NewsScoreFile1: TMenuItem;
    NewsKillsLog1: TMenuItem;
    MailFilters1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    lbClients: TListBox;
    tsTasks: TTabSheet;
    lbTasks: TListBox;
    acStartTasks: TAction;
    acConfFileRCProfiles: TAction;
    acConfFileHscActions: TAction;
    RCServerProfiles1: TMenuItem;
    ScriptActions1: TMenuItem;
    N14: TMenuItem;
    N15: TMenuItem;
    PopupLog: TPopupMenu;
    mnuLogAutoScroll: TMenuItem;
    N16: TMenuItem;
    tsLogEW: TTabSheet;
    lbLogEW: TListBox;
    PopupTasks: TPopupMenu;
    mnuTasksStopSel: TMenuItem;
    mnuTasksStopScripts: TMenuItem;
    mnuTasksStopAll: TMenuItem;
    imgTray0: TImage;
    imgTray1: TImage;
    PopupTray: TPopupMenu;
    acShow: TAction;
    Show1: TMenuItem;
    Exit1: TMenuItem;
    acStopTaskSel: TAction;
    StartTasks2: TMenuItem;
    N18: TMenuItem;
    tbTasks: TToolBar;
    ToolButton35: TToolButton;
    ToolButton37: TToolButton;
    ToolButton41: TToolButton;
    ToolButton42: TToolButton;
    ToolButton43: TToolButton;
    ToolButton23: TToolButton;
    N17: TMenuItem;
    Tasks1: TMenuItem;
    StartTasks3: TMenuItem;
    N19: TMenuItem;
    StopSelectedTask1: TMenuItem;
    N20: TMenuItem;
    StopAllScripts2: TMenuItem;
    StopAllTasks2: TMenuItem;
    PopupLogEW: TPopupMenu;
    mnuLogEWClear: TMenuItem;
    tbMain: TToolBar;
    ToolButton6: TToolButton;
    ToolButton8: TToolButton;
    ToolButton24: TToolButton;
    tbtnTasks: TToolButton;
    ToolButton5: TToolButton;
    tbtnScripts: TToolButton;
    PopupScriptStart: TPopupMenu;
    acScriptStartList: TAction;
    acHelpContent: TAction;
    acHelpAbout: TAction;
    acHelpSysInfo: TAction;
    N7: TMenuItem;
    Content1: TMenuItem;
    SystemInfo1: TMenuItem;
    About1: TMenuItem;
    N8: TMenuItem;
    Contents1: TMenuItem;
    mnuLogViewAll: TMenuItem;
    mnuLogViewThread: TMenuItem;
    N21: TMenuItem;
    mnuLogEWViewThread: TMenuItem;
    N22: TMenuItem;
    mnuLogViewTask: TMenuItem;
    PopupServer: TPopupMenu;
    mnuLogViewClient: TMenuItem;
    acConfFileSmtpRouter: TAction;
    MailDeliveryMX1: TMenuItem;
    N23: TMenuItem;
    acConfML: TAction;
    MailLists1: TMenuItem;
    acScriptStartPar: TAction;
    ToolButton25: TToolButton;
    Startscriptwithparameters1: TMenuItem;
    acConfMailTrap: TAction;
    MailTrap1: TMenuItem;
    acReports: TAction;
    ToolButton31: TToolButton;
    ToolButton44: TToolButton;
    Reports1: TMenuItem;
    PopupTasksStart: TPopupMenu;
    acTasksRefresh: TAction;
    acUserTasksSetup: TAction;
    Setup1: TMenuItem;
    acActionsSetup: TAction;
    acSchedulerSetup: TAction;
    SetupActionTasks1: TMenuItem;
    SetupScheduledTasks1: TMenuItem;
    mnuLogEWClearHide: TMenuItem;
    acService: TAction;
    Service1: TMenuItem;
    N24: TMenuItem;
    mnuLogEWShowHistory: TMenuItem;
    N25: TMenuItem;
    MnuLogShowHistory: TMenuItem;
    N26: TMenuItem;
    mnuLogFind: TMenuItem;
    N27: TMenuItem;
    mnuLogEWFind: TMenuItem;
    mnuLogFindThis: TMenuItem;
    mnuLogEWFindThis: TMenuItem;
    procedure acConnectExecute(Sender: TObject);
    procedure acDisconnectExecute(Sender: TObject);
    procedure acServerStateChangeExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure acServerRefreshExecute(Sender: TObject);
    procedure acExitExecute(Sender: TObject);
    procedure acRefreshCurrentPageExecute(Sender: TObject);
    procedure acReconnectExecute(Sender: TObject);
    procedure acScriptRefreshExecute(Sender: TObject);
    procedure acScriptStopExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure acScriptStartExecute(Sender: TObject);
    procedure acScriptDelExecute(Sender: TObject);
    procedure acScriptEditExecute(Sender: TObject);
    procedure acScriptNewExecute(Sender: TObject);
    procedure tvScriptRemoteChange(Sender: TObject; Node: TTreeNode);
    procedure acSettingsExecute(Sender: TObject);
    procedure acNewsRefreshExecute(Sender: TObject);
    procedure acNewsGroupAddExecute(Sender: TObject);
    procedure acNewsGroupDelExecute(Sender: TObject);
    procedure acNewsPullAddExecute(Sender: TObject);
    procedure acNewsPullDelExecute(Sender: TObject);
    procedure lbNewsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lbNewsClick(Sender: TObject);
    procedure lbLogDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure acServerStopAllTasksExecute(Sender: TObject);
    procedure acConfAppExecute(Sender: TObject);
    procedure acConfHamExecute(Sender: TObject);
    procedure acConfSrvExecute(Sender: TObject);
    procedure acConfGrpExecute(Sender: TObject);
    procedure acConfPwdExecute(Sender: TObject);
    procedure acConfAccExecute(Sender: TObject);
    procedure acConfFileIPAccessExecute(Sender: TObject);
    procedure acConfFileScoresExecute(Sender: TObject);
    procedure acConfFileMailFiltExecute(Sender: TObject);
    procedure acConfFileKillsLogExecute(Sender: TObject);
    procedure lbTasksDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lbClientsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure acStartTasksExecute(Sender: TObject);
    procedure acConfFileRCProfilesExecute(Sender: TObject);
    procedure acConfFileHscActionsExecute(Sender: TObject);
    procedure mnuLogAutoScrollClick(Sender: TObject);
    procedure acShowExecute(Sender: TObject);
    procedure acStopTaskSelExecute(Sender: TObject);
    procedure lbTasksClick(Sender: TObject);
    procedure mnuLogEWClearClick(Sender: TObject);
    procedure acScriptStartListExecute(Sender: TObject);
    procedure mnuScriptStartListClick(Sender: TObject);
    procedure mnuTasksStartListClick(Sender: TObject);
    procedure acHelpContentExecute(Sender: TObject);
    procedure acHelpAboutExecute(Sender: TObject);
    procedure acHelpSysInfoExecute(Sender: TObject);
    procedure mnuLogViewAllClick(Sender: TObject);
    procedure mnuLogViewThreadClick(Sender: TObject);
    procedure lbLogDblClick(Sender: TObject);
    procedure acConfFileSmtpRouterExecute(Sender: TObject);
    procedure acConfMLExecute(Sender: TObject);
    procedure acConfMailTrapExecute(Sender: TObject);
    procedure acReportsExecute(Sender: TObject);
    procedure acTasksRefreshExecute(Sender: TObject);
    procedure acUserTasksSetupExecute(Sender: TObject);
    procedure acActionsSetupExecute(Sender: TObject);
    procedure acSchedulerSetupExecute(Sender: TObject);
    procedure mnuLogEWClearHideClick(Sender: TObject);
    procedure lbLogMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure acServiceExecute(Sender: TObject);
    procedure mnuLogEWShowHistoryClick(Sender: TObject);
    procedure mnuLogFindClick(Sender: TObject);
    procedure mnuLogFindThisClick(Sender: TObject);
  private
    { Private-Deklarationen }
    ServerRunning: array[TServerTypes] of Boolean;
    LbHorizExtent, LbHorizExtentTasks, LbHorizExtentClients: Integer;
    TrayIcon     : TNotifyIconData;

    procedure WM_GUI_CheckConnection( var Message: TMessage ); message WM_GUI_CHECKCONNECTION;

    function  RCIsConnected: Boolean;
    function  CheckConnection: Boolean;
    procedure Status( const StatusMsg: String );
    procedure ShowCounters( const CounterString: String );
    function  FullScriptFilePath( TN: TTreeNode ): String;
    function  GetVersions: String;

    procedure WMTrayNotify(var Message: TMessage); message WM_TRAYNOTIFY;
    procedure WMInternal  (var Message: TMessage); message WM_INTERNAL;
    procedure WMSysCommand(var Message: TWMSysCommand); message WM_SYSCOMMAND;
    procedure AppOnMinimize( Sender: TObject );
    procedure RefreshFonts();

  public
    { Public-Deklarationen }
    procedure LiveInfoHandler;
    procedure GuiLog( const s: String );
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

uses uTools, cLogFile, fConnect, fSettings, fGroupPull, fConfApp, fConfHam,
     fConfSrv, fConfGrp, fConfPwd, fConfAcc, fConfFile, dInput, cLiveMsg,
     {$IFDEF USE_HTMLHELPKIT} hh, hh_funcs, {$ENDIF} // see Compiler.inc
     fStartTasks, fConfML, fConfMailTrap, fReports, fUserTasks, fActions,
     fScheduler, Math, uWinSvc, fService, fLogFind;

const
   NT_ROOT = Pointer(0);
   NT_PATH = Pointer(1);
   NT_FILE = Pointer(2);

   wmInternalReconnect = 1;
   wmInternalConnect   = 2;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
   MainWindowHWnd := Self.Handle;

   {$IFDEF USE_HTMLHELPKIT}
   if _hhInstalled then begin
      HtmlHelpHook := THookHelpSystem.Create( ExtractFileDir(
                              ParamStr( 0 ) ) + '\hamster.chm', '', htHHAPI );
   end;
   {$ENDIF}

   AppIni := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );

   FillChar( ServerRunning, sizeof(ServerRunning), 0 );

   LoadWindowState( Self, 'Main' );
   pgMain.ActivePageIndex := 0;
   Caption := Caption + ' ' + GetMyVersionInfo;

   Winsock2Installed;
   acService.Enabled := IsWinSvcAvailable;

   FontLogfile.Assign( lbLog.Font );
   LoadLocalSettings;
   RefreshFonts();

   LbHorizExtent        := 0;
   LbHorizExtentTasks   := 0;
   LbHorizExtentClients := 0;
   SendMessage( lbLog.Handle,     LB_SETHORIZONTALEXTENT, LbHorizExtent, 0 );
   SendMessage( lbLogEW.Handle,   LB_SETHORIZONTALEXTENT, LbHorizExtent, 0 );
   SendMessage( lbTasks.Handle,   LB_SETHORIZONTALEXTENT, LbHorizExtentTasks, 0 );
   SendMessage( lbClients.Handle, LB_SETHORIZONTALEXTENT, LbHorizExtentClients, 0 );
   tsLogEW.TabVisible := False;

   LiveConnector  := TLiveConnector.Create( LiveInfoHandler );

   with TrayIcon do begin
      cbSize := sizeof(TrayIcon);
      Wnd    := Handle;
      uID    := 42;
      uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
      uCallbackMessage := WM_TRAYNOTIFY;
      hIcon  := imgTray0.Picture.Icon.Handle;
      szTip  := '';
   end;
   Shell_NotifyIcon( NIM_ADD, @TrayIcon );

   Application.OnMinimize := AppOnMinimize;

   CheckConnection;
end;

procedure TfrmMain.FormActivate(Sender: TObject);
var  b: Boolean;
     s: String;
     i: Integer;
begin
   b := True;
   i := 1;
   while i <= ParamCount do begin
      s := UpperCase( ParamStr(i) );
      if          s = '-NOLOGIN' then begin
         b := False;
      end else if s = '-SERVER'  then begin
         RCServer := ParamStr(i+1);
         inc( i );
      end else if s = '-PORT'    then begin
         RCPort := ParamStr(i+1);
         inc( i );
      end else if s = '-USER'    then begin
         RCUser := ParamStr(i+1);
         inc( i );
      end else if s = '-PASS'    then begin
         RCPass := ParamStr(i+1);
         inc( i );
      end;
      inc( i );
   end;

   if b then begin
      if (RCServer<>'') and (RCPort<>'') and (RCUser<>'') and (RCPass<>'') then begin
         // acReconnect.Execute;
         PostMessage( Handle, WM_INTERNAL, wmInternalReconnect, 0 );
      end else begin
         // acConnect.Execute;
         PostMessage( Handle, WM_INTERNAL, wmInternalConnect, 0 );
      end;
   end;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
   {$IFDEF USE_HTMLHELPKIT}
   try
      if Assigned( HtmlHelpHook ) then HtmlHelpHook.Free;
      HHCloseAll;
   except end;
   {$ENDIF}

   try SaveWindowState( Self, 'Main' ); except end;
   if TrayIcon.hIcon <> 0 then Shell_NotifyIcon( NIM_DELETE, @TrayIcon );

   // terminate live connector [and its connection]   
   try LiveConnector.Free except end;
   LiveConnector := nil;   
end;

procedure TfrmMain.acShowExecute(Sender: TObject);
begin
   Application.Restore;
   Visible := True;
   Application.BringToFront;
end;

procedure TfrmMain.AppOnMinimize( Sender: TObject ); 
begin
   Visible := False;
   ShowWindow( Application.Handle, SW_HIDE );
end;

procedure TfrmMain.WMSysCommand(var Message: TWMSysCommand);
begin
   if ( (Message.CmdType and $FFF0) = SC_CLOSE ) and MinimizeOnClose then begin
      Message.Result := 0;
      Application.Minimize;
   end else begin
      inherited;
   end;
end;

procedure TfrmMain.WMInternal( var Message: TMessage );
begin
   case Message.WParam of
      wmInternalReconnect: acReconnect.Execute;
      wmInternalConnect  : acConnect.Execute;
   end;
end;

procedure TfrmMain.WMTrayNotify( var Message: TMessage );
var  P : TPoint;
begin
   GetCursorPos( P );

   case Message.LParam of

      WM_LBUTTONDBLCLK: begin
         acShow.Execute;
      end;

      WM_RBUTTONUP: begin
         SetForegroundWindow( Handle );
         PopupTray.Popup( P.x, P.y );
         PostMessage( Handle, WM_NULL, 0, 0 );
      end;

   end;
end;

procedure TfrmMain.WM_GUI_CheckConnection( var Message: TMessage );
begin
   try CheckConnection except end;
end;

procedure TfrmMain.GuiLog( const s: String );
begin
   if not Assigned( LiveConnector ) then exit;
   try
      LiveConnector.QueueInf.Add( TLiveMsg.Create( LMXXX_HC_GUI_LOG, s ) )
   except end;
end;

procedure TfrmMain.Status( const StatusMsg: String );
begin
   sbMain.Panels[1].Text := StatusMsg;
   sbMain.Refresh;
end;

function TfrmMain.RCIsConnected: Boolean;
begin
   Result := LiveConnector.RCLiveIsConnected;
end;

function TfrmMain.CheckConnection: Boolean;
var  i: Integer;
begin
   Result := RCIsConnected;

   // adjust "color" of tray-icon
   if Result then TrayIcon.hIcon := imgTray1.Picture.Icon.Handle
             else TrayIcon.hIcon := imgTray0.Picture.Icon.Handle;
   Shell_NotifyIcon( NIM_MODIFY, @TrayIcon );

   if acConnect.Enabled = Result then begin
      if Result then sbMain.Panels[0].Text := 'Connected'
                else sbMain.Panels[0].Text := '';
      acConnect   .Enabled := not Result;
      acDisconnect.Enabled := Result;
   end;

   {if Timer1.Enabled <> Result then begin
      if Result then Timer1Timer( nil );
      Timer1.Enabled := Result;
   end;}

   for i:=0 to alMain.ActionCount-1 do begin
      with TAction( alMain.Actions[i] ) do begin
         if Tag = 1 then
            // only if offline
            Enabled := not Result
         else if Tag >= 2 then begin
            // only if online
            case Tag of

               Cmd_NntpStart:
                  Enabled := Result and not ServerRunning[ stNNTP ];
               Cmd_NntpStop, Cmd_NntpRestart:
                  Enabled := Result and     ServerRunning[ stNNTP ];
               Cmd_Pop3Start:
                  Enabled := Result and not ServerRunning[ stPOP3 ];
               Cmd_Pop3Stop, Cmd_Pop3Restart:
                  Enabled := Result and     ServerRunning[ stPOP3 ];
               Cmd_SmtpStart:
                  Enabled := Result and not ServerRunning[ stSMTP ];
               Cmd_SmtpStop, Cmd_SmtpRestart:
                  Enabled := Result and     ServerRunning[ stSMTP ];
               Cmd_RecoStop, Cmd_RecoRestart:
                  Enabled := Result and     ServerRunning[ stRECO ];

               else   Enabled := Result;

            end;
         end;
      end;
   end;

   tvScriptRemoteChange( tvScriptRemote, nil );
   lbNewsClick( lbNews );
end;

procedure TfrmMain.acReconnectExecute(Sender: TObject);
var  Reply: TLiveMsg;
     ErrMsg: String;

   procedure ShowInitialLogfile;
   const maxLen = 1024;
   var  ID, i, j: Integer;
        TX, s: String;
   begin
      lbLog.Items.BeginUpdate;
      lbLogEW.Items.BeginUpdate;
      try

         lbLog.Clear;
         s := Reply.MsgData;

         repeat
            i := Pos( #13#10, s );
            if i = 0 then break;

            TX := copy( s, 1, i-1 );
            System.Delete( s, 1, i+1 );
            if i > maxLen then begin
               SetLength( TX, maxLen-1 );
               TX := TX + '';
            end;

            ID := LOGID_INFO;
            j := Pos( '{', TX );
            if j > 4 then begin
               ID := LogMarkerToId( copy( TX, j-4, 3 ) );
               if ID = LOGID_UNKNOWN then ID := LOGID_INFO;
               System.Delete( TX, j-4, 3+1 );
            end;

            if (ID=LOGID_ERROR) or (ID=LOGID_WARN) or
               (ID=LOGID_SYSTEM) or (ID=LOGID_INFO) then begin
               lbLog.Items.AddObject( TX, Pointer(ID) );
               if (ID=LOGID_ERROR) or (ID=LOGID_WARN) then begin
                  lbLogEW.Items.AddObject( TX, Pointer(ID) );
               end;
            end;
         until False;

      finally
         if lbLog.Items.Count > 0 then lbLog.ItemIndex := lbLog.Items.Count-1;
         lbLogEW.Items.EndUpdate;
         lbLog.Items.EndUpdate;
         tsLogEW.TabVisible := ( lbLogEW.Items.Count > 0 );
      end;
   end;

begin
   Status( 'Connecting ...' );
   try
      try
         if LiveConnector.RCLiveConnect(
               RCServer, RCPort, RCUser, RCPass, ErrMsg
            ) then begin

            // save successful connection parameters
            SaveLocalSettings;

            // init logfile view
            Reply := LiveConnector.RCLiveRequest(
                        TLiveMsg.Create( LMREQ_LOGFILE_LIST,
                                         inttostr(InitialLogSize) )
                     );
            if Assigned( Reply ) then try
               ShowInitialLogfile;
            finally Reply.Free end;

            // init counters view
            Reply := LiveConnector.RCLiveRequest(
                        TLiveMsg.Create( LMREQ_COUNTERS_LIST, '' )
                     );
            if Assigned( Reply ) then try
               ShowCounters( Reply.MsgData );
            finally Reply.Free end;

            // init server states
            acServerRefreshExecute( nil );

            // init user tasks list
            acTasksRefreshExecute( nil );

            // init scripts list
            acScriptRefreshExecute( nil );
         end;

      except
         on E: Exception do ErrMsg := E.Message;
      end;

      if (not RCIsConnected) and (ErrMsg<>'') then begin
         HMessageDlg( 'Connection failed!'#13#13 + ErrMsg,
                      Application.Title, mtWarning, [mbOK] );
         Status( ErrMsg );
      end;

   finally
      CheckConnection;
   end;
end;

procedure TfrmMain.acConnectExecute(Sender: TObject);
var  Ok: Boolean;
begin
   with TfrmConnect.Create( nil ) do try
      Ok := ( ShowModal = mrOK );
   finally
      Free;
   end;
   if not Ok then exit;

   acReconnect.Execute;
end;

procedure TfrmMain.acDisconnectExecute(Sender: TObject);
begin
   Status( 'Disconnecting ...' );
   LiveConnector.RCLiveDisconnect;
   Status( '' );
   CheckConnection;
end;

procedure TfrmMain.acServerRefreshExecute(Sender: TObject);
var  Reply: TLiveMsg;
     SL: TStringList;
begin
   if not CheckConnection then exit;

   try
      // refresh server states 
      Reply := LiveConnector.RCLiveRequest( TLiveMsg.Create(
                  LMREQ_LOCALSERVER_CONTROL, '*' + CRLF + inttostr(ord(scIsActive))
               ) );
      if Assigned(Reply) then try
         if Reply.MsgType = LMREP_OK then begin
            SL := TStringList.Create;
            try
               SL.Text := Reply.MsgData;
               while SL.Count < 4 do SL.Add( '0' );
               ServerRunning[stNNTP] := ( SL[0] = '1' );
               ServerRunning[stPOP3] := ( SL[1] = '1' );
               ServerRunning[stSMTP] := ( SL[2] = '1' );
               ServerRunning[stRECO] := ( SL[3] = '1' );
            finally SL.Free end;
         end;
      finally Reply.Free end;

   finally CheckConnection end;
end;

procedure TfrmMain.acServerStateChangeExecute(Sender: TObject);
var  Tag: Integer;
     st : TServerTypes;
     sc : TServerControls;
begin
   if not CheckConnection then exit;

   try
      Tag := ( Sender as TAction ).Tag;

      if      Tag in [Cmd_NntpStart,Cmd_NntpStop,Cmd_NntpRestart] then st := stNNTP
      else if Tag in [Cmd_Pop3Start,Cmd_Pop3Stop,Cmd_Pop3Restart] then st := stPOP3
      else if Tag in [Cmd_SmtpStart,Cmd_SmtpStop,Cmd_SmtpRestart] then st := stSMTP
      else if Tag in [              Cmd_RecoStop,Cmd_RecoRestart] then st := stRECO
      else exit;

      if      Tag in [Cmd_NntpStart,  Cmd_Pop3Start,  Cmd_SmtpStart                  ] then sc := scSTART
      else if Tag in [Cmd_NntpStop,   Cmd_Pop3Stop,   Cmd_SmtpStop,   Cmd_RecoStop   ] then sc := scSTOP
      else if Tag in [Cmd_NntpRestart,Cmd_Pop3Restart,Cmd_SmtpRestart,Cmd_RecoRestart] then sc := scRESTART
      else exit;

      if (st=stRECO) and (sc=scSTOP) then begin
         if HMessageDlg(
            'After stopping the Remote Control server, you can''t ' +
            'connect to it again.'#13#10 +
            'Do you really want to stop the RC server now?',
            Application.Title, mtConfirmation, [mbYes,mbNo] ) <> mrYes then exit;
      end;

      if (st=stRECO) and (sc=scRESTART) then begin
         HMessageDlg(
            'Note:'#13#10 +
            'Connection will be lost now by restarting RC server.'#13#10 +
            'You can connect to it again after a few seconds.',
            Application.Title, mtInformation, [mbOK] );
      end;

      try
         if LiveConnector.RCLiveRequestOK(
               TLiveMsg.Create( LMREQ_LOCALSERVER_CONTROL,
                                inttostr(ord(st)) + CRLF + inttostr(ord(sc)) )
            ) then begin
            if sc = scSTOP then ServerRunning[ st ] := False
                           else ServerRunning[ st ] := True;
         end;
      except
         on E: Exception do GuiLog( 'Request Exception: ' + E.Message );
      end;

      if (st=stRECO) and (sc<>scSTART) then begin
         // if RC server was stopped/restarted, connection will be lost
         acDisconnect.Execute;
         Status( 'Disconnected' );
      end;

   finally
      CheckConnection;
   end;
end;

procedure TfrmMain.acExitExecute(Sender: TObject);
begin
   Close;
end;

procedure TfrmMain.acRefreshCurrentPageExecute(Sender: TObject);
begin
   if      pgMain.ActivePage = tsServer     then acServerRefresh.Execute
   else if pgMain.ActivePage = tsScripts    then acScriptRefresh.Execute
   else if pgMain.ActivePage = tsTasks      then acTasksRefresh.Execute
   else if pgMain.ActivePage = tsNewsgroups then acNewsRefresh.Execute;
end;

procedure TfrmMain.acTasksRefreshExecute(Sender: TObject);
var  Reply: TLiveMsg;
     SL: TStringList;
     MI: TMenuItem;
     i: Integer;
begin
   SL := TStringList.Create;
   try
      // User Tasks
      Reply := LiveConnector.RCLiveRequest(
         TLiveMsg.Create( LMREQ_USERTASKS_LIST, '' )
      );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then SL.Text := Reply.MsgData;
      finally FreeAndNil(Reply) end;

      PopupTasksStart.Items.Clear;
      for i := 0 to SL.Count - 1 do begin
         MI := TMenuItem.Create( Self );
         MI.Caption := SL[i];
         MI.Hint    := SL[i];
         MI.OnClick := mnuTasksStartListClick;
         MI.ImageIndex := 49;
         PopupTasksStart.Items.Add( MI );
      end;

   finally SL.Free end;
end;

procedure TfrmMain.acScriptRefreshExecute(Sender: TObject);

   procedure ShowFiles( TreeView  : TTreeView;
                        ScriptList: TStringList;
                        FullMode  : Boolean );
   var  TNS, TNM, Parent, Node: TTreeNode;
        MI: TMenuItem;
        i, j: Integer;
        s, h, sd, st, ss, sn: String;
   begin
      PopupScriptStart.Items.Clear;
      TreeView.Items.BeginUpdate;
      try
         TreeView.Items.Clear;
         TNS := TreeView.Items.AddObject( nil, 'SCRIPTS', NT_ROOT );
         TNS.ImageIndex    := 25;
         TNS.SelectedIndex := 25;
         TNM := TreeView.Items.AddObject( nil, 'MODULES', NT_ROOT );
         TNM.ImageIndex := 25;
         TNM.SelectedIndex := 25;

         for i:=0 to ScriptList.Count-1 do begin
            s  := ScriptList[i];
            if FullMode then begin
               sd := copy( s,  1, 10 ); // date
               st := copy( s, 12,  8 ); // time
               ss := copy( s, 21, MaxInt ); // size #9 [path\]name
               j := Pos( #9, ss );
               sn := copy( ss, j+1, MaxInt );
               ss := copy( ss, 1, j-1 );
               s := sn + ' (' + sd + ' ' + st + ', ' + ss + ' Byte)';
            end;
            if Pos( '\', s ) > 0 then s := '\' + s;
            ScriptList[i] := s;
         end;

         ScriptList.Sort;

         for i:=0 to ScriptList.Count-1 do begin
            s := ScriptList[i];
            j := Pos( '.hsc', s );
            if ( j > 0 ) and ( Pos( '\', s ) = 0 ) then begin
               MI := TMenuItem.Create( Self );
               MI.Caption := copy( s, 1, j+3 );
               MI.Hint    := copy( s, 1, j+3 );
               MI.OnClick := mnuScriptStartListClick;
               MI.ImageIndex := 20;
               PopupScriptStart.Items.Add( MI );
            end;
         end;

         for i:=0 to ScriptList.Count-1 do begin
            sn := ScriptList[i];
            ss := '';
            j  := Pos( ' ', sn );
            if j > 0 then begin
               ss := copy( sn, j, MaxInt );
               sn := copy( sn, 1, j-1 )
            end;

            if Pos( '.hsm', sn ) > 0 then Parent := TNM
                                     else Parent := TNS;

            j := Pos( '\', sn );
            while j > 0 do begin
               h := copy( sn, 1, j-1 );
               System.Delete( sn, 1, j );

               for j := 0 to Parent.Count-1 do begin
                  if Parent.Item[j].Text = h then begin
                     Parent := Parent.Item[j];
                     h := '';
                     break;
                  end;

               end;
               if h <> '' then begin
                  Parent := TreeView.Items.AddChildObject( Parent, h, NT_PATH );
                  Parent.ImageIndex    := 26;
                  Parent.SelectedIndex := 26;
               end;

               j := Pos( '\', sn );
            end;

            Node := TreeView.Items.AddChildObject( Parent, sn + ss, NT_FILE );
            Node.ImageIndex    := 27;
            Node.SelectedIndex := 27;
         end;

         if TNM.Count = 0 then TreeView.Items.Delete( TNM );
         TNS.Expand( False );
         TNS.MakeVisible;
         
      finally
         TreeView.Items.EndUpdate;
      end;
   end;

var  SL: TStringList;
     Reply: TLiveMsg;
begin
   SL := TStringList.Create;
   try
      with tvScriptRemote.Items do begin BeginUpdate; Clear; EndUpdate end;

      // get and show remote script files
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_SCRIPT_DIR, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            SL.Text := Reply.MsgData;
            ShowFiles( tvScriptRemote, SL, True );
         end;
      finally Reply.Free end;

   finally
      SL.Free;
      CheckConnection;
   end;
end;

procedure TfrmMain.acScriptStopExecute(Sender: TObject);
begin
   try
      LiveConnector.RCLiveRequestOK(
         TLiveMsg.Create( LMREQ_TASKS_STOPALL, inttostr(ord(attScript)) )
      );
   finally
      CheckConnection;
   end;
end;

function TfrmMain.FullScriptFilePath( TN: TTreeNode ): String;
var  i: Integer;
     s: String;
begin
   if TN.Data = NT_FILE then begin
      Result := '';
      s := TN.Text;
      i := Pos( '.hsc', LowerCase(s) );
      if i = 0 then i := Pos( '.hsm', LowerCase(s) );
      if i = 0 then begin
         i := Pos( ' ', s );
         if i = 0 then Result := s else Result := copy( s, 1, i-1 );
      end else begin
         Result := copy( s, 1, i+3 );
      end;
   end else if TN.Data = NT_PATH then begin
      Result := TN.Text + '\';
   end else begin
      Result := '';
      exit;
   end;

   repeat
      TN := TN.Parent;
      if TN.Data = NT_ROOT then break;
      Result := TN.Text + '\' + Result;
   until False;
end;

procedure TfrmMain.acScriptStartExecute(Sender: TObject);
var  TN: TTreeNode;
     scriptPars, scriptFile, paramTitle, s, metaCommand: String;
     SL: TStringList;
     reply: TLiveMsg;
     scriptLines, metaParts: TStringList;
     paramCount, i, k: Integer;
     paramPrompt, paramDefault: array of string;
begin
   TN := tvScriptRemote.Selected;
   if not Assigned( TN ) then exit;
   if TN.Data <> NT_FILE then exit;

   scriptFile   := FullScriptFilePath( TN );
   scriptPars   := '';
   scriptLines  := TStringList.Create;
   metaParts    := TStringList.Create;
   paramTitle   := 'Start Script';
   paramCount   := 0;
   paramPrompt  := nil;
   paramDefault := nil;

   try

      // preload script text
      try
         reply := LiveConnector.RCLiveRequest(
            TLiveMsg.Create( LMREQ_SCRIPT_GET, DQuoteStr( scriptFile ) )
         );
         if Assigned( reply ) then try
            if ( reply.MsgType = LMREP_OK ) then begin
               scriptLines.Text := reply.MsgData;
            end;
         finally reply.Free end;
      except
         on E:Exception do begin
            HMessageDlg( 'Script ' + scriptFile + ' could not be downloaded!'
               + #13#10#13#10 + 'Error: ' + E.Message, mtError, [mbOK] );
         end;
      end;

      // look for any '#!meta' lines
      for i := 0 to scriptLines.Count - 1 do begin
         if Pos( '#!meta', LowerCase( scriptLines[i] ) ) = 1  then begin

            s := TrimWhSpace( copy( scriptLines[i], 7, MaxInt ) );
            ArgsWhSpaceDQuoted( s, metaParts, 9 );
            metaCommand := LowerCase( metaParts[0] );

            if metaCommand = 'paramcount' then begin
               // #!meta paramcount <count>
               paramCount := strtointdef( metaParts[1], 0 );
               SetLength( ParamPrompt,  paramCount+1 );
               SetLength( ParamDefault, paramCount+1 );

            end else if metaCommand = 'paramtitle' then begin
               // #!meta paramtitle <text>
               paramTitle := metaParts[1];

            end else if metaCommand = 'paramdefault' then begin
               // paramdefault <number> <prompt>
               k := strtointdef( metaParts[1], 0 );
               if (k >= 1) and (k <= paramCount) then begin
                  paramDefault[k] := metaParts[2];
               end else begin
                  GuiLog( '[META] Index out of range: ' + scriptLines[i] );
                  paramCount := 0;
                  break;
               end;

            end else if metaCommand = 'paramprompt' then begin
               // paramprompt <number> <prompt>
               k := strtointdef( metaParts[1], 0 );
               if (k >= 1) and (k <= paramCount) then begin
                  paramPrompt[k] := metaParts[2];
               end else begin
                  GuiLog( '[META] Index out of range: ' + scriptLines[i] );
                  paramCount := 0;
                  break;
               end;

            end;

         end;
      end;

      // get and prepare script parameters
      if paramCount > 0 then begin

         // get meta parameters
         for i := 1 to paramCount do begin
            s := paramDefault[i];
            if paramPrompt[i] = '' then paramPrompt[i] := 'Parameter:';
            if not InputDlgStr( paramTitle, paramPrompt[i], s, 0 ) then exit;
            if i > 1 then scriptPars := scriptPars + #9;
            scriptPars := scriptPars + s;
         end;

      end else if (Sender = acScriptStartPar) and (paramCount = 0) then begin

         // get space separated parameters
         if not InputDlgStr( 'Start Script', 'Parameters:', scriptPars, 0 ) then exit;
         SL := TStringList.Create;
         try
            ArgsWhSpaceDQuoted( scriptPars, SL );
            scriptPars := StringReplace( SL.Text, #13#10, #9, [rfReplaceAll] );
            if (length(scriptPars) > 0) and (scriptPars[length(scriptPars)] = #9) then
               System.Delete( scriptPars, length(scriptPars), 1 );
         finally SL.Free end;
         
      end;

   finally
      paramPrompt  := nil;
      paramDefault := nil;
      metaParts.Free;
      scriptLines.Free;
   end;

   // start script
   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create(
         LMREQ_SCRIPT_START, DQuoteStr( scriptFile ) + CRLF + scriptPars
      )
   );
   CheckConnection;
end;

procedure TfrmMain.acScriptDelExecute(Sender: TObject);
var  TN: TTreeNode;
begin
   TN := tvScriptRemote.Selected;
   if not Assigned( TN ) then exit;
   if TN.Data <> NT_FILE then exit;

   if HMessageDlg(
      'Delete script "' + FullScriptFilePath(TN) + '" on server?',
      Application.Title, mtConfirmation, [mbYes,mbNo] ) <> mrYes then exit;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create(
         LMREQ_SCRIPT_DELETE, DQuoteStr( FullScriptFilePath( TN ) )
      )
   );
   CheckConnection;

   // refresh script list
   acScriptRefresh.Execute;
end;

procedure TfrmMain.acScriptEditExecute(Sender: TObject);
var  TN: TTreeNode;
     FN, SN: String;
     i: Integer;
begin
   TN := tvScriptRemote.Selected;
   if not Assigned( TN ) then exit;
   if TN.Data <> NT_FILE then exit;

   FN := FullScriptFilePath( TN );
   i  := LastDelimiter( '\', FN );
   if i > 0 then SN := copy( FN, i+1, MaxInt ) else SN := FN;

   if Pos( '.hsm', LowerCase(SN) ) > 0 then begin
      EditRemoteFile( eftModule, FN, 'Module (' + FN + ')' );
   end else begin
      EditRemoteFile( eftScript, FN, 'Script (' + FN + ')' );
   end;
end;

procedure TfrmMain.acScriptNewExecute(Sender: TObject);
var  TN: TTreeNode;
     Filepath, Filename, Filetype, Filetext, s: String;
     i: Integer;
     Reply: TLiveMsg;
begin
   Filepath := '';
   Filename := '';
   Filetype := 'hsc';
   Filetext := '';

   // init properties of new file based on selected item
   TN := tvScriptRemote.Selected;
   if Assigned( TN ) then begin

      if TN.Data = NT_ROOT then begin
         // use selected type
         if TN.Text = 'MODULES' then Filetype := 'hsm';

      end else if TN.Data = NT_PATH then begin
         // use selected path and type
         while TN.Data = NT_PATH do begin
            Filepath := TN.Text + '\' + Filepath;
            TN := TN.Parent;
         end;
         if TN.Text = 'MODULES' then Filetype := 'hsm';

      end else if TN.Data = NT_FILE then begin
         // use selected file, path and type
         Filename := FullScriptFilePath( TN );
         i := LastDelimiter( '\', Filename );
         if i > 0 then begin
            Filepath := copy( Filename, 1, i );
            Filename := copy( Filename, i+1, MaxInt );
         end;
         if Pos( '.hsm', LowerCase(Filename) ) > 0 then Filetype := 'hsm';

      end;
   end;

   // if an existing file was selected, load its content
   if Filename <> '' then begin
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_SCRIPT_GET,
                                   DQuoteStr( Filepath + Filename ) )
               );
      if Assigned(Reply) then try
         if Reply.MsgType = LMREP_OK then Filetext := Reply.MsgData;
      finally Reply.Free end;
      if not CheckConnection then exit;
   end;

   // request name of new file
   Filename := '';
   s := 'Enter name of new ' + iif( Filetype = 'hsm', 'module', 'script' )
      + iif( Filepath <> '', ' in directory "' + Filepath + '"' ) + ':';
   if not InputDlgStr( 'New Script File', s, Filename, 0 ) then exit;

   // check filename
   Filename := TrimWhSpace( Filename );
   if Pos('\',Filename) + Pos('/',Filename) > 0 then begin
      HMessageDlg( 'Path separators not allowed, mark wanted path instead!',
                   'New Script File', mtWarning, [mbOK] );
      exit;
   end;

   // check/add extension
   s := Lowercase( copy( Filename, length(Filename)-3, 4 ) );
   if s <> '.' + Filetype then begin
      if Pos( '.', s ) = 0 then begin
         Filename := Filename + '.' + Filetype;
      end else begin
         HMessageDlg( 'Invalid file extension, ".' + Filetype + '" expected!',
                      'New Script File', mtWarning, [mbOK] );
         exit;
      end;
   end;

   // if no template file was selected, prepare an initial script text
   if length( Filetext ) = 0 then begin
      Filetext := '# File: ' + Filepath + Filename + CRLF;
   end;

   // create new file
   if not LiveConnector.RCLiveRequestOK(
             TLiveMsg.Create(
                LMREQ_SCRIPT_PUT,
                DQuoteStr( Filepath + Filename ) + CRLF + Filetext
             )
      ) then exit;
   if not CheckConnection then exit;
   
   // refresh script list
   acScriptRefresh.Execute;

   // edit new file
   if Filetype = 'hsm' then begin
      EditRemoteFile( eftModule, Filepath + Filename,
                      'Module (' + Filepath + Filename + ')' );
   end else begin
      EditRemoteFile( eftScript, Filepath + Filename,
                      'Script (' + Filepath + Filename + ')' );
   end;
end;

procedure TfrmMain.tvScriptRemoteChange(Sender: TObject; Node: TTreeNode);
var  p: Pointer;
begin
    if Assigned( tvScriptRemote.Selected ) then begin
       p := tvScriptRemote.Selected.Data;
    end else begin
       p := NT_ROOT;
    end;
    acScriptStart   .Enabled := RCIsConnected and (p=NT_FILE);
    acScriptStartPar.Enabled := RCIsConnected and (p=NT_FILE);
    acScriptDel     .Enabled := RCIsConnected and (p=NT_FILE);
    acScriptEdit    .Enabled := RCIsConnected and (p=NT_FILE);
    acScriptNew     .Enabled := RCIsConnected;
end;

procedure TfrmMain.acSettingsExecute(Sender: TObject);
var  i: Integer;
begin
   with TfrmSettings.Create( nil ) do try
      i := ShowModal;
   finally Free end;

   if i = mrOk then RefreshFonts;
end;

procedure TfrmMain.acServiceExecute(Sender: TObject);
begin
   if not IsWinSvcAvailable then exit;

   with TfrmService.Create( nil ) do try
      ShowModal;
   finally Free end;

   CheckConnection;
end;

procedure TfrmMain.RefreshFonts();
var  i: Integer;
begin
   lbLog         .Font.Assign( FontLogfile );
   lbLogEW       .Font.Assign( FontLogfile );
   lbTasks       .Font.Assign( FontLogfile );
   lbClients     .Font.Assign( FontLogfile );
   tvScriptRemote.Font.Assign( FontLogfile );
   lbNews        .Font.Assign( FontLogfile );

   lbLog.Canvas.Font.Assign( lbLog.Font );
   i := lbLog.Canvas.TextHeight('Gg');
   
   lbLog.ItemHeight     := i;
   lbLogEW.ItemHeight   := i;
   lbTasks.ItemHeight   := Max( i, 15 );
   lbClients.ItemHeight := Max( i, 15 );
   lbNews.ItemHeight    := i;
end;

procedure TfrmMain.acNewsRefreshExecute(Sender: TObject);
var  sg, sp: String;
     SL: TStringList;
     Reply: TLiveMsg;
begin
   if not CheckConnection then exit;

   SL := TStringList.Create;

   try
      sg := '';
      sp := '';
      
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_GROUPS_LIST, '' )
               );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then sg := Reply.MsgData;
      finally Reply.Free end;

      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_PULLS_LIST, '' )
               );
      if Assigned( Reply ) then try
         if Reply.MsgType = LMREP_OK then sp := Reply.MsgData;
      finally Reply.Free end;

      SL.Text := sg + sp;
      SL.Sort;
      lbNews.Items.Text := SL.Text;

   finally
      SL.Free;
      CheckConnection;
   end;

end;

procedure TfrmMain.acNewsGroupAddExecute(Sender: TObject);
var  Group: String;
begin
   Group := '';
   with TfrmGroupPull.Create( nil ) do try
      lblServer.Enabled := False;
      cboServer.Enabled := False;
      if ShowModal = mrOK then Group := cboGroup.Text;
   finally Free end;
   if Group = '' then exit;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_GROUPS_ADD, Group )
   );
   CheckConnection;
end;

procedure TfrmMain.acNewsGroupDelExecute(Sender: TObject);
var  Group: String;
begin
   if (lbNews.ItemIndex<0) or (lbNews.ItemIndex>=lbNews.Items.Count) then exit;
   Group := lbNews.Items[ lbNews.ItemIndex ];
   if PosWhSpace( Group ) <> 0 then exit;

   if HMessageDlg(
      'Delete newsgroup "' + group + '"?',
      Application.Title, mtConfirmation, [mbYes,mbNo] ) <> mrYes then exit;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_GROUPS_DELETE, Group )
   );
   CheckConnection;
end;

procedure TfrmMain.acNewsPullAddExecute(Sender: TObject);
var  Group, Server: String;
begin
   Group  := '';
   Server := '';
   with TfrmGroupPull.Create( nil ) do try
      if ShowModal = mrOK then begin
         Group  := cboGroup.Text;
         Server := cboServer.Text;
      end;
   finally
      Free;
   end;
   
   if (Group = '') or (Server = '') then exit;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_PULLS_ADD, Group + TAB + Server )
   );
   CheckConnection;
end;

procedure TfrmMain.acNewsPullDelExecute(Sender: TObject);
var  Group, Server: String;
     i: Integer;
     s: String;
begin
   if (lbNews.ItemIndex<0) or (lbNews.ItemIndex>=lbNews.Items.Count) then exit;
   s := lbNews.Items[ lbNews.ItemIndex ];
   i := PosWhSpace( s );
   if i = 0 then exit;

   Group  := copy( s, 1, i-1 );
   Server := copy( s, i+1, MaxInt );
   if (Group='') or (Server='') then exit;

   if HMessageDlg(
      'Delete pull for group "' + Group + '" and server "' + Server + '"?',
      Application.Title, mtConfirmation, [mbYes,mbNo] ) <> mrYes then exit;

   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_PULLS_DELETE, Group + TAB + Server )
   );
   CheckConnection;
end;

procedure TfrmMain.lbNewsDrawItem( Control: TWinControl; Index: Integer;
                                   Rect: TRect; State: TOwnerDrawState );
var  TX: String;
     lbNews: TListBox;
     IsGroup: Boolean;
     i: Integer;
begin
   lbNews := ( Control as TListBox );

   TX := lbNews.Items[Index];
   i  := PosWhSpace( TX );
   IsGroup := ( i = 0 );
   if not IsGroup then begin
      TX := copy( TX, 1, i-1 ) + ' (' + copy( TX, i+1, MaxInt ) + ')';
   end;

   try with lbNews.Canvas do begin
      if IsGroup then begin
         Font.Color  := clBlack;
         Brush.Color := clWhite;
      end else begin
         Font.Color  := clGray;
         Brush.Color := clWhite;
      end;

      FillRect(Rect);
      TextOut( Rect.Left + 1, Rect.Top, TX );
   end except end;
end;

procedure TfrmMain.lbNewsClick(Sender: TObject);
var  IsGroup, IsPull: Boolean;
begin
   if (lbNews.ItemIndex<0) or (lbNews.ItemIndex>=lbNews.Items.Count) then begin
      IsGroup := False;
      IsPull  := False;
   end else begin
      IsGroup := ( PosWhSpace( lbNews.Items[lbNews.ItemIndex] ) = 0 );
      IsPull  := not IsGroup;
   end;

   acNewsGroupDel.Enabled := IsGroup;
   acNewsPullDel .Enabled := IsPull;
end;

procedure TfrmMain.LiveInfoHandler;
var  Item: TLiveMsg;
     LogChanged: Boolean;
     ID, sel: Integer;
     TX: String;
begin
   LogChanged := False;
   try

      while LiveConnector.QueueInf.Get( Item ) do try
         if not Assigned( Item ) then break;

         case Item.MsgType of
            LMINF_LOCALSERVER_STATES: begin
               TX := Item.MsgData;
               ServerRunning[stNNTP] := ( NextTopLine(TX) = '1' );
               ServerRunning[stPOP3] := ( NextTopLine(TX) = '1' );
               ServerRunning[stSMTP] := ( NextTopLine(TX) = '1' );
               ServerRunning[stRECO] := ( NextTopLine(TX) = '1' );
               CheckConnection;
            end;

            LMINF_LOCALSERVER_CLIENTS: begin
               lbClients.Items.Text := Item.MsgData;
            end;

            LMINF_COUNTERS_LIST: begin
               ShowCounters( Item.MsgData );
            end;

            LMINF_TASKS_LIST: begin
               sel := lbTasks.ItemIndex;
               lbTasks.Items.Text := Item.MsgData;
               if (sel >= 0) and (sel < lbTasks.Items.Count) then begin
                  lbTasks.ItemIndex := sel;
               end;
               lbTasksClick( nil );
            end;

            LMINF_LOGFILE_ADD: begin
               if not LogChanged then begin
                  lbLog.Items.BeginUpdate;
                  LogChanged := True;
               end;

               ID := strtointdef( '$' + copy( Item.MsgData, 1, 4 ), LOGID_INFO );
               TX := copy( Item.MsgData, 6, 1024 );
               lbLog.Items.AddObject( TX, Pointer(ID) );

               if (ID=LOGID_ERROR) or (ID=LOGID_WARN) then begin
                  lbLogEW.Items.AddObject( TX, Pointer(ID) );
               end;
            end;

            LMXXX_HC_GUI_LOG: begin
               if not LogChanged then begin
                  lbLog.Items.BeginUpdate;
                  LogChanged := True;
               end;

               ID := LOGID_UNHANDLED;
               TX := FormatDateTime( 'yyyy/mm/dd hh:nn:ss', Now )
                   + ' ' + Item.MsgData;
               lbLog.Items.AddObject( TX, Pointer(ID) );
            end;

            else begin
               if not LogChanged then begin
                  lbLog.Items.BeginUpdate;
                  LogChanged := True;
               end;
               lbLog.Items.AddObject(
                  'Unknown info received. Type=' + inttohex( Item.MsgType, 4 )
                  + ' Data=' + Item.MsgData, Pointer(LOGID_UNHANDLED) );
            end;
         end;

      finally
         if Assigned(Item) then Item.Free;
      end;

   finally
      if LogChanged then try
         if mnuLogAutoScroll.Checked then begin
            while lbLog.Items.Count > LogLinesMax do lbLog.Items.Delete( 0 );
            if lbLog.Items.Count>0 then lbLog.ItemIndex := lbLog.Items.Count-1;
         end;
         if ( lbLogEW.Items.Count > 0 ) and not tsLogEW.TabVisible then begin
            tsLogEW.TabVisible := True;
         end;
      finally lbLog.Items.EndUpdate end;
   end;
end;

procedure TfrmMain.lbLogDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var  ID, l: Integer;
     TX   : String;
     lstLog: TListBox;
begin
   lstLog := ( Control as TListBox );

   try with lstLog.Canvas do begin

      TX := lstLog.Items[Index];
      ID := Integer( lstLog.Items.Objects[Index] );

      case ID of
         LOGID_UNHANDLED: begin Font.Color:=clWhite; Brush.Color:=clGreen; end;
         LOGID_ERROR : begin Font.Color:=clWhite;  Brush.Color:=clRed;    end;
         LOGID_WARN  : begin Font.Color:=clBlack;  Brush.Color:=clYellow; end;
         LOGID_SYSTEM: begin Font.Color:=clWhite;  Brush.Color:=clBlue;   end;
         LOGID_INFO  : begin Font.Color:=clBlack;  Brush.Color:=clWhite;  end;
         LOGID_DEBUG : begin Font.Color:=clLtGray; Brush.Color:=clWhite;  end;
         else          begin Font.Color:=clBlack;  Brush.Color:=clLtGray; end;
      end;

      FillRect(Rect);
      TextOut( Rect.Left + 2, Rect.Top, TX );

      l := TextWidth( TX );
      if l > LbHorizExtent then begin
         LbHorizExtent := l;
         SendMessage( lbLog.Handle,   LB_SETHORIZONTALEXTENT, LbHorizExtent, 0 );
         SendMessage( lbLogEW.Handle, LB_SETHORIZONTALEXTENT, LbHorizExtent, 0 );
      end;

   end except end;
end;

procedure TfrmMain.acServerStopAllTasksExecute(Sender: TObject);
begin
   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_TASKS_STOPALL, '' )
   );
   CheckConnection;
end;

procedure TfrmMain.ShowCounters( const CounterString: String );
const StatusText = 'Tasks/Jobs=%TA/%JO'
                 + '   News: Out=%NO In=%NL Hist.=%NH Kill=%NK'
                 + '   Mail: Out=%MO In=%MI'
                 + '   Byte=%BY';
var CounterList: TStringList;

   function CntValue( const CntName: String ): Int64;
   begin
      Result := strtoint64def( CounterList.Values[ CntName ], 0 );
   end;

   Function ExpandInfo (Const s: String): String;
   Var p: Integer; s2: String;

      Procedure Ersetze (Const von, nach: String);
      begin
         p := Pos(von, s2);
         If p > 0 then begin
            Result := Copy(Result, 1, p-1) + Nach
                    + Copy(Result, p+Length(von), Length(Result));
            s2 := LowerCase(Result)
         end
      end;

   begin
      Result := s; s2 := LowerCase(s);
      Ersetze ('%ta', inttostr(CntValue('ta')+CntValue('tc')));
      Ersetze ('%jo', inttostr(CntValue('ta')+CntValue('tc')+CntValue('jo')));
      Ersetze ('%no', CurrToStrF( CntValue('no'), ffNumber, 0 ));
      Ersetze ('%mo', CurrToStrF( CntValue('mo'), ffNumber, 0 ));
      Ersetze ('%ni', CurrToStrF( CntValue('ni'), ffNumber, 0 ));
      Ersetze ('%nl', CurrToStrF( CntValue('nl'), ffNumber, 0 ));
      Ersetze ('%nh', CurrToStrF( CntValue('nh'), ffNumber, 0 ));
      Ersetze ('%nk', CurrToStrF( CntValue('nk'), ffNumber, 0 ));
      Ersetze ('%mi', CurrToStrF( CntValue('mi'), ffNumber, 0 ));
      Ersetze ('%by', CurrToStrF( CntValue('bi')+CntValue('bo'), ffNumber, 0 ));
      Ersetze ('%kb', CurrToStrF( (CntValue('bi')+CntValue('bo')) div 1024, ffNumber, 0 ));
      Ersetze ('^m', #13#10)
   end;

begin
   CounterList := TStringList.Create;
   try
      CounterList.Text := CounterString;
      Status( ExpandInfo( StatusText ) );
   finally CounterList.Free end;
end;

procedure TfrmMain.acReportsExecute(Sender: TObject);
begin
   with TfrmReports.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfAppExecute(Sender: TObject);
begin
   with TfrmConfApp.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfHamExecute(Sender: TObject);
begin
   with TfrmConfHam.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfSrvExecute(Sender: TObject);
begin
   with TfrmConfSrv.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfGrpExecute(Sender: TObject);
begin
   with TfrmConfGrp.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfPwdExecute(Sender: TObject);
begin
   with TfrmConfPwd.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfAccExecute(Sender: TObject);
begin
   with TfrmConfAcc.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfMLExecute(Sender: TObject);
begin
   with TfrmConfML.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acConfMailTrapExecute(Sender: TObject);
begin
   with TfrmConfMailTrap.Create( nil ) do try
      ShowModal;
   finally Free end;
   CheckConnection;
end;

procedure TfrmMain.acStartTasksExecute(Sender: TObject);
begin
   with TfrmStartTasks.Create( nil ) do try
      ShowModal;
   finally Free end;
   if RCIsConnected then acTasksRefresh.Execute;
   CheckConnection;
end;

procedure TfrmMain.acConfFileIPAccessExecute(Sender: TObject);
begin
   EditRemoteFile( eftIPAccess, CFGFILE_IPACCESS,
                   'IP Access (IPAccess.hst)' );
end;

procedure TfrmMain.acConfFileScoresExecute(Sender: TObject);
begin
   EditRemoteFile( eftScores, CFGFILE_SCORES,
                   'News Score File (Scores.hst)' );
end;

procedure TfrmMain.acConfFileMailFiltExecute(Sender: TObject);
begin
   EditRemoteFile( eftMailFilt, CFGFILE_MAILFILT,
                   'Mail Filters (MailFilt.hst)' );
end;

procedure TfrmMain.acConfFileSmtpRouterExecute(Sender: TObject);
begin
   EditRemoteFile( eftMailFilt, CFGFILE_SMTPROUTER,
                   'Mail Delivery (SmtpRouter.hst)' );
end;

procedure TfrmMain.acConfFileKillsLogExecute(Sender: TObject);
begin
   EditRemoteFile( eftKillsLog, GRPFILE_KILLSLOG,
                   'News Kills Log (Kills.log)' );
end;

procedure TfrmMain.acConfFileRCProfilesExecute(Sender: TObject);
begin
   EditRemoteFile( eftRCProfiles, CFGFILE_RCPROFILES,
                   'RC Server Profiles (RCProfiles.hst)' );
end;

procedure TfrmMain.acConfFileHscActionsExecute(Sender: TObject);
begin
   EditRemoteFile( eftHscActions, CFGFILE_HSCACTIONS,
                   'Script Actions (HscActions.hst)' );
end;

procedure TfrmMain.lbTasksDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var  Line, Desc, CNam, Stat, s: String;
     Uid, Typ, Img, RL: Integer;
begin
   Line := (Control as TListBox).Items[Index];
   Uid  := strtointdef( NextSepPart( Line, TAB ), 0 );
   {Tid} NextSepPart( Line, TAB );
   Typ  := strtointdef( NextSepPart( Line, TAB ), 0 );
   Desc := UnDQuoteStr( NextSepPart( Line, TAB ) );
   CNam := UnDQuoteStr( NextSepPart( Line, TAB ) );
   Stat := UnDQuoteStr( NextSepPart( Line, TAB ) );

   case TActiveThreadTypes( Typ ) of
      attMaintenance: Img := 30;
      attTransfer   : Img := 31;
      attScript     : Img := 27;
      attUserTask   : Img := 54;
      else            Img := -1;
   end;

   with lbTasks.Canvas do begin

      FillRect( Rect );

      RL := Rect.Left + 2;

      if Img >= 0 then begin
         ilMain.Draw( (Control as TListBox).Canvas, RL, Rect.Top, Img, True );
      end;
      inc( RL, 16 + 2 );

      (*
      Pen.Color := clGray;
      s := 'UID=' + inttostr(Uid)
         // + '  TID={' + lowercase( inttohex( Tid, 1 ) ) + '}'
         // + '  ' + Desc
         + '  ' + CNam + ': ' + Stat
         + '  (' + Desc + ')';
      TextOut( RL, Rect.Top, s );
      l := RL + TextWidth( s );
      *)

      Font.Color := clBlack;
      s := 'UID=' + inttostr(Uid) + '  ' + Desc;
      TextOut( RL, Rect.Top, s );
      inc( RL, TextWidth(s) );

      Font.Color := clBlue;
      s := '  ' + Stat;
      TextOut( RL, Rect.Top, s );
      inc( RL, TextWidth(s) );

      Font.Color := clGray;
      s := '  (' + CNam + ')';
      TextOut( RL, Rect.Top, s );
      inc( RL, TextWidth(s) );

      if RL > LbHorizExtentTasks then begin
         LbHorizExtentTasks := RL;
         SendMessage( lbTasks.Handle, LB_SETHORIZONTALEXTENT, LbHorizExtentTasks, 0 );
      end;

   end;
end;

procedure TfrmMain.lbClientsDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var  Line, IP, User, s: String;
     Srv, Uid, Img, RL, l: Integer;
begin
   Line := (Control as TListBox).Items[Index];
   Srv  := strtointdef( NextSepPart( Line, TAB ), 0 );
   Uid  := strtointdef( NextSepPart( Line, TAB ), 0 );
   {Tid} NextSepPart( Line, TAB );
   IP   := NextSepPart( Line, TAB );
   User := Line;

   case TServerTypes( Srv ) of
      stNNTP: Img := 41;
      stPOP3: Img := 42;
      stSMTP: Img := 43;
      stRECO: Img := 44;
      else    Img := -1;
   end;

   with (Control as TListBox).Canvas do begin
      FillRect( Rect );

      RL := Rect.Left + 2;
      
      if Img >= 0 then begin
         ilMain.Draw( (Control as TListBox).Canvas, RL, Rect.Top, Img, True );
      end;
      inc( RL, 16 + 2 );

      s := 'UID=' + inttostr(Uid)
         //+ '  TID={' + lowercase( inttohex( Tid, 1 ) ) + '}'
         + '  IP=' + IP
         + '  User=' + User;
      TextOut( RL, Rect.Top, s );

      l := RL + TextWidth( s );
      if l > LbHorizExtentClients then begin
         LbHorizExtentClients := l;
         SendMessage( lbClients.Handle, LB_SETHORIZONTALEXTENT, LbHorizExtentClients, 0 );
      end;

   end;
end;

procedure TfrmMain.mnuLogAutoScrollClick(Sender: TObject);
begin
   mnuLogAutoScroll.Checked := not mnuLogAutoScroll.Checked;
   if mnuLogAutoScroll.Checked then begin
      if lbLog.Items.Count > 0 then lbLog.ItemIndex := lbLog.Items.Count - 1;
   end;
end;

procedure TfrmMain.acStopTaskSelExecute(Sender: TObject);
var  s: String;
     u: Integer;
begin
   if lbTasks.ItemIndex < 0 then exit;
   if lbTasks.ItemIndex >= lbTasks.Items.Count then exit;

   s := lbTasks.Items[ lbTasks.ItemIndex ];
   u := strtointdef( NextSepPart( s, TAB ), 0 );
   if u <= 0 then exit;

   try
      LiveConnector.RCLiveRequestOK(
         TLiveMsg.Create( LMREQ_TASKS_STOPBYID, inttostr(u) )
      );
   finally
      CheckConnection;
   end;
end;

procedure TfrmMain.lbTasksClick(Sender: TObject);
begin
   acStopTaskSel.Enabled := ( lbTasks.ItemIndex >= 0 ) and
                            ( lbTasks.ItemIndex < lbTasks.Items.Count );
   mnuLogViewTask.Enabled := acStopTaskSel.Enabled;
end;

procedure TfrmMain.mnuLogEWClearClick(Sender: TObject);
begin
   lbLogEW.Clear;
end;

procedure TfrmMain.mnuLogEWClearHideClick(Sender: TObject);
begin
   lbLogEW.Clear;
   tsLogEW.TabVisible := ( lbLogEW.Items.Count > 0 );
end;

procedure TfrmMain.acScriptStartListExecute(Sender: TObject);
begin
   tbtnScripts.CheckMenuDropdown;
end;

procedure TfrmMain.mnuScriptStartListClick(Sender: TObject);
var  s: String;
begin
   if not( Sender is TMenuItem ) then exit;
   s := ( Sender as TMenuItem ).Hint;
   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create(
         LMREQ_SCRIPT_START, DQuoteStr( s ) + CRLF // + ScriptParams
      )
   );
   CheckConnection;
end;

procedure TfrmMain.mnuTasksStartListClick(Sender: TObject);
var  s: String;
begin
   if not( Sender is TMenuItem ) then exit;
   s := ( Sender as TMenuItem ).Hint;
   LiveConnector.RCLiveRequestOK(
      TLiveMsg.Create( LMREQ_RUN_USERTASK, s )
   );
   CheckConnection;
end;

procedure TfrmMain.acHelpContentExecute(Sender: TObject);
begin
   {$IFDEF USE_HTMLHELPKIT}
   if HtmlHelpHook = nil then begin
      HMessageDlg( 'HtmlHelp is not installed - online help disabled!',
                   Application.Title, mtWarning, [mbOK] );
      exit;
   end;

   HtmlHelpHook.HelpContext( 0 );
   {$ENDIF}
end;

function TfrmMain.GetVersions: String;
var  sc, ss: String;
     Reply : TLiveMsg;
     SL: TStringList;
begin
   sc := GetExeVersion;
   ss := HServiceVersion;

   SL := TStringList.Create;
   try
      if RCIsConnected then begin
         Reply := LiveConnector.RCLiveRequest(
                     TLiveMsg.Create( LMREQ_APP_SETTING_GET, '' )
                  );
         if Assigned( Reply ) then try
            SL.Text := Reply.MsgData;
            ss := SL.Values[ inttostr(asServiceVersion) ];
            if ss <> HServiceVersion then begin
               HServiceVersion := ss;
               SaveLocalSettings;
            end;
         finally Reply.Free end;
      end;

   finally
      SL.Free;
      Result := 'HService: Vr. ' + ss + CRLF
              + 'HControl: Vr. ' + sc + CRLF;
   end;
end;

procedure TfrmMain.acHelpAboutExecute(Sender: TObject);
begin
   if HMessageDlg(
         GetMyStringFileInfo('ProductName','Hamster') + CRLF + CRLF
         + GetVersions + CRLF
         + GetMyStringFileInfo('LegalCopyright','') + CRLF + CRLF
         + 'Maintainer: ' + GetMyStringFileInfo('Maintainer','') + CRLF
         + 'Download: '   + GetMyStringFileInfo('Download','') + CRLF + CRLF
         + 'Show details?',
         GetMyStringFileInfo('ProductName','Hamster'),
         mtConfirmation, [mbYes,mbNo] ) = mrYes then begin

      Application.HelpCommand( HELP_CONTEXT, 9000 );

   end;
end;

procedure TfrmMain.acHelpSysInfoExecute(Sender: TObject);
var  s, h, SysDir, WinDir: String;
     p: array[0..256] of Char;
     dw: DWord;
begin
   s := GetMyStringFileInfo('ProductName','Hamster') + CRLF + CRLF
      + GetVersions + CRLF;
                    
   s := s + 'Platform'+': ' + GetWinVerInfo + #13#10;
   s := s + #13#10;

   GetSystemDirectory ( p, 256 ); SysDir:=String(p)+'\';
   GetWindowsDirectory( p, 256 ); WinDir:=String(p)+'\';
   h := 'wsock32.dll';
   s := s + 'File ' + h + ': ' + GetFileInfo( SysDir + h ) + #13#10;
   h := 'ws2_32.dll ';
   s := s + 'File ' + h + ': ' + GetFileInfo( SysDir + h ) + #13#10;
   h := 'rasapi32.dll';
   s := s + 'File ' + h + ': ' + GetFileInfo( SysDir + h ) + #13#10;

   s := s + #13#10;
   dw := 256;
   if GetComputerName(p,dw) then h:=String(p) else h:='(none)';
   s := s + 'Computer-Name'+': ' + h + #13#10;
   dw := 256;
   if GetUserName(p,dw) then h:=String(p) else h:='(none)';
   s := s + 'User-Name'+': ' + h + #13#10;

   if HMessageDlg( s + #13#10#13#10 + 'Copy info to clipboard?',
                   'Hamster''s System-Information',
                   mtConfirmation, [mbYes,mbNo] ) = mrYes then begin
      Clipboard.Clear;
      Clipboard.AsText := s;
   end;
end;

procedure TfrmMain.mnuLogViewAllClick(Sender: TObject);
begin
   EditLocalText( 'View Log: All', lbLog.Items.Text );
end;

procedure TfrmMain.mnuLogViewThreadClick(Sender: TObject);
var  LB: TListBox;
     Txt, Thd: String;
     i: Integer;
begin
   if      Sender = mnuLogViewThread   then LB := lbLog
   else if Sender = mnuLogEWViewThread then LB := lbLogEW
   else if Sender = mnuLogViewTask     then LB := lbTasks
   else if Sender = mnuLogViewClient   then LB := lbClients
   else exit;

   if LB.ItemIndex < 0 then exit;
   if LB.ItemIndex >= LB.Items.Count then exit;
   Thd := LB.Items[ LB.ItemIndex ];

   if Sender = mnuLogViewTask then begin
      Thd  := '{' + NextSepPart( Thd, TAB ) + '}';

   end else if Sender = mnuLogViewClient then begin
      NextSepPart( Thd, TAB );
      Thd  := '{' + NextSepPart( Thd, TAB ) + '}';

   end else begin
      i := Pos( '{', Thd ); if i = 0 then exit;
      Thd := copy( Thd, i, MaxInt );
      i := Pos( '}', Thd ); if i = 0 then exit;
      SetLength( Thd, i );

   end;

   Txt := '';
   for i := 0 to lbLog.Items.Count - 1 do begin
      if Pos( Thd, lbLog.Items[i] ) > 0 then Txt := Txt + lbLog.Items[i] + CRLF;
   end;

   if length( Txt ) > 0 then begin
      EditLocalText( 'View Log: Thread ' + Thd, Txt );
   end else begin
      if Sender = mnuLogViewThread   then mnuLogFindThisClick(mnuLogFindThis);
      if Sender = mnuLogEWViewThread then mnuLogFindThisClick(mnuLogEWFindThis);
   end;
end;

procedure TfrmMain.mnuLogFindClick(Sender: TObject);
begin
   with TfrmLogFind.Create( nil ) do try
      ShowModal;
   finally Free end;

   CheckConnection;
end;

procedure TfrmMain.mnuLogFindThisClick(Sender: TObject);
var  LB: TListBox;
     line, task: String;
     dt: TDate;
     i, days: Integer;
begin
   if      Sender = mnuLogFindThis   then LB := lbLog
   else if Sender = mnuLogEWFindThis then LB := lbLogEW
   else exit;

   if LB.ItemIndex < 0 then exit;
   if LB.ItemIndex >= LB.Items.Count then exit;
   line := LB.Items[ LB.ItemIndex ];

   task := Line;
   i := Pos( '{', task ); if i = 0 then exit;
   task := copy( task, i, MaxInt );
   i := Pos( '}', task ); if i = 0 then exit;
   SetLength( task, i );

   try
      dt := EncodeDate( StrToInt( copy( line, 1, 4 ) ),
                        StrToInt( copy( line, 6, 2 ) ),
                        StrToInt( copy( line, 9, 2 ) ) );
      days := Trunc( Date - dt );
   except
      days := 0;
   end;

   with TfrmLogFind.Create( nil ) do try
      SetFindThisTask( task, days );
      ShowModal;
   finally Free end;

   CheckConnection;
end;

procedure TfrmMain.mnuLogEWShowHistoryClick(Sender: TObject);

   procedure ShowErrors( SL: TStringList );
   const maxLen = 1024;
   var  ID, i, j: Integer;
        TX: String;
   begin
      for i := 0 to SL.Count - 1 do begin

         TX := SL[i];
         if length(TX) > maxLen then begin
            SetLength( TX, maxLen-1 );
            TX := TX + '';
         end;

         ID := LOGID_INFO;
         j := Pos( '{', TX );
         if j > 4 then begin
            ID := LogMarkerToId( copy( TX, j-4, 3 ) );
            if ID = LOGID_UNKNOWN then ID := LOGID_INFO;
            System.Delete( TX, j-4, 3+1 );
         end;

         lbLogEW.Items.AddObject( TX, Pointer(ID) );

      end;
   end;

var  SL: TStringList;
     Reply: TLiveMsg;
begin
   SL := TStringList.Create;
   lbLogEW.Items.BeginUpdate;
   try
      lbLogEW.Items.Clear;
      tsLogEW.TabVisible := True;
      pgMain.ActivePageIndex := tsLogEW.PageIndex;

      // get and show error history
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_LOGFILE_LISTERRORS, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            SL.Text := Reply.MsgData;
            ShowErrors( SL );
         end;
      finally Reply.Free end;

   finally
      lbLogEW.Items.EndUpdate;
      SL.Free;
      CheckConnection;
   end;
end;

procedure TfrmMain.lbLogDblClick(Sender: TObject);
begin
   if      Sender = lbLog     then mnuLogViewThreadClick( mnuLogViewThread   )
   else if Sender = lbLogEW   then mnuLogViewThreadClick( mnuLogEWViewThread )
   else if Sender = lbTasks   then mnuLogViewThreadClick( mnuLogViewTask     )
   else if Sender = lbClients then mnuLogViewThreadClick( mnuLogViewClient   )
   ;
end;

procedure TfrmMain.acUserTasksSetupExecute(Sender: TObject);
begin
   TfrmUserTasks.ShowDialog( self, '' );
   if RCIsConnected then acTasksRefresh.Execute;
end;

procedure TfrmMain.acActionsSetupExecute(Sender: TObject);
begin
   TfrmActions.ShowDialog( self );
end;

procedure TfrmMain.acSchedulerSetupExecute(Sender: TObject);
begin
   TfrmScheduler.ShowDialog( self );
end;

procedure TfrmMain.lbLogMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var  point: TPoint;
     index: Integer;
     listBox: TListBox;
begin
   // select line under cursor on right-click for context menus
   if Sender is TListBox then begin
      if Button = mbRight then begin
         listBox := ( Sender as TListBox );
         point.x := X;
         point.y := Y;
         index := listBox.ItemAtPos( point, true );
         if index >= 0 then listBox.ItemIndex := index;
      end;
   end;
end;

end.
