// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
// See file License.txt for details.
// ============================================================================

unit fConfHam;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dDialogs, StdCtrls, cSettings, ComCtrls;

type
  TfrmConfHam = class(TForm)
    btnRefresh: TButton;
    btnOK: TButton;
    btnCancel: TButton;
    PageControl1: TPageControl;
    pgGeneral: TTabSheet;
    pgLocalNews: TTabSheet;
    pgRemote: TTabSheet;
    GroupBox1: TGroupBox;
    Label12: TLabel;
    Label15: TLabel;
    emRemConnectTO: TEdit;
    emRemCommandTO: TEdit;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    chkGenMID: TCheckBox;
    chkAddXHeaderNews: TCheckBox;
    chkAddUnknownMIDs: TCheckBox;
    pgLocalCommon: TTabSheet;
    grpDaily: TGroupBox;
    ckDailyStats: TCheckBox;
    ckDailyLists: TCheckBox;
    ckDailyUnsubs: TCheckBox;
    ckDailyPurgeNews: TCheckBox;
    ckDailyPurgeHistory: TCheckBox;
    ckDailyPurgeKills: TCheckBox;
    ckDailyPurgeMailHist: TCheckBox;
    pgRemoteNews: TTabSheet;
    pgRemoteMail: TTabSheet;
    grpSetNewsPull: TGroupBox;
    Label18: TLabel;
    Label22: TLabel;
    Label24: TLabel;
    emPullLimit: TEdit;
    emPullFirst: TEdit;
    grpSetMail: TGroupBox;
    labDelete: TLabel;
    labIgnore: TLabel;
    labNotify: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    chkLeaveMails: TCheckBox;
    chkIgnoreAlreadyLoaded: TCheckBox;
    txtNotify: TEdit;
    txtIgnore: TEdit;
    txtDelete: TEdit;
    grpSMTP: TGroupBox;
    labSMTPAttempts: TLabel;
    chkDelFailedMails: TCheckBox;
    txtSMTPAttempts: TEdit;
    ckNewsAddXTrace: TCheckBox;
    Label33: TLabel;
    emRemMailTopLines: TEdit;
    Label47: TLabel;
    emAutoDelPulls: TEdit;
    emAutoDelGroups: TEdit;
    Label54: TLabel;
    pgSrvDetails: TTabSheet;
    grpRestrictions: TGroupBox;
    labMaxSizeNNTP: TLabel;
    emMaxBytesNNTP: TEdit;
    emMaxLinesNNTP: TEdit;
    labMaxSizePOP3: TLabel;
    emMaxBytesPOP3: TEdit;
    emMaxLinesPOP3: TEdit;
    emMaxBytesSMTP: TEdit;
    emMaxLinesSMTP: TEdit;
    emRecoTextSize: TEdit;
    emRecoLineLen: TEdit;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label34: TLabel;
    emNntpClients: TEdit;
    emPop3Clients: TEdit;
    emSmtpClients: TEdit;
    emRecoClients: TEdit;
    grpLocalSASL: TGroupBox;
    Label45: TLabel;
    emPop3SASL: TEdit;
    Label44: TLabel;
    emSmtpSASL: TEdit;
    Label46: TLabel;
    emRecoSASL: TEdit;
    grpLocalSrv: TGroupBox;
    ckRCAutostart: TCheckBox;
    emRecoBind: TEdit;
    emRCPort: TEdit;
    chkAutoStartNntp: TCheckBox;
    Label49: TLabel;
    emNntpBind: TEdit;
    Label7: TLabel;
    emNntpPort: TEdit;
    chkAutoStartPop3: TCheckBox;
    Label50: TLabel;
    emPop3Bind: TEdit;
    emPop3Port: TEdit;
    chkAutoStartSmtp: TCheckBox;
    emSmtpBind: TEdit;
    emSmtpPort: TEdit;
    Label13: TLabel;
    Label14: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    grpStorage: TGroupBox;
    Label23: TLabel;
    Label10: TLabel;
    emKeepArts: TEdit;
    Label11: TLabel;
    emKeepHist: TEdit;
    Label3: TLabel;
    emKeepKill: TEdit;
    labMailhistory: TLabel;
    txtMailHistory: TEdit;
    grpLocalMails: TGroupBox;
    Label9: TLabel;
    emFQDN: TEdit;
    grpLocalConn: TGroupBox;
    Label41: TLabel;
    emInactivityTO: TEdit;
    Label42: TLabel;
    emQuitDelay: TEdit;
    grpPWHandling: TGroupBox;
    labPWBase: TLabel;
    cbPWBase: TComboBox;
    grpSocks: TGroupBox;
    Label8: TLabel;
    cbSocksVer: TComboBox;
    Label30: TLabel;
    emSocksSrv: TEdit;
    Label31: TLabel;
    emSocksPort: TEdit;
    Label35: TLabel;
    Label36: TLabel;
    emSocksUser: TEdit;
    emSocksPass: TEdit;
    ckSocksAuth: TCheckBox;
    pgLocalMail: TTabSheet;
    grpLocalSMTP: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label43: TLabel;
    Label6: TLabel;
    Label19: TLabel;
    Label29: TLabel;
    chkSmtpAuthPOP3: TCheckBox;
    chkGenMailMID: TCheckBox;
    chkSmtpAuthAUTH: TCheckBox;
    chkAddXHeaderMail: TCheckBox;
    chkAddReceived: TCheckBox;
    emSmtpPop3Time: TEdit;
    emIsLocalDomain: TEdit;
    grpLocalGrp: TGroupBox;
    Label37: TLabel;
    cbGrpDefault: TComboBox;
    Label38: TLabel;
    cbGrpPostOK: TComboBox;
    Label39: TLabel;
    cbGrpPostErr: TComboBox;
    Label40: TLabel;
    cbGrpStats: TComboBox;
    Label48: TLabel;
    cbGrpCancels: TComboBox;
    Label51: TLabel;
    cbGrpNewGrps: TComboBox;
    Label52: TLabel;
    cbGrpUnknown: TComboBox;
    Label59: TLabel;
    cbGrpPullErr: TComboBox;
    Label32: TLabel;
    emTasksLimit: TEdit;
    Label60: TLabel;
    Label28: TLabel;
    emLogLimit: TEdit;
    btnApply: TButton;
    cbPreferredSend: TComboBox;
    ckGateAddPoster: TCheckBox;
    chkSmtpNoAuthForLocal: TCheckBox;
    grpSetNewsPost: TGroupBox;
    Label53: TLabel;
    cbPreferredPost: TComboBox;
    ckLocalInject: TCheckBox;
    Label61: TLabel;
    emDeleteAfter: TEdit;
    Label62: TLabel;
    Label63: TLabel;
    emNntpSame: TEdit;
    emPop3Same: TEdit;
    emSmtpSame: TEdit;
    emRecoSame: TEdit;
    grpLocalMail: TGroupBox;
    Label65: TLabel;
    cbJunkAccount: TComboBox;
    Label64: TLabel;
    emRemMailSkipTop: TEdit;
    Label66: TLabel;
    Label67: TLabel;
    ckJunkSkipFilt: TCheckBox;
    ckJunkSkipTrapDel: TCheckBox;
    ckJunkSkipTrapScore: TCheckBox;
    emJunkSkipScore: TEdit;
    Label68: TLabel;
    Label69: TLabel;
    cbSpamReportAccount: TComboBox;
    Label70: TLabel;
    emInactivityNntp: TEdit;
    emInactivityPop3: TEdit;
    emInactivitySmtp: TEdit;
    emInactivityReco: TEdit;
    chkSmtpApplyTraps: TCheckBox;
    chkIgnoreAlreadyFiltered: TCheckBox;
    chkButDeleteFiltered: TCheckBox;
    Label71: TLabel;
    cbNotifyAccount: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
    Settings: TSettingsPlain;
    Args    : TStringList;
    procedure SettingsToForm;
    procedure FormToSettings;
    function  LoadSettings: Boolean;
    function  SaveSettings: Boolean;
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

uses uTools, uConst, uConstVar, uGlobal, cLiveMsg, cLiveQueue,
     cSettingsHdlLive;

procedure TfrmConfHam.FormCreate(Sender: TObject);
begin
   GrowDpiForm( self );
   Settings := nil;
   Args := TStringList.Create;
   PageControl1.ActivePage := pgGeneral;
   btnRefresh.Click;
end;

procedure TfrmConfHam.FormResize(Sender: TObject);
begin
   PageControl1.Width  := ClientWidth  - 2 * PageControl1.Left;
   PageControl1.Height := ClientHeight - 3 * PageControl1.Top - btnOk.Height;
   btnOk.Top      := ClientHeight - btnOk.Height - PageControl1.Top;
   btnApply.Top   := ClientHeight - btnOk.Height - PageControl1.Top;
   btnRefresh.Top := ClientHeight - btnOk.Height - PageControl1.Top;
   btnCancel.Top  := ClientHeight - btnOk.Height - PageControl1.Top;
end;

procedure TfrmConfHam.FormDestroy(Sender: TObject);
begin
   if Assigned( Settings ) then Settings.Free;
   if Assigned( Args ) then Args.Free;
end;

procedure TfrmConfHam.SettingsToForm;
var  i: Integer;
begin
   if not Assigned( Settings ) then exit;

   // General
   ckDailyStats.Checked      := Settings.GetBoo( hsDailyStatistics );
   ckDailyLists.Checked      := Settings.GetBoo( hsDailyBuildLists );
   ckDailyUnsubs.Checked     := Settings.GetBoo( hsDailyUnsubscribe );
   i := Settings.GetInt( hsDailyPurge );
   ckDailyPurgeNews.Checked     := ( i and HAM_PURGEOPT_DONEWS ) <> 0;
   ckDailyPurgeHistory.Checked  := ( i and HAM_PURGEOPT_DOHISTORY ) <> 0;
   ckDailyPurgeKills.Checked    := ( i and HAM_PURGEOPT_DOKILLS ) <> 0;
   ckDailyPurgeMailHist.Checked := ( i and HAM_PURGEOPT_DOMHISTORY ) <> 0;
   emKeepArts.Text           := Settings.GetStr( hsPurgeArticlesKeepDays );
   emKeepHist.Text           := Settings.GetStr( hsPurgeHistoryKeepDays );
   emKeepKill.Text           := Settings.GetStr( hsPurgeKillsKeepDays );
   txtMailHistory.Text       := Settings.GetStr( hsPurgeMHistoryKeepDays );
   emFQDN.Text               := Settings.GetStr( hsFQDNforMID );
   cbPWBase.ItemIndex        := Settings.GetInt( hsPasswordCodeBase );

   // Local Servers
   chkAutoStartNntp.Checked  := Settings.GetBoo( hsLocalNntpAutostart );
   emNntpBind.Text           := Settings.GetStr( hsLocalNntpBind );
   emNntpPort.Text           := Settings.GetStr( hsLocalNntpPort );
   chkAutoStartPop3.Checked  := Settings.GetBoo( hsLocalPop3Autostart );
   emPop3Bind.Text           := Settings.GetStr( hsLocalPop3Bind );
   emPop3Port.Text           := Settings.GetStr( hsLocalPop3Port );
   chkAutoStartSmtp.Checked  := Settings.GetBoo( hsLocalSmtpAutostart );
   emSmtpBind.Text           := Settings.GetStr( hsLocalSmtpBind );
   emSmtpPort.Text           := Settings.GetStr( hsLocalSmtpPort );
   ckRCAutostart.Checked     := Settings.GetBoo( hsLocalRecoAutostart );
   emRecoBind.Text           := Settings.GetStr( hsLocalRecoBind );
   emRCPort.Text             := Settings.GetStr( hsLocalRecoPort );

   // Local News
   chkGenMID.Checked         := Settings.GetBoo( hsGenerateNewsMID );
   chkAddXHeaderNews.Checked := Settings.GetBoo( hsNewsAddXHamster );
   ckNewsAddXTrace.Checked   := Settings.GetBoo( hsNewsAddXTrace );
   chkAddUnknownMIDs.Checked := Settings.GetBoo( hsLocalNntpGetUnknownMIDs );
   emAutoDelPulls.Text       := Settings.GetStr( hsAutoUnsubscribePulls );
   emAutoDelGroups.Text      := Settings.GetStr( hsAutoUnsubscribeGroups );
   cbGrpDefault.Text         := Settings.GetStr( hsHamGroupDefault );
   cbGrpPostOK.Text          := Settings.GetStr( hsHamGroupPostOk );
   cbGrpPostErr.Text         := Settings.GetStr( hsHamGroupPostErrors );
   cbGrpStats.Text           := Settings.GetStr( hsHamGroupStatistics );
   cbGrpCancels.Text         := Settings.GetStr( hsHamGroupCancelNotify );
   cbGrpNewGrps.Text         := Settings.GetStr( hsHamGroupNewGroups );
   cbGrpUnknown.Text         := Settings.GetStr( hsHamGroupUnknownGroup );
   cbGrpPullErr.Text         := Settings.GetStr( hsHamGroupPullErrors );

   // Local Mail
   chkGenMailMID.Checked         := Settings.GetBoo( hsGenerateMailMID );
   chkAddXHeaderMail.Checked     := Settings.GetBoo( hsMailAddXHamster );
   chkAddReceived.Checked        := Settings.GetBoo( hsMailAddReceived );
   chkSmtpAuthPOP3.Checked       := Settings.GetBoo( hsLocalSmtpAuthReq );
   emSmtpPop3Time.Text           := Settings.GetStr( hsLocalSmtpAfterPop3Time );
   chkSmtpAuthAUTH.Checked       := Settings.GetBoo( hsLocalSmtpEAuthReq );
   chkSmtpNoAuthForLocal.Checked := Settings.GetBoo( hsLocalSmtpNoAuthForLocal );
   emIsLocalDomain.Text          := Settings.GetStr( hsIsLocalDomain );
   chkSmtpApplyTraps.Checked     := Settings.GetBoo( hsLocalSmtpApplyTraps );

   // Local Details
   emInactivityTO.Text       := Settings.GetStr( hsLocalTimeoutInactivity );
   emQuitDelay.Text          := Settings.GetStr( hsLocalTimeoutQuitDelay );
   emNntpClients.Text        := Settings.GetStr( hsLocalNntpClients );
   emPop3Clients.Text        := Settings.GetStr( hsLocalPop3Clients );
   emSmtpClients.Text        := Settings.GetStr( hsLocalSmtpClients );
   emRecoClients.Text        := Settings.GetStr( hsLocalRecoClients );
   emNntpSame.Text           := Settings.GetStr( hsLocalNntpSameCli );
   emPop3Same.Text           := Settings.GetStr( hsLocalPop3SameCli );
   emSmtpSame.Text           := Settings.GetStr( hsLocalSmtpSameCli );
   emRecoSame.Text           := Settings.GetStr( hsLocalRecoSameCli );
   emMaxBytesNNTP.Text       := Settings.GetStr( hsLocalNntpLimitTextSize );
   emMaxBytesPOP3.Text       := Settings.GetStr( hsLocalPop3LimitTextSize );
   emMaxBytesSMTP.Text       := Settings.GetStr( hsLocalSmtpLimitTextSize );
   emRecoTextSize.Text       := Settings.GetStr( hsLocalRecoLimitTextSize );
   emMaxLinesNNTP.Text       := Settings.GetStr( hsLocalNntpLimitLineLen );
   emMaxLinesPOP3.Text       := Settings.GetStr( hsLocalPop3LimitLineLen );
   emMaxLinesSMTP.Text       := Settings.GetStr( hsLocalSmtpLimitLineLen );
   emRecoLineLen.Text        := Settings.GetStr( hsLocalRecoLimitLineLen );
   emPop3SASL.Text           := Settings.GetStr( hsLocalPop3SASL );
   emSmtpSASL.Text           := Settings.GetStr( hsLocalSmtpSASL );
   emRecoSASL.Text           := Settings.GetStr( hsLocalRecoSASL );
   emInactivityNntp.Text     := Settings.GetStr( hsLocalNntpInactivitySec );
   emInactivityPop3.Text     := Settings.GetStr( hsLocalPop3InactivitySec );
   emInactivitySmtp.Text     := Settings.GetStr( hsLocalSmtpInactivitySec );
   emInactivityReco.Text     := Settings.GetStr( hsLocalRecoInactivitySec );

   // Remote Common
   emTasksLimit.Text         := Settings.GetStr( hsTasksLimit );
   emRemConnectTO.Text       := Settings.GetStr( hsRemoteTimeoutConnect );
   emRemCommandTO.Text       := Settings.GetStr( hsRemoteTimeoutCommand );
   cbSocksVer.ItemIndex      := Settings.GetInt( hsSocksVersion );
   emSocksSrv.Text           := Settings.GetStr( hsSocksServer );
   emSocksPort.Text          := Settings.GetStr( hsSocksPort );
   ckSocksAuth.Checked       := Settings.GetBoo( hsSocksAuth );
   emSocksUser.Text          := Settings.GetStr( hsSocksUser );
   emSocksPass.Text          := Settings.GetStr( hsSocksPass );

   // Remote News
   emPullLimit.Text          := Settings.GetStr( hsPullLimit );
   emPullFirst.Text          := Settings.GetStr( hsPullLimitFirst );
   cbPreferredPost.Text      := Settings.GetStr( hsPostServer );
   emLogLimit.Text           := Settings.GetStr( hsScoreLogLimit );
   ckLocalInject.Checked     := Settings.GetBoo( hsLocalNntpLocalInjection );

   // Remote Mail
   chkLeaveMails.Checked            := Settings.GetBoo( hsLeaveMailsOnServer );
   chkIgnoreAlreadyLoaded.Checked   := Settings.GetBoo( hsIgnoreAlreadyLoaded );
   chkIgnoreAlreadyFiltered.Checked := Settings.GetBoo( hsIgnoreAlreadyFiltered );
   chkButDeleteFiltered.Checked     := Settings.GetBoo( hsLeaveButDeleteFiltered );

   i := Settings.GetInt( hsMailDeleteLoadedAfter );
   emDeleteAfter.Text        := iif( i=0, '', inttostr(i) );

   ckGateAddPoster.Checked   := Settings.GetBoo( hsGateAddFUpPoster );
   txtNotify.Text            := Settings.GetStr( hsMailSizeNotify );
   txtIgnore.Text            := Settings.GetStr( hsMailSizeIgnore );
   txtDelete.Text            := Settings.GetStr( hsMailSizeKill );
   emRemMailTopLines.Text    := Settings.GetStr( hsNoOfTopLinesToLoad );
   emRemMailSkipTop.Text     := Settings.GetStr( hsMailTopSkipSize );

   cbJunkAccount.Text          := Settings.GetStr( hsMailJunkAccount );
   ckJunkSkipFilt.Checked      := Settings.GetBoo( hsMailJunkSkipFiltKill );
   ckJunkSkipTrapDel.Checked   := Settings.GetBoo( hsMailJunkSkipTrapDelete );
   ckJunkSkipTrapScore.Checked := Settings.GetBoo( hsMailJunkSkipTrapScore );
   emJunkSkipScore.Text        := Settings.GetStr( hsMailJunkSkipScoreLimit );
   cbSpamReportAccount.Text    := Settings.GetStr( hsMailSpamReportAccount );
   cbNotifyAccount.Text        := Settings.GetStr( hsMailNotifyAccount );

   txtSMTPAttempts.Text      := Settings.GetStr( hsSendMailAttemptsMax );
   chkDelFailedMails.Checked := Settings.GetBoo( hsSendMailAttemptsDel );
   cbPreferredSend.Text      := Settings.GetStr( hsSmtpServer );
end;

procedure TfrmConfHam.FormToSettings;

   procedure TakeEM( ID: Integer; EM: TEdit ); overload;
   begin
      if not EM.Enabled then exit;
      if Settings.GetStr( ID ) = EM.Text then exit;
      Settings.SetStr( ID, EM.Text );
   end;

   procedure TakeEM( ID: Integer; EM: TEdit; EmptyVal: Integer ); overload;
   var  s: String;
        i: Integer;
   begin
      if not EM.Enabled then exit;
      i := strtointdef( EM.Text, EmptyVal );
      s := iif( i=EmptyVal, '', inttostr(i) );
      if Settings.GetStr( ID ) = s then exit;
      Settings.SetStr( ID, s );
   end;

   procedure TakeEM( ID: Integer; EM: TComboBox ); overload;
   begin
      if not EM.Enabled then exit;
      if Settings.GetStr( ID ) = EM.Text then exit;
      Settings.SetStr( ID, EM.Text );
   end;

   procedure TakeEM( ID: Integer; EM: TComboBox; trimIt: Boolean ); overload;
   begin
      if not EM.Enabled then exit;
      if Settings.GetStr( ID ) = Trim(EM.Text) then exit;
      Settings.SetStr( ID, Trim(EM.Text) );
   end;

   procedure TakeCK( ID: Integer; CK: TCheckBox );
   begin
      if not CK.Enabled then exit;
      if Settings.GetBoo( ID ) = CK.Checked then exit;
      Settings.SetBoo( ID, CK.Checked );
   end;

   procedure TakeCB( ID: Integer; CB: TComboBox );
   begin
      if not CB.Enabled then exit;
      if Settings.GetInt( ID ) = CB.ItemIndex then exit;
      Settings.SetInt( ID, CB.ItemIndex );
   end;

var  i: Integer;
begin
   if not Assigned( Settings ) then exit;

   // General
   TakeCK( hsDailyStatistics,         ckDailyStats );
   TakeCK( hsDailyBuildLists,         ckDailyLists );
   TakeCK( hsDailyUnsubscribe,        ckDailyUnsubs );
   i := 0;
   if ckDailyPurgeNews.Checked     then i := (i or HAM_PURGEOPT_DONEWS    );
   if ckDailyPurgeHistory.Checked  then i := (i or HAM_PURGEOPT_DOHISTORY );
   if ckDailyPurgeKills.Checked    then i := (i or HAM_PURGEOPT_DOKILLS   );
   if ckDailyPurgeMailHist.Checked then i := (i or HAM_PURGEOPT_DOMHISTORY);
   if i<>Settings.GetInt(hsDailyPurge) then Settings.SetInt( hsDailyPurge, i );
   TakeEM( hsPurgeArticlesKeepDays,   emKeepArts );
   TakeEM( hsPurgeHistoryKeepDays,    emKeepHist );
   TakeEM( hsPurgeKillsKeepDays,      emKeepKill );
   TakeEM( hsPurgeMHistoryKeepDays,   txtMailHistory );
   TakeEM( hsFQDNforMID,              emFQDN );
   TakeCB( hsPasswordCodeBase,        cbPWBase );

   // Local Servers
   TakeCK( hsLocalNntpAutostart,      chkAutoStartNntp );
   TakeEM( hsLocalNntpBind,           emNntpBind );
   TakeEM( hsLocalNntpPort,           emNntpPort );
   TakeCK( hsLocalPop3Autostart,      chkAutoStartPop3 );
   TakeEM( hsLocalPop3Bind,           emPop3Bind );
   TakeEM( hsLocalPop3Port,           emPop3Port );
   TakeCK( hsLocalSmtpAutostart,      chkAutoStartSmtp );
   TakeEM( hsLocalSmtpBind,           emSmtpBind );
   TakeEM( hsLocalSmtpPort,           emSmtpPort );
   TakeCK( hsLocalRecoAutostart,      ckRCAutostart );
   TakeEM( hsLocalRecoBind,           emRecoBind );
   TakeEM( hsLocalRecoPort,           emRCPort );

   // Local News
   TakeCK( hsGenerateNewsMID,         chkGenMID );
   TakeCK( hsNewsAddXHamster,         chkAddXHeaderNews );
   TakeCK( hsNewsAddXTrace,           ckNewsAddXTrace );
   TakeCK( hsLocalNntpGetUnknownMIDs, chkAddUnknownMIDs );
   TakeEM( hsAutoUnsubscribePulls,    emAutoDelPulls );
   TakeEM( hsAutoUnsubscribeGroups,   emAutoDelGroups );
   TakeEM( hsHamGroupDefault,         cbGrpDefault );
   TakeEM( hsHamGroupPostOk,          cbGrpPostOK );
   TakeEM( hsHamGroupPostErrors,      cbGrpPostErr );
   TakeEM( hsHamGroupStatistics,      cbGrpStats );
   TakeEM( hsHamGroupCancelNotify,    cbGrpCancels );
   TakeEM( hsHamGroupNewGroups,       cbGrpNewGrps );
   TakeEM( hsHamGroupUnknownGroup,    cbGrpUnknown );
   TakeEM( hsHamGroupPullErrors,      cbGrpPullErr );

   // Local Mail
   TakeCK( hsGenerateMailMID,         chkGenMailMID );
   TakeCK( hsMailAddXHamster,         chkAddXHeaderMail );
   TakeCK( hsMailAddReceived,         chkAddReceived );
   TakeCK( hsLocalSmtpAuthReq,        chkSmtpAuthPOP3 );
   TakeEM( hsLocalSmtpAfterPop3Time,  emSmtpPop3Time );
   TakeCK( hsLocalSmtpEAuthReq,       chkSmtpAuthAUTH );
   TakeCK( hsLocalSmtpNoAuthForLocal, chkSmtpNoAuthForLocal );
   TakeEM( hsIsLocalDomain,           emIsLocalDomain );
   TakeCK( hsLocalSmtpApplyTraps,     chkSmtpApplyTraps );

   // Local Details
   TakeEM( hsLocalTimeoutInactivity,  emInactivityTO );
   TakeEM( hsLocalTimeoutQuitDelay,   emQuitDelay );
   TakeEM( hsLocalNntpClients,        emNntpClients );
   TakeEM( hsLocalPop3Clients,        emPop3Clients );
   TakeEM( hsLocalSmtpClients,        emSmtpClients );
   TakeEM( hsLocalRecoClients,        emRecoClients );
   TakeEM( hsLocalNntpSameCli,        emNntpSame );
   TakeEM( hsLocalPop3SameCli,        emPop3Same );
   TakeEM( hsLocalSmtpSameCli,        emSmtpSame );
   TakeEM( hsLocalRecoSameCli,        emRecoSame );
   TakeEM( hsLocalNntpLimitTextSize,  emMaxBytesNNTP );
   TakeEM( hsLocalPop3LimitTextSize,  emMaxBytesPOP3 );
   TakeEM( hsLocalSmtpLimitTextSize,  emMaxBytesSMTP );
   TakeEM( hsLocalRecoLimitTextSize,  emRecoTextSize );
   TakeEM( hsLocalNntpLimitLineLen,   emMaxLinesNNTP );
   TakeEM( hsLocalPop3LimitLineLen,   emMaxLinesPOP3 );
   TakeEM( hsLocalSmtpLimitLineLen,   emMaxLinesSMTP );
   TakeEM( hsLocalRecoLimitLineLen,   emRecoLineLen );
   TakeEM( hsLocalPop3SASL,           emPop3SASL );
   TakeEM( hsLocalSmtpSASL,           emSmtpSASL );
   TakeEM( hsLocalRecoSASL,           emRecoSASL );
   TakeEM( hsLocalNntpInactivitySec,  emInactivityNntp );
   TakeEM( hsLocalPop3InactivitySec,  emInactivityPop3 );
   TakeEM( hsLocalSmtpInactivitySec,  emInactivitySmtp );
   TakeEM( hsLocalRecoInactivitySec,  emInactivityReco );

   // Remote Common
   TakeEM( hsTasksLimit,              emTasksLimit );
   TakeEM( hsRemoteTimeoutConnect,    emRemConnectTO );
   TakeEM( hsRemoteTimeoutCommand,    emRemCommandTO );
   TakeCB( hsSocksVersion,            cbSocksVer );
   TakeEM( hsSocksServer,             emSocksSrv );
   TakeEM( hsSocksPort,               emSocksPort );
   TakeCK( hsSocksAuth,               ckSocksAuth );
   TakeEM( hsSocksUser,               emSocksUser );
   TakeEM( hsSocksPass,               emSocksPass );

   // Remote News
   TakeEM( hsPullLimit,               emPullLimit );
   TakeEM( hsPullLimitFirst,          emPullFirst );
   TakeEM( hsPostServer,              cbPreferredPost );
   TakeEM( hsScoreLogLimit,           emLogLimit );
   TakeCK( hsLocalNntpLocalInjection, ckLocalInject );

   // Remote Mail
   TakeCK( hsLeaveMailsOnServer,      chkLeaveMails );
   TakeCK( hsIgnoreAlreadyLoaded,     chkIgnoreAlreadyLoaded );
   TakeCK( hsIgnoreAlreadyFiltered,   chkIgnoreAlreadyFiltered );
   TakeCK( hsLeaveButDeleteFiltered,  chkButDeleteFiltered );
   TakeEM( hsMailDeleteLoadedAfter,   emDeleteAfter, 0 );
   TakeCK( hsGateAddFUpPoster,        ckGateAddPoster );
   TakeEM( hsMailSizeNotify,          txtNotify );
   TakeEM( hsMailSizeIgnore,          txtIgnore );
   TakeEM( hsMailSizeKill,            txtDelete );
   TakeEM( hsNoOfTopLinesToLoad,      emRemMailTopLines );
   TakeEM( hsMailTopSkipSize,         emRemMailSkipTop );

   TakeEM( hsMailJunkAccount,         cbJunkAccount, True );
   TakeCK( hsMailJunkSkipFiltKill,    ckJunkSkipFilt );
   TakeCK( hsMailJunkSkipTrapDelete,  ckJunkSkipTrapDel );
   TakeCK( hsMailJunkSkipTrapScore,   ckJunkSkipTrapScore );
   TakeEM( hsMailJunkSkipScoreLimit,  emJunkSkipScore );
   TakeEM( hsMailSpamReportAccount,   cbSpamReportAccount, True );
   TakeEM( hsMailNotifyAccount,       cbNotifyAccount, True );

   TakeEM( hsSendMailAttemptsMax,     txtSMTPAttempts );
   TakeCK( hsSendMailAttemptsDel,     chkDelFailedMails );
   TakeEM( hsSmtpServer,              cbPreferredSend );

end;

function TfrmConfHam.LoadSettings: Boolean;

   procedure LoadLocalGroups;
   var  Reply: TLiveMsg;
   begin
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_GROUPS_LIST, '12'{=internal+local} )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            cbGrpDefault.Items.Text := Reply.MsgData;
            cbGrpPostOK.Items.Text  := Reply.MsgData;
            cbGrpPostErr.Items.Text := Reply.MsgData;
            cbGrpStats.Items.Text   := Reply.MsgData;
            cbGrpCancels.Items.Text := Reply.MsgData;
            cbGrpNewGrps.Items.Text := Reply.MsgData;
            cbGrpUnknown.Items.Text := Reply.MsgData;
            cbGrpPullErr.Items.Text := Reply.MsgData;
         end;
      finally Reply.Free end;
   end;

   procedure LoadServers;
   var  Reply: TLiveMsg;
   begin
      cbPreferredPost.Clear;
      cbPreferredSend.Clear;

      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_SRVNNTP_LIST, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            cbPreferredPost.Items.Text := Reply.MsgData;
         end;
      finally Reply.Free end;

      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LMREQ_SRVSMTP_LIST, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            cbPreferredSend.Items.Text := Reply.MsgData;
         end;
      finally Reply.Free end;
   end;

   function LoadList( LmReqCode: Integer ): TStringList;
   var  Reply: TLiveMsg;
   begin
      Result := TStringList.Create;
      Reply := LiveConnector.RCLiveRequest(
                  TLiveMsg.Create( LmReqCode, '' )
               );
      if Assigned( Reply ) then try
         if ( Reply.MsgType = LMREP_OK ) then begin
            Result.Text := Reply.MsgData;
         end;
      finally Reply.Free end;
   end;
   
   procedure LoadAccounts;
   var  i: Integer;
   begin
      cbJunkAccount.Clear;
      cbJunkAccount.Items.Add( ' ' ); // clear

      cbSpamReportAccount.Clear;
      cbSpamReportAccount.Items.Add( ' ' ); // clear

      cbNotifyAccount.Clear;

      with LoadList( LMREQ_ACCOUNTS_LIST ) do try
         for i := 0 to Count - 1 do begin
            ArgsWhSpaceDQuoted( Strings[i], Args, 2 );
            cbJunkAccount.Items.Add( Args[0] );
            cbSpamReportAccount.Items.Add( Args[0] );
            cbNotifyAccount.Items.Add( Args[0] );
         end;
      finally Free end;
   end;

begin
   Result := False;

   try
      if Assigned( Settings ) then FreeAndNil( Settings );

      Settings := TSettingsPlain.Create(
         SettingsDef_Hamster,
         TSettingsHandler_LiveRemote.Create(
            LiveConnector, '',
            LMREQ_HAM_SETTING_GET, LMREQ_HAM_SETTING_SET
         ),
         False {don't AutoFlush}
      );

      LoadLocalGroups;
      LoadServers;
      LoadAccounts;

      SettingsToForm;
      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Load Settings', mtError, [mbOK] );
      end;
   end;
end;

function TfrmConfHam.SaveSettings: Boolean;
begin
   Result := False;

   try
      if not Assigned( Settings ) then exit;
      FormToSettings;
      Settings.Flush;
      Result := True;

   except
      on E: Exception do begin
         HMessageDlg( 'Error:' + CRLF + E.Message,
                      'Save Settings', mtError, [mbOK] );
      end;
   end;
end;

procedure TfrmConfHam.btnRefreshClick(Sender: TObject);
begin
   btnOK.Enabled := LoadSettings;
end;

procedure TfrmConfHam.btnOKClick(Sender: TObject);
begin
   if not SaveSettings then ModalResult := mrNone;
end;

procedure TfrmConfHam.btnApplyClick(Sender: TObject);
begin
   SaveSettings;
end;

end.
