#!hs2
#!load hw_common.hsm
#!load hw_memory.hsm
#!load hw_system.hsm
#!load hw_files.hsm
#!load hw_windows.hsm
#!load hw_clipbrd.hsm
#!load hw_nt.hsm


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# hw_system.hsm
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if( ApiIsPlatformWin32NT )
   print( "ApiIsPlatformWin32NT: True - running on NT/2000/XP." )
else
   print( "ApiIsPlatformWin32NT: False - running on 95/98/ME." )
endif
print( "GetCurrentProcessId=", ApiGetCurrentProcessId )
print( "GetCurrentThreadId=",  ApiGetCurrentThreadId  )
print( "GetWindowsDirectory=", ApiGetWindowsDirectory )
print( "GetSystemDirectory=",  ApiGetSystemDirectory )


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# hw_windows.hsm
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

var( $i, $wnd, $txt )
varset( $WindowList, ListAlloc )

ApiEnumWindowsList( $WindowList )

for( $i, 0, ListCount($WindowList) )
   $wnd = ListGetTag( $WindowList, $i )
   $txt = ListGet   ( $WindowList, $i )
   print( "EnumWindows: hwnd=", hex($wnd,8), " text=", $txt )
endfor

ListFree( $WindowList )


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# hw_clipbrd.hsm
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

varset( $Text, "Text copied from script to clipboard!" )
print( "ApiCopyTextToClipboard:", $Text )
ApiCopyTextToClipboard( $Text )

varset( $Text, "(just to clear the text set above)" )
$Text = ApiPasteTextFromClipboard
print( "ApiPasteTextFromClipboard=", $Text )


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# hw_files.hsm
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

varset( $Filename, "ApiFileTest.tmp" )
var( $hFile, $dataw, $datar, $cnt, $pos )

$hFile = ApiFileOpen( $Filename )

if( $hFile = $INVALID_HANDLE_VALUE )
   print( "CreateFile failed with GetLastError=", DllLastError )
else
   # write data to file
   $dataw = "This is the data written to the file."
   $cnt = ApiFileWrite( $hFile, $dataw, len($dataw) )
   print( "ApiFileWrite bytes=", $cnt, " data=", $dataw )

   # save current position and move file pointer to beginning of file
   $pos = ApiFileSeek( $hFile, 0, $FILE_CURRENT )
   ApiFileSeek( $hFile, 0, $FILE_BEGIN )

   # read from file
   $datar = ApiFileRead( $hFile, 4096 )
   print( "ApiFileRead bytes=", len($datar), " data=", $datar )

   # return to saved position
   ApiFileSeek( $hFile, $pos, $FILE_BEGIN )

   # append text
   $dataw = " And this text was appended afterwards!"
   $cnt = ApiFileWrite( $hFile, $dataw, len($dataw) )
   print( "ApiFileWrite bytes=", $cnt, " data=", $dataw )

   # read again from beginning of file
   ApiFileSeek( $hFile, 0, $FILE_BEGIN )
   $datar = ApiFileRead( $hFile, 4096 )
   print( "ApiFileRead bytes=", len($datar), " data=", $datar )

   print( "ApiFileSize=", ApiFileSize( $hFile ) )

   # close file and delete it
   ApiFileClose( $hFile )
   FileDelete( $Filename )
endif


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# hw_nt.hsm
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if( ApiIsPlatformWin32NT )

   if( ApiEventLog( "Hamster-Testscript", "Test log entry", 42, _
                    $EVENTLOG_INFORMATION_TYPE ) )
      print( "Event log entry successful." )
   else
      print( "Event log entry failed!" )
   endif

endif


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

quit
