
#############################################################################
# RssFeedGenerator.hsc: Create a RSS 2.0 feed file from a newsgroup.
#----------------------------------------------------------------------------
# First time setup:
# 1.) DON'T USE THE ORIGINAL SCRIPT as it will be overwritten next time
#     you update Hamster. Copy or renamed it to "MyRssFeed.hsc" or similar.
# 2.) Create a local newsgroup in Hamster, solely for this purpose.
# 3.) Replace settings in below section "Configuration" with yours.
#----------------------------------------------------------------------------
# Steps to create the file:
# 1.) Post the messages to be published to the newsgroup (see below for
#     required message format) and cancel/delete any outdated messages in
#     this group.
# 2.) Start the script to create the feed file.
# 3.) Upload the generated feed file to your homepage.
#----------------------------------------------------------------------------
# Version: 2004-09-14 (Juergen Haible, Hamster Playground)
#############################################################################


#############################################################################
# Configuration
#############################################################################

# Path and name of channel file to create (extension .xml suggested,
# but anything like .rss or .txt can be used as well).

varset( $ChannelFile, "c:\online\homepage\elbiah.de\fp\news.xml" )

# Hamster group with articles to publish
#
# Article format:
#    - Title in "Subject:" header
#    - Creator in "From:" header
#    - Date in "Date:" header
#    - Link in FIRST line of body
#    - Description in remaining lines of body
#

varset( $ChannelGroup, "internal.elbiah-news-rss" )

# Channel link (a link to the site or page that is related with the channel,
# not the link for the RSS file itself)

varset( $ChannelLink, "http://www.elbiah.de/" )

# Name of channel creator (optional)

varset( $ChannelCreator, "Jrgen Haible" )

# Title of channel

varset( $ChannelTitle, "www.elbiah.de News" )

# Description of channel

varset( $ChannelDescription, "News and updates from www.elbiah.de" )

# Language of channel ("en" English, "en-us" American English, "de" German,
# "fr" French, ...)

varset( $ChannelLanguage, "en" )


#############################################################################

var( $MsgList )

LoadMessages()
CreateRssFile()
FreeMessages()

quit

#############################################################################

sub LoadMessages()

   print( "Loading messages from ", $ChannelGroup, " ..." )

   # open group
   varset( $grp, HamGroupOpen( $ChannelGroup ) )
   if( $grp < 0 )
      Error( "Could not open group " + $ChannelGroup + "!" )
   endif

   # load all messages
   $MsgList = ListAlloc
   varset( $artMin, HamArtNoMin( $grp ) )
   varset( $artMax, HamArtNoMax( $grp ) )
   var( $artNo, $artText )

   for( $artNo, $artMin, $artMax )

      $artText = HamArtText( $grp, $artNo )
      if( $artText <> "" )

         varset( $msg, MsgAlloc )
         MsgSetText( $msg, $artText )
         ListAdd( $MsgList, Str( $msg ) )

      endif

   endfor

   # close group
   HamGroupClose( $grp )

endsub

#############################################################################

sub FreeMessages()

   print( "Cleaning up ..." )

   var( $i )

   for( $i, 0, ListCount($MsgList)-1 )
      MsgFree( Int( ListGet( $MsgList, $i ) ) )
   endfor

   ListFree( $MsgList )

endsub

#############################################################################

sub CreateRssFile()

   print( "Creating RSS file ", $ChannelFile, " ..." )

   varset( $xml, ListAlloc )

   # header
   ListAdd( $xml, "<?xml version=""1.0"" encoding=""ISO-8859-1"" ?>" )
   ListAdd( $xml, "<rss version=""2.0"" xmlns:dc=""http://purl.org/dc/elements/1.1/"">" )
   ListAdd( $xml, "" )

   # channel
   ListAdd( $xml, "<channel>" )
   ListAdd( $xml, "" )
   ListAdd( $xml, "  <title>" + $ChannelTitle + "</title>" )
   ListAdd( $xml, "  <link>" + $ChannelLink + "</link>" )
   ListAdd( $xml, "  <description>" + $ChannelDescription + "</description>" )
   ListAdd( $xml, "  <language>" + $ChannelLanguage + "</language>" )
   if( $ChannelCreator <> "" )
      ListAdd( $xml, "  <dc:creator>" + $ChannelCreator + "</dc:creator>" )
   endif
   ListAdd( $xml, "  <dc:date>" + FormatDateNow + "</dc:date>" )
   ListAdd( $xml, "" )

   # items
   var( $i, $msg )
   for( $i, ListCount($MsgList) - 1, 0, -1 )

      # prepare item infos
      $msg = Int( ListGet( $MsgList, $i ) )
      varset( $title, MsgGetHeader( $msg, "Subject" ) )
      varset( $link, "" )
      varset( $body, MsgGetBody( $msg ) )
      FormatLinkBody( $link, $body )
      varset( $from, MsgGetHeader( $msg, "From" ) )
      FormatFrom( $from )
      varset( $date, MsgGetHeader( $msg, "Date" ) )
      FormatDate( $date )

      # add item
      print( "Item: ", $title, " (", $date, ")" )

      ListAdd( $xml, "  <item>" )

      ListAdd( $xml, "    <title>" + $title + "</title>" )
      if( $link <> "" )
         ListAdd( $xml, "    <link>" + $link + "</link>" )
      endif
      if( $body <> "" )
         ListAdd( $xml, "    <description>" + $body + "</description>" )
      endif
      if( $from <> "" )
         ListAdd( $xml, "    <dc:creator>" + $from + "</dc:creator>" )
      endif
      if( $date <> "" )
         ListAdd( $xml, "    <dc:date>" + $date + "</dc:date>" )
      endif

      ListAdd( $xml, "  </item>" )
      ListAdd( $xml, "" )

   endfor

   # footer
   ListAdd( $xml, "" )
   ListAdd( $xml, "</channel>" )
   ListAdd( $xml, "" )
   ListAdd( $xml, "</rss>" )

   # save file
   ListSave( $xml, $ChannelFile )
   ListFree( $xml )

endsub

#############################################################################

sub FormatLinkBody( *$link, *$body )

   varset( $tmp, ListAlloc )
   ListSetText( $tmp, $body )

   if( ListCount( $tmp ) > 0 )

      var( $line, $i )

      $line = Trim( ListGet( $tmp, 0 ) )
      if( copy( $line, 1, 7 ) = "http://" )
         $link = $line
         ListDelete( $tmp, 0 )
      endif

      $body = ""
      for( $i, 0, ListCount($tmp)-1 )
         $line = ListGet( $tmp, $i )
         $body = Trim( $body + " " + $line )
      endfor

   endif

   ListFree( $tmp )


endsub

sub FormatFrom( *$from )

   varset( $i, Pos( "<", $from ) )
   varset( $k, Pos( ">", $from ) )
   if( ($i > 0) && ($k > 0) && ($i < $k) )
      $from = Trim( delete( $from, $i, $k - $i + 1 ) )
   endif

   $i = Pos( "@", $from )
   if( $i > 0 )
      $from = copy( $from, 1, i-1 ) + "(at)" + copy( $from, i+1, 99 )
   endif

endsub

sub FormatDate( *$date )

   # varset( $time, TimeFromRfc( $date ) )
   # var( $yyyy, $mm, $dd )
   # DecodeTime( $time, $yyyy, $mm, $dd )
   # $date = Str( $yyyy, 4 ) + "-" + Str( $mm, 2 ) + "-" + Str( $dd, 2 )

endsub

sub FormatDateNow

   # varset( $time, Time )
   # var( $yyyy, $mm, $dd )
   # DecodeTime( $time, $yyyy, $mm, $dd )
   # return( Str( $yyyy, 4 ) + "-" + Str( $mm, 2 ) + "-" + Str( $dd, 2 ) )

   return( TimeToRfc( Time, 0 ) )

endsub

#############################################################################

