#!hs2
#!load hamster.hsm


########################################################################
# Script     : Demo-Session.hsc
# Description: Script, which demonstrates a complete session.
# Maintainer : Juergen Haible <juergen.haible@t-online.de>
# Version    : 2000-05-07
########################################################################
# NOTE:
# This script is delivered with Hamster and it will be overwritten when
# installing a new version of it. Therefore, it's disabled in Hamster's
# script-menu.
# You have to make a copy of this script (e.g. "MyScript.hsc") and edit
# it to suit your needs before using it. Please note also, that you have
# to restart Hamster before the copied script becomes visible in the
# script-menu.
########################################################################


########################################################################
# Make sure, that Hamster is new enough to run this script
########################################################################

# HamRequireVersion( "1.3.18.0", True )


########################################################################
# Settings and preferences
########################################################################

# Dialup-settings
var( $RASDIAL_CONNECTION, $RASDIAL_USERNAME, $RASDIAL_PASSWORD )
$RASDIAL_CONNECTION = ""     # Name of RAS-conn; "" = disable dialing
$RASDIAL_USERNAME   = ""     # Username for RAS-conn; "" = use Hamster-setting
$RASDIAL_PASSWORD   = ""     # Password for RAS-conn; "" = use Hamster-setting

# Purge-settings
var( $PURGE_BEFORE_TRANSFER )
$PURGE_BEFORE_TRANSFER = False  # True = enable purging


########################################################################
# Purging
########################################################################

if( $PURGE_BEFORE_TRANSFER )
   print( "Purging ..." )
   HamWaitIdle
   HamPurge
   HamWaitIdle
endif


########################################################################
# Dialing
########################################################################

var( $RASERR )

if( $RASDIAL_CONNECTION<>"" )
   print( "Dialing ..." )
   $RASERR = HamRasDial( $RASDIAL_CONNECTION, $RASDIAL_USERNAME, $RASDIAL_PASSWORD )
   if( $RASERR<>0 )
      Error( "Error dialing ", $RASDIAL_CONNECTION, "! RAS-Error=", $RASERR )
   endif
endif


########################################################################
# Transfering news and mails
########################################################################

print( "Transfering ..." )

# Start sending and retrieving of mails
# HamSendMail( <server>, <port>, <from-select> )
# HamFetchMail( <server>, <port>, <user>, <pass>, <destuser>, <filter> )

# Start sending and retrieving of news
HamNewsPost
HamNewsPull

# Wait until all transfer-threads have finished
HamWaitIdle


########################################################################
# Hanging up
########################################################################

if( $RASDIAL_CONNECTION<>"" )
   print( "Hanging up ..." )
   HamRasHangup
endif


########################################################################
# The End.
########################################################################

print( "Ready." )
quit

########################################################################
