# ---------------------------------------------------------------------
# Send mail with newly logged errors and warnings.
# ---------------------------------------------------------------------
# 1.) Rename this script so it will not be overwritten when updating to
#     a new Hamster version (e. g. to My-Send-Errors-By-Mail.hsc).
# 2.) Check and modify the CONFIGURATION settings below.
# 3.) Add a scheduler task to start the script frequently (e. g. daily
#     at 6am).
# ---------------------------------------------------------------------

#!load hstrings.hsm
#!load hr_functions.hsm


# ---------------------------------------------------------------------
# CONFIGURATION

# Maximum number of error lines to report (max. 100).

varset( $LinesToReport, 50 )

# Sender of error mail. Sending mail to an external server might
# require a real mail address here.
# See also script command "HamNewMail" in help file for details.

varset( $MailFrom, "admin" )

# Recipient(s) of error mail, either local account name(s) or mail
# address(es). Multiple recipients have to be separated by ";".
# See also script command "HamNewMail" in help file for details.

varset( $MailTo, "admin" )


# ---------------------------------------------------------------------
# get list of logged errors and warnings

varset( $ErrorList, ListAlloc )
LogFileListErrors( $ErrorList )

# ---------------------------------------------------------------------
# create text to report

var( $ErrorText, $i, $iMin, $iMax )

$iMax = ListCount( $ErrorList ) - 1
$iMin = $iMax - $LinesToReport + 1
if( $iMin < 0 )
   $iMin = 0
endif

$ErrorText = ""
for( $i, $iMin, $iMax )
   $ErrorText = $ErrorText + ListGet( $ErrorList, $i ) + $CRLF
endfor

# ---------------------------------------------------------------------
# check if there are new, unreported errors

varset( $NewErrors, False )

if( $ErrorText <> "" )

   varset( $NewDigest, Digest( 1, $ErrorText, True ) )
   varset( $OldDigest, IniRead( "", "", "Send-Errors-By-Mail", "?" ) )

   if( $NewDigest <> $OldDigest )
      $NewErrors = True
      IniWrite( "", "", "Send-Errors-By-Mail", $NewDigest )
   endif

endif

# ---------------------------------------------------------------------
# send error mail

if( $NewErrors )

   varset( $MailText, ListAlloc )

   ListAdd( $MailText, "From: "    + $MailFrom )
   ListAdd( $MailText, "To: "      + $MailTo )
   ListAdd( $MailText, "Subject: " + "Hamster Error Report!" )

   ListAdd( $MailText, "" ) # header/body separator

   ListAdd( $MailText, "Last logged errors and warnings follow:" )
   ListAdd( $MailText, "" )

   HamNewMail( $MailFrom, $MailTo, ListGetText($MailText) + $ErrorText )
   print( "New errors were reported to: " + $MailTo )

   ListFree( $MailText )

endif

# ---------------------------------------------------------------------
# clean up and quit

ListFree( $ErrorList )
quit

# ---------------------------------------------------------------------
