#############################################################################
# Demo-RSS-Advanced.hsc: Load RSS feeds and post its messages to a newsgroup
#----------------------------------------------------------------------------
# This script demonstrates how to load RSS feeds and post the messages of
# these feeds to a newsgroup. The script is "ready to run" and will read
# some example feeds when started.
# In contrast to "Demo-RSS-Simple.hsc", this script additionally makes sure
# that feeds are not loaded too often, e. g. by loading some rarly changed
# feeds only once per day.
#----------------------------------------------------------------------------
# Please note:
# This script will be overwritten next time you update Hamster. If you
# want to change it, be sure to rename or copy this script first (e. g.
# rename it to "MyRssReader.hsc").
#############################################################################


#############################################################################
# Declaration of global variables used in this script:
#############################################################################

var( $RssGroup, $RssMode, $RssCategory )


#############################################################################
# Name of the newsgroup where new messages should be stored:
#############################################################################

$RssGroup = "internal.misc"


#############################################################################
# Mode to use for generating messages:
#    0 = One message containing both old and new items
#    1 = Separate messages for new items
#    2 = One message containing all new items
#############################################################################

$RssMode = 2


#############################################################################
# Load feeds, but only if they were not loaded within the given amount
# of minutes (1 = 1 minute, 60 = 1 hour, 24*60 = 1 day):
#############################################################################

GlobalOnce( "RSS-OncePerMinute",    1, LoadOncePerMinute )
GlobalOnce( "RSS-OncePerHour",     60, LoadOncePerHour   )
GlobalOnce( "RSS-OncePerDay",   24*60, LoadOncePerDay    )


#############################################################################
# End of script
#############################################################################

quit


#############################################################################
# Function that loads feeds once per minute.
#############################################################################

sub LoadOncePerMinute

   # Example: World news from Yahoo
   $RssCategory = "News"
   LoadRss( "http://rss.news.yahoo.com/rss/world" )
   
endsub


#############################################################################
# Function that loads feeds once per hour.
#############################################################################

sub LoadOncePerHour

   # Example: World news from BBC and New York Times
   $RssCategory = "News"
   LoadRss( "http://news.bbc.co.uk/rss/newsonline_world_edition/front_page/rss091.xml" )
   LoadRss( "http://www.nytimes.com/services/xml/rss/nyt/International.xml" )
   
   # Example: Science news from Yahoo
   $RssCategory = "Science"
   LoadRss( "http://rss.news.yahoo.com/rss/science" )

endsub


#############################################################################
# Function that loads feeds once per day.
#############################################################################

sub LoadOncePerDay

   # Example: Science news from BBC and New York Times
   $RssCategory = "Science"
   LoadRss( "http://news.bbc.co.uk/rss/newsonline_world_edition/science/nature/rss091.xml" )
   LoadRss( "http://www.nytimes.com/services/xml/rss/nyt/Science.xml" )
   
   # Example: Security news from US-CERT and Microsoft
   $RssCategory = "Security"
   LoadRss( "http://www.us-cert.gov/channels/cas.rdf" )
   LoadRss( "http://www.microsoft.com/technet/security/bulletin/secrss.aspx" )

   # Example: Updates and news from elbiah.de (Hamster Playground)
   $RssCategory = "Hamster"
   LoadRss( "http://www.elbiah.de/news.xml" )

endsub



#############################################################################
# Helper function that calls 'HamWebReader' command with given parameters.
#############################################################################

sub LoadRss( $RssLink )

   if( $RssCategory = "" )
      HamWebReader( $RssLink, $RssGroup, "", $RssMode )
   else
      HamWebReader( $RssLink, $RssGroup, "[" + $RssCategory + "] *", $RssMode )
   endif

endsub

#############################################################################
