#############################################################################
# Demo-RBL-Check.hsc: Use real-time black lists (RBL) to mark spam messages.
#----------------------------------------------------------------------------
# This script checks all mail messages fetched from a POP3 server against the
# real-time black lists configured below. If an offending mail is detected,
# a "X-RBL-Warning:" header line is added to the message so it can be
# filtered in Hamster Playground by "Mail Traps" or by "MailFilt.hst".
#----------------------------------------------------------------------------
# Usage:
# 1.) Rename this script, e. g. to "My-RBL-Check.hsc", as it will be
#     overwritten next time you update Hamster.
# 2.) Modify/add ListAdd() lines below for all RBL hosts to be checked.
# 3.) Assign your script to the "MailInHeader" action with HControl:
#        Menu: Tasks -> Setup Action Tasks -> MailInHeader
#     Be sure to activate option "[X] Wait" for this action, but do NOT
#     activate option "[ ] Lock" in this case (takes too long).
#----------------------------------------------------------------------------
# Credits:
#    RblChecker.hsm is based on "rblcheck.hsc" script for Hamster Classic
#    maintained by Rolf Leggewie (see: http://leggewie.biz/hamster.htm).
#############################################################################

#!load RblChecker.hsm


#############################################################################
# Add one or more RBL hosts to be checked to the $RblHostList list
#############################################################################

# spam sources
ListAdd( $RblHostList, "sbl-xbl.spamhaus.org" )
ListAdd( $RblHostList, "l1.spews.dnsbl.sorbs.net" )

# open relays
ListAdd( $RblHostList, "relays.ordb.org" )

# various (spam sources, open relays, dynamic IPs)
ListAdd( $RblHostList, "dnsbl.sorbs.net" )

# Gets country code as result (i. e. has nothing to do with "spam"
# directly, but may be used to score up/down based on country)
ListAdd( $RblHostList, "zz.countries.nerd.dk" )

# set comments for host specific results (optional)
RblSetDefaultComments
# ListSetKey( $RblComments, "rbl.example.com" + "127.0.0.2", "open relay" )

#############################################################################
# Check mail against above RBL hosts and quit
#############################################################################

RblCheckAction

quit

#############################################################################
