
#!meta ParamTitle "Delete article by Message-ID"
#!meta ParamCount 1
#!meta ParamPrompt 1 "Message-ID:"
#!meta ParamDefault 1 "<abc123@example.com>"

if( ParamCount <> 1 )
   error( "Missing Message-ID!" )
endif

varset( $MID, ParamStr(1) )

if( copy( $MID, 1, 1 ) <> "<" )
   $MID = "<" + $MID
endif
if( copy( $MID, len($MID), 1 ) <> ">" )
   $MID = $MID + ">"
endif

if( HamArtDeleteMid( $MID ) = 0 )
   print( "Article with Message-ID ", $MID, " deleted." )
else
   warning( "No article with Message-ID ", $MID, " found!" )
endif
