unit DStatus;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

Var
   Stop, Fortschrittsanzeige: boolean;

type
  TDlgStatus = class(TForm)
    Label1: TLabel;
    labGruppe: TLabel;
    pGruppen: TProgressBar;
    pGruppe: TProgressBar;
    Label5: TLabel;
    labOwn: TLabel;
    Label7: TLabel;
    labFUps: TLabel;
    Label2: TLabel;
    labGes: TLabel;
    labFupstext: TLabel;
    labOwnText: TLabel;
    Label8: TLabel;
    labMails: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

Procedure AnzeigeOeffnen (Const Titel: String);
Procedure AnzeigeSchliessen;

Procedure GruppenInit (Const Min, Max: Longint);
Procedure GruppenFortschritt (Const Pos: Longint);

Procedure GruppeInit (Const Min, Max: Longint);
Procedure GruppeFortschritt (Const Pos: Longint);
Procedure ZeigeGruppenname (Const Bez: String);

Procedure FupsAnzahl (Const Anz: LongInt; Const s: String);
Procedure InThreadAnzahl (Const Anz: LongInt; Const s: String);
Procedure GesAnzahl (Const Anz: LongInt);
Procedure MailAnzahl (Const Anz: LongInt);

implementation

{$R *.DFM}

Var Dlg: TDlgStatus;

Procedure AnzeigeOeffnen (Const Titel: String);
begin
   If Not Fortschrittsanzeige then exit;
   Dlg := TDlgStatus.Create(Nil);
   Dlg.Caption := Titel;
   Dlg.Show
end;

Procedure AnzeigeSchliessen;
begin
   If Not Fortschrittsanzeige then exit;
   Dlg.free
end;

Procedure GruppenInit (Const Min, Max: Longint);
begin
   If Not Fortschrittsanzeige then exit;
   With Dlg do begin
      pGruppen.Min := Min; pGruppen.Max := Max
   end;
   GruppenFortschritt(0)
end;
Procedure GruppenFortschritt (Const Pos: Longint);
begin
   If Not Fortschrittsanzeige then exit;
   Dlg.pGruppen.Position := Pos;
   Application.ProcessMessages
end;

Procedure GruppeInit (Const Min, Max: Longint);
begin
   If Not Fortschrittsanzeige then exit;
   With Dlg do begin
      pGruppe.Min := Min; pGruppe.Max := Max
   end;
   GruppeFortschritt(0)
end;
Procedure GruppeFortschritt (Const Pos: Longint);
begin
   If Not Fortschrittsanzeige then exit;
   Dlg.pGruppe.Position := Pos;
   Application.ProcessMessages
end;

Procedure ZeigeGruppenname (Const Bez: String);
begin
   If Not Fortschrittsanzeige then exit;
   Dlg.labGruppe.caption := Bez;
   Application.ProcessMessages
end;

Procedure FupsAnzahl (Const Anz: LongInt; Const s: String);
begin
   If Not Fortschrittsanzeige then exit;
   With Dlg.labFUps do
      If Anz>=0 then Caption := Inttostr(Anz)
                else Caption := '-';
   Dlg.labFupsText.caption := s;
   Application.ProcessMessages
end;

Procedure InThreadAnzahl (Const Anz: LongInt; Const s: String);
begin
   If Not Fortschrittsanzeige then exit;
   With Dlg.labOwn do
      If Anz>=0 then Caption := Inttostr(Anz)
                else Caption := '-';
   Dlg.labOwnText.caption := s;
   Application.ProcessMessages
end;

Procedure GesAnzahl (Const Anz: LongInt);
begin
   If Not Fortschrittsanzeige then exit;
   With Dlg.labGes do
      If Anz>=0 then Caption := Inttostr(Anz)
                else Caption := '-';
   Application.ProcessMessages
end;

Procedure MailAnzahl (Const Anz: LongInt);
begin
   If Not Fortschrittsanzeige then exit;
   With Dlg.labMails do
      If Anz>=0 then Caption := Inttostr(Anz)
                else Caption := '-';
   Application.ProcessMessages
end;

procedure TDlgStatus.Button1Click(Sender: TObject);
begin
   Stop := true
end;

end.
