'WSH-Script: HExport.vbs

'Get commandline-paramters
Set objArgs = Wscript.Arguments
If objArgs.Count<2 Then
   Wscript.Echo "Usage: cscript export.vbs groupname exportfile"
   Wscript.Quit
Else
   GroupName   = objArgs(0)
   strDestFile = objArgs(1)
End If

'Inititalize Hamster-object
Set Hamster = Wscript.CreateObject( "Hamster.App" )

'Open group
GrpHdl = Hamster.NewsGrpOpen( GroupName )
If GrpHdl>=0 Then

   'Create destination-file
   Set objFS = CreateObject( "Scripting.FileSystemObject" )
   Set objDestFile = objFS.CreateTextFile( strDestFile, True )

   'Loop through all available articles
   For ArtNo=Hamster.NewsArtNoMin(GrpHdl) To Hamster.NewsArtNoMax(GrpHdl)
      'Get article in export-format and save it in export-file
      ArticleText = Hamster.NewsArtTextExport( GrpHdl, ArtNo ) 
      objDestFile.Write( ArticleText )
   Next

   'Close files
   objDestFile.Close
   Hamster.NewsGrpClose( GrpHdl )

Else

   Wscript.Echo "Could not open group " + GroupName + "!"

End If

'Release Hamster-object
Wscript.DisconnectObject Hamster
