'Demo-Session.vbs

'Preferences
Const RASDIAL_CONNECTION     = ""         'Name of RAS-conn; "" = disable dialing
Const RASDIAL_USERNAME       = ""         'Username for RAS-conn; "" = use Hamster-setting
Const RASDIAL_PASSWORD       = ""         'Password for RAS-conn; "" = use Hamster-setting
Const PURGE_BEFORE_TRANSFER  = False      'True = enable purging

'Initialize Hamster-constants
Const HAM_PURGEOPT_DOALL     = &HF
Const HAM_PURGEOPT_DONEWS    = &H1
Const HAM_PURGEOPT_DOHISTORY = &H2
Const HAM_PURGEOPT_DOKILLS   = &H4
Const HAM_WAITIDLE_INFINITE  = 0

'Initialize Hamster-object
'Note: Hamster.exe will be loaded now if does not run already.
WScript.Echo "Initializing Hamster ..."
Set Hamster = Wscript.CreateObject( "Hamster.App" )

If PURGE_BEFORE_TRANSFER Then
   WScript.Echo "Purging ..."
   Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
   Hamster.ControlRunPurge HAM_PURGEOPT_DOALL
   Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
End If

If RASDIAL_CONNECTION<>"" Then
   WScript.Echo "Dialing ..."
   If Not Hamster.RasDial( RASDIAL_CONNECTION, RASDIAL_USERNAME, RASDIAL_PASSWORD ) Then
      Err.Raise 65535, "Error at Hamster.RasDial", "RasLastError=" & Hamster.RasLastError
      WScript.Quit
   End If
End If

WScript.Echo "Transfering ..."
Hamster.ControlRunMail ""
Hamster.ControlRunNewsPost ""
Hamster.ControlRunNewsPull ""
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

If RASDIAL_CONNECTION<>"" Then
   WScript.Echo "Hanging up ..."
   Hamster.RasHangup
End If

'Release Hamster-object
WScript.Echo "Release Hamster ..."
Wscript.DisconnectObject Hamster

WScript.Echo "Ready."
