# Demo-Session.pl

use Win32::OLE;
use Win32::Event;

# Preferences
$RASDIAL_CONNECTION     = "";        # Name of RAS-conn; "" = disable dialing
$RASDIAL_USERNAME       = "";        # Username for RAS-conn; "" = use Hamster-setting
$RASDIAL_PASSWORD       = "";        # Password for RAS-conn; "" = use Hamster-setting
$PURGE_BEFORE_TRANSFER  = 0;         # 1 = enable purging

# Initialize Hamster-constants
$HAM_PURGEOPT_DOALL     = 0xff;
$HAM_PURGEOPT_DONEWS    = 0x1;
$HAM_PURGEOPT_DOHISTORY = 0x2;
$HAM_PURGEOPT_DOKILLS   = 0x4;
$HAM_WAITIDLE_INFINITE  = 0;

# Initialize Hamster-objects
# Note: Hamster.exe will be started now if it does not run already.
print "Initializing Hamster ...\n";
$Hamster = Win32::OLE->new("Hamster.App");
$evtHamsterIsIdle = Win32::Event->open("evtHamster.IsIdle");

if( $PURGE_BEFORE_TRANSFER ) {
    print "Purging ...\n";
    $evtHamsterIsIdle->wait();
    $Hamster->ControlRunPurge( $HAM_PURGEOPT_DOALL );
    $evtHamsterIsIdle->wait();
}

if( $RASDIAL_CONNECTION ne "" ) {
    print "Dialing ...\n";
    $Hamster->RasDial( $RASDIAL_CONNECTION, $RASDIAL_USERNAME, $RASDIAL_PASSWORD )
      || die "RasDial failed with RasLastError=", $Hamster->RasLastError;
}

print "Transfering ...\n";
$Hamster->ControlRunMail( "" );
$Hamster->ControlRunNewsPost( "" );
$Hamster->ControlRunNewsPull( "" );
$evtHamsterIsIdle->wait();

if( $RASDIAL_CONNECTION ne "" ) {
    print "Hanging up ...\n";
    $Hamster->RasHangup;
}

# Release Hamster-object
print "Release Hamster ...\n";
undef $Hamster;

print "Ready.\n";

